/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.logger.CyLogger;
import cytoscape.visual.Arrow;
import cytoscape.visual.LabelPosition;
import cytoscape.visual.LineStyle;
import cytoscape.visual.LineType;
import cytoscape.visual.NodeShape;
import cytoscape.visual.ui.LabelPlacerGraphic;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.HashMap;
import javax.swing.ImageIcon;

@Deprecated
public class IconSupport {
    private ImageIcon currentIcon;
    private ImageIcon[] icons;
    private HashMap sToI;
    private static Font defaultFont = new Font("SansSerif", 0, 8);

    public IconSupport() {
    }

    public IconSupport(Object o) {
        if (o instanceof Arrow) {
            this.init(o, (byte)2);
        } else if (o instanceof NodeShape) {
            this.init(o, (byte)5);
        } else if (o instanceof LineType) {
            this.init(o, (byte)1);
        }
    }

    public IconSupport(Object startObject, byte type) {
        this.init(startObject, type);
    }

    private void init(Object startObject, byte type) {
        this.icons = null;
        this.sToI = null;
        HashMap iToS = null;
        switch (type) {
            case 2: {
                this.icons = IconSupport.getArrowIcons();
                iToS = IconSupport.getArrowToStringHashMap(25);
                this.sToI = IconSupport.getStringToArrowHashMap(25);
                break;
            }
            case 5: {
                this.icons = IconSupport.getShapeIcons();
                iToS = IconSupport.getShapeByteToStringHashMap();
                this.sToI = IconSupport.getStringToShapeByteHashMap();
                break;
            }
            case 1: {
                this.icons = IconSupport.getLineTypeIcons();
                iToS = IconSupport.getLineTypeToStringHashMap();
                this.sToI = IconSupport.getStringToLineTypeHashMap();
            }
        }
        this.currentIcon = null;
        if (startObject != null) {
            int iconIndex;
            String ltName = (String)iToS.get(startObject);
            for (iconIndex = 0; iconIndex < this.icons.length && !this.icons[iconIndex].getDescription().equals(ltName); ++iconIndex) {
            }
            if (iconIndex == this.icons.length) {
                CyLogger.getLogger().warn("Icon for object " + startObject + " not found!");
                iconIndex = 0;
            }
            this.currentIcon = this.icons[iconIndex];
        }
    }

    public ImageIcon[] getIcons() {
        return this.icons;
    }

    public ImageIcon getCurrentIcon() {
        return this.currentIcon;
    }

    public Object getIconType(ImageIcon i) {
        if (i != null) {
            return this.sToI.get(i.getDescription());
        }
        return null;
    }

    public static HashMap getStringToArrowHashMap(int nodeSize) {
        HashMap<String, Arrow> h = new HashMap<String, Arrow>();
        h.put("NONE", Arrow.NONE);
        h.put("COLOR_DIAMOND", Arrow.DIAMOND);
        h.put("COLOR_DELTA", Arrow.DELTA);
        h.put("COLOR_T", Arrow.T);
        h.put("COLOR_CIRCLE", Arrow.CIRCLE);
        h.put("COLOR_ARROW", Arrow.ARROW);
        return h;
    }

    public static HashMap getArrowToStringHashMap(int nodeSize) {
        HashMap<Arrow, String> h = new HashMap<Arrow, String>();
        h.put(Arrow.NONE, "NONE");
        h.put(Arrow.DIAMOND, "COLOR_DIAMOND");
        h.put(Arrow.DELTA, "COLOR_DELTA");
        h.put(Arrow.CIRCLE, "COLOR_CIRCLE");
        h.put(Arrow.T, "COLOR_T");
        h.put(Arrow.ARROW, "COLOR_ARROW");
        return h;
    }

    public static ImageIcon[] getArrowIcons() {
        ImageIcon[] arrowIcons = new ImageIcon[]{new ImageIcon(IconSupport.locateImage("/cytoscape/images/edgeEnds/arrow_none.jpg"), "NONE"), new ImageIcon(IconSupport.locateImage("/cytoscape/images/edgeEnds/COLOR_DIAMOND.jpg"), "COLOR_DIAMOND"), new ImageIcon(IconSupport.locateImage("/cytoscape/images/edgeEnds/COLOR_DELTA.jpg"), "COLOR_DELTA"), new ImageIcon(IconSupport.locateImage("/cytoscape/images/edgeEnds/COLOR_CIRCLE.jpg"), "COLOR_CIRCLE"), new ImageIcon(IconSupport.locateImage("/cytoscape/images/edgeEnds/COLOR_ARROW.jpg"), "COLOR_ARROW"), new ImageIcon(IconSupport.locateImage("/cytoscape/images/edgeEnds/COLOR_T.jpg"), "COLOR_T")};
        return arrowIcons;
    }

    public static HashMap getStringToShapeByteHashMap() {
        HashMap<String, NodeShape> h = new HashMap<String, NodeShape>();
        h.put("ELLIPSE", NodeShape.ELLIPSE);
        h.put("ROUND_RECT", NodeShape.ROUND_RECT);
        h.put("RECTANGLE", NodeShape.RECT);
        h.put("DIAMOND", NodeShape.DIAMOND);
        h.put("HEXAGON", NodeShape.HEXAGON);
        h.put("OCTAGON", NodeShape.OCTAGON);
        h.put("PARALLELOGRAM", NodeShape.PARALLELOGRAM);
        h.put("TRIANGLE", NodeShape.TRIANGLE);
        return h;
    }

    public static HashMap getShapeByteToStringHashMap() {
        HashMap<NodeShape, String> h = new HashMap<NodeShape, String>();
        h.put(NodeShape.ELLIPSE, "ELLIPSE");
        h.put(NodeShape.ROUND_RECT, "ROUND_RECT");
        h.put(NodeShape.RECT, "RECTANGLE");
        h.put(NodeShape.DIAMOND, "DIAMOND");
        h.put(NodeShape.HEXAGON, "HEXAGON");
        h.put(NodeShape.OCTAGON, "OCTAGON");
        h.put(NodeShape.PARALLELOGRAM, "PARALLELOGRAM");
        h.put(NodeShape.TRIANGLE, "TRIANGLE");
        return h;
    }

    public static ImageIcon[] getShapeIcons() {
        ImageIcon[] shapeIcons = new ImageIcon[]{new ImageIcon(IconSupport.locateImage("images/ellipse.jpg"), "ELLIPSE"), new ImageIcon(IconSupport.locateImage("images/round_rect.jpg"), "ROUND_RECT"), new ImageIcon(IconSupport.locateImage("images/rect.jpg"), "RECTANGLE"), new ImageIcon(IconSupport.locateImage("images/diamond.jpg"), "DIAMOND"), new ImageIcon(IconSupport.locateImage("images/hexagon.jpg"), "HEXAGON"), new ImageIcon(IconSupport.locateImage("images/octagon.jpg"), "OCTAGON"), new ImageIcon(IconSupport.locateImage("images/parallelogram.jpg"), "PARALLELOGRAM"), new ImageIcon(IconSupport.locateImage("images/triangle.jpg"), "TRIANGLE")};
        return shapeIcons;
    }

    public static HashMap getStringToLineTypeHashMap() {
        HashMap<String, LineType> h = new HashMap<String, LineType>();
        h.put("DASHED_3", new LineType(LineStyle.LONG_DASH, Float.valueOf(3.0f)));
        h.put("LINE_3", new LineType(LineStyle.SOLID, Float.valueOf(3.0f)));
        return h;
    }

    public static HashMap getLineTypeToStringHashMap() {
        HashMap<LineType, String> h = new HashMap<LineType, String>();
        h.put(new LineType(LineStyle.LONG_DASH, Float.valueOf(3.0f)), "DASHED_3");
        h.put(new LineType(LineStyle.SOLID, Float.valueOf(3.0f)), "LINE_3");
        return h;
    }

    public static ImageIcon[] getLineTypeIcons() {
        ImageIcon[] lineTypeIcons = new ImageIcon[]{new ImageIcon(IconSupport.locateImage("images/line_3.jpg"), "LINE_3"), new ImageIcon(IconSupport.locateImage("images/dashed_3.jpg"), "DASHED_3")};
        return lineTypeIcons;
    }

    private static URL locateImage(String imageFilename) {
        IconSupport is = new IconSupport();
        return is.getClass().getResource(imageFilename);
    }

    public static ImageIcon getColorIcon(Color c) {
        int size = 30;
        BufferedImage bi = new BufferedImage(size, size, 1);
        Graphics2D g2 = bi.createGraphics();
        g2.setPaint(c);
        g2.fillRect(0, 0, size, size);
        return new ImageIcon(bi);
    }

    public static ImageIcon getNodeWidthIcon(Double d) {
        int w = d.intValue();
        int bound = 4;
        int edgeHeight = 4;
        int height = 30;
        String s = Integer.toString(w);
        BufferedImage bi = new BufferedImage(w + bound + bound, height, 1);
        Graphics2D g2 = bi.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setFont(defaultFont);
        int stringWidth = g2.getFontMetrics().stringWidth(s);
        g2.setBackground(Color.white);
        g2.setPaint(Color.white);
        g2.fillRect(0, 0, w + bound + bound, height);
        g2.setPaint(Color.black);
        g2.drawLine(bound, height / 2 + edgeHeight, bound, height / 2 - edgeHeight);
        g2.drawLine(w + bound, height / 2 + edgeHeight, w + bound, height / 2 - edgeHeight);
        g2.drawLine(bound, height / 2, w + bound, height / 2);
        g2.setPaint(Color.black);
        g2.drawString(s, w / 2 + bound - stringWidth / 2, height / 2 - edgeHeight);
        return new ImageIcon(bi);
    }

    public static ImageIcon getNodeHeightIcon(Double d) {
        int h = d.intValue();
        int bound = 4;
        int edgeWidth = 4;
        int width = 40;
        String s = Integer.toString(h);
        BufferedImage bi = new BufferedImage(width, h + bound + bound, 1);
        Graphics2D g2 = bi.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setFont(defaultFont);
        int stringHeight = g2.getFontMetrics().getMaxAscent();
        g2.setBackground(Color.white);
        g2.setPaint(Color.white);
        g2.fillRect(0, 0, width, h + bound + bound);
        g2.setPaint(Color.black);
        g2.drawLine(bound, bound, bound + edgeWidth + edgeWidth, bound);
        g2.drawLine(bound, h + bound, bound + edgeWidth + edgeWidth, h + bound);
        g2.drawLine(bound + edgeWidth, bound, bound + edgeWidth, h + bound);
        g2.setPaint(Color.black);
        g2.drawString(s, bound + edgeWidth + edgeWidth, (h + bound + bound) / 2 + stringHeight / 2);
        return new ImageIcon(bi);
    }

    public static ImageIcon getNodeSizeIcon(Double d) {
        int size = d.intValue();
        int bound = 4;
        String s = Integer.toString(size);
        BufferedImage bi = new BufferedImage(size + bound + bound, size + bound + bound, 1);
        Graphics2D g2 = bi.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setFont(defaultFont);
        g2.setBackground(Color.white);
        g2.setPaint(Color.white);
        g2.fillRect(0, 0, size + bound + bound, size + bound + bound);
        g2.setPaint(Color.black);
        g2.drawLine(bound, bound, bound, size + bound);
        g2.drawLine(bound, size + bound, size + bound, size + bound);
        g2.setPaint(Color.black);
        g2.drawString(s, bound + bound, size);
        return new ImageIcon(bi);
    }

    public static ImageIcon getLabelPositionIcon(LabelPosition pos) {
        int size = 60;
        BufferedImage bi = new BufferedImage(size, size, 1);
        Graphics2D g2 = bi.createGraphics();
        LabelPlacerGraphic lp = new LabelPlacerGraphic(pos, size, false);
        lp.paint(g2);
        return new ImageIcon(bi);
    }
}

