/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.logger.CyLogger;
import cytoscape.util.CyColorChooser;
import cytoscape.visual.Arrow;
import cytoscape.visual.LabelPosition;
import cytoscape.visual.LineType;
import cytoscape.visual.NodeShape;
import cytoscape.visual.ui.IconSupport;
import cytoscape.visual.ui.PopupFontChooser;
import cytoscape.visual.ui.PopupIconChooser;
import cytoscape.visual.ui.PopupLabelPositionChooser;
import cytoscape.visual.ui.PopupStringChooser;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.text.DecimalFormat;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.plaf.metal.MetalButtonUI;

@Deprecated
public class ValueDisplayer
extends JButton {
    public static DecimalFormat formatter = new DecimalFormat("0.0####");
    public static final byte COLOR = 0;
    public static final byte LINETYPE = 1;
    public static final byte ARROW = 2;
    public static final byte STRING = 3;
    public static final byte DOUBLE = 4;
    public static final byte NODESHAPE = 5;
    public static final byte INT = 6;
    public static final byte FONT = 7;
    public static final byte LABEL_POSITION = 8;
    protected byte dispType;
    private Object inputObj = null;
    private String title;
    private JDialog parent;
    private ActionListener inputListener;
    private static Font defaultDisplayFont = new Font(null, 0, 1);

    public Object getSelectedItem() {
        return this.getValue();
    }

    public Object getValue() {
        return this.inputObj;
    }

    public ActionListener getInputListener() {
        return this.inputListener;
    }

    public byte getType() {
        return this.dispType;
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
    }

    private ValueDisplayer(JDialog parent, String labelText, String title, byte dispType) {
        super(labelText);
        this.setBorderPainted(false);
        this.parent = parent;
        this.dispType = dispType;
        this.title = title;
    }

    private ValueDisplayer(JDialog parent, String title, byte dispType) {
        this(parent, null, title, dispType);
    }

    public static ValueDisplayer getDisplayForLabelPosition(JDialog parent, String title, LabelPosition c) {
        ValueDisplayer v = new ValueDisplayer(parent, c.shortString(), title, 8);
        v.setInputLabelPositionListener();
        v.inputObj = c;
        return v;
    }

    private void setInputLabelPositionListener() {
        this.inputListener = new LabelPositionListener(this);
        this.addActionListener(this.inputListener);
    }

    public static ValueDisplayer getDisplayForColor(JDialog parent, String title, Color c) {
        String dispString = "   ";
        ValueDisplayer v = new ValueDisplayer(parent, dispString, title, 0);
        v.setUI(new MetalButtonUI());
        if (c != null) {
            v.setOpaque(true);
            v.setBackground(c);
            v.inputObj = c;
        } else {
            v.setOpaque(false);
            v.setBackground(null);
            v.inputObj = null;
        }
        v.setInputColorListener();
        return v;
    }

    private void setInputColorListener() {
        this.inputListener = new ColorListener(this);
        this.addActionListener(this.inputListener);
    }

    protected void fireItemSelected() {
        CyLogger.getLogger().info("----------Firing!: ");
        this.fireItemStateChanged(new ItemEvent(this, 701, this.inputObj, 1));
    }

    public void setObject(Object o) throws ClassCastException {
        this.inputObj = o;
        if (o instanceof Icon) {
            this.setIcon((Icon)o);
        } else if (o instanceof LabelPosition) {
            this.setText(((LabelPosition)o).shortString());
        } else if (o instanceof Color) {
            this.setBackground((Color)o);
        } else if (o instanceof Font) {
            Font f = (Font)o;
            this.setSelectedFont(f);
        } else {
            this.setText(o.toString());
        }
    }

    private static ValueDisplayer getDisplayForFont(JDialog parent, String title, Font startFont) {
        ValueDisplayer v = new ValueDisplayer(parent, title, 7);
        v.setSelectedFont(startFont);
        v.setInputFontListener();
        return v;
    }

    private void setSelectedFont(Font f) {
        this.inputObj = f;
        this.setFont(f);
        this.setText(f.getFontName());
    }

    private void setInputFontListener() {
        this.inputListener = new FontListener(this);
        this.addActionListener(this.inputListener);
    }

    private static ValueDisplayer getDisplayForIcons(JDialog parent, String title, Object startObj, byte type) {
        ValueDisplayer v = new ValueDisplayer(parent, title, type);
        v.setInputIconListener(title, title, startObj, parent, type);
        return v;
    }

    private void setInputIconListener(String title, String objectName, Object startObject, JDialog parentDialog, byte type) {
        IconSupport is = new IconSupport(startObject, type);
        if (startObject != null) {
            this.setContentAreaFilled(false);
            this.setIcon(is.getCurrentIcon());
            this.inputObj = is.getIconType(is.getCurrentIcon());
        }
        this.inputListener = new IconListener(title, objectName, is, parentDialog, this);
        this.addActionListener(this.inputListener);
    }

    private void addStringListener(String prompt, byte type) {
        this.inputListener = new StringListener(prompt, type);
        this.addActionListener(this.inputListener);
    }

    private static ValueDisplayer getDisplayForString(JDialog parent, String title, String init) {
        ValueDisplayer v = new ValueDisplayer(parent, init, title, 3);
        v.addStringListener("Input a string:", (byte)3);
        return v;
    }

    private static ValueDisplayer getDisplayForDouble(JDialog parent, String title, double init) {
        ValueDisplayer v = new ValueDisplayer(parent, formatter.format(init), title, 4);
        v.addStringListener("Input a double:", (byte)4);
        return v;
    }

    private static ValueDisplayer getDisplayForInt(JDialog parent, String title, int init) {
        ValueDisplayer v = new ValueDisplayer(parent, Integer.toString(init), title, 6);
        v.addStringListener("Input an integer:", (byte)6);
        return v;
    }

    public static ValueDisplayer getBlankDisplayFor(JDialog parent, String title, byte type) {
        switch (type) {
            case 0: {
                return ValueDisplayer.getDisplayForColor(parent, title, null);
            }
            case 1: {
                return ValueDisplayer.getDisplayForIcons(parent, title, null, (byte)1);
            }
            case 5: {
                return ValueDisplayer.getDisplayForIcons(parent, title, (Object)NodeShape.ELLIPSE, (byte)5);
            }
            case 2: {
                return ValueDisplayer.getDisplayForIcons(parent, title, Arrow.NONE, (byte)2);
            }
            case 3: {
                return ValueDisplayer.getDisplayForString(parent, title, null);
            }
            case 4: {
                return ValueDisplayer.getDisplayForDouble(parent, title, 0.0);
            }
            case 6: {
                return ValueDisplayer.getDisplayForInt(parent, title, 0);
            }
            case 7: {
                return ValueDisplayer.getDisplayForFont(parent, title, defaultDisplayFont);
            }
            case 8: {
                return ValueDisplayer.getDisplayForLabelPosition(parent, title, new LabelPosition());
            }
        }
        throw new ClassCastException("ValueDisplayer didn't understand type flag " + type);
    }

    public static ValueDisplayer getBlankDisplayFor(JDialog parent, String title, Object sampleObj) {
        if (sampleObj instanceof Color) {
            return ValueDisplayer.getDisplayForColor(parent, title, null);
        }
        if (sampleObj instanceof LineType) {
            return ValueDisplayer.getDisplayForIcons(parent, title, null, (byte)1);
        }
        if (sampleObj instanceof Byte || sampleObj instanceof NodeShape) {
            return ValueDisplayer.getDisplayForIcons(parent, title, null, (byte)5);
        }
        if (sampleObj instanceof Arrow) {
            return ValueDisplayer.getDisplayForIcons(parent, title, null, (byte)2);
        }
        if (sampleObj instanceof String) {
            return ValueDisplayer.getDisplayForString(parent, title, null);
        }
        if (sampleObj instanceof Number) {
            if (sampleObj instanceof Float || sampleObj instanceof Double) {
                return ValueDisplayer.getDisplayForDouble(parent, title, 0.0);
            }
            return ValueDisplayer.getDisplayForInt(parent, title, 0);
        }
        if (sampleObj instanceof Font) {
            return ValueDisplayer.getDisplayForFont(parent, title, defaultDisplayFont);
        }
        if (sampleObj instanceof LabelPosition) {
            return ValueDisplayer.getDisplayForLabelPosition(parent, title, new LabelPosition());
        }
        throw new ClassCastException("ValueDisplayer doesn't know how to display type " + sampleObj.getClass().getName());
    }

    public static ValueDisplayer getDisplayFor(JDialog parent, String title, Object o) throws ClassCastException {
        if (o instanceof Color) {
            return ValueDisplayer.getDisplayForColor(parent, title, (Color)o);
        }
        if (o instanceof LineType) {
            return ValueDisplayer.getDisplayForIcons(parent, title, o, (byte)1);
        }
        if (o instanceof Byte || o instanceof NodeShape) {
            return ValueDisplayer.getDisplayForIcons(parent, title, o, (byte)5);
        }
        if (o instanceof Arrow) {
            return ValueDisplayer.getDisplayForIcons(parent, title, o, (byte)2);
        }
        if (o instanceof String) {
            return ValueDisplayer.getDisplayForString(parent, title, (String)o);
        }
        if (o instanceof Number) {
            if (o instanceof Float || o instanceof Double) {
                return ValueDisplayer.getDisplayForDouble(parent, title, ((Number)o).doubleValue());
            }
            return ValueDisplayer.getDisplayForInt(parent, title, ((Number)o).intValue());
        }
        if (o instanceof Font) {
            return ValueDisplayer.getDisplayForFont(parent, title, (Font)o);
        }
        if (o instanceof LabelPosition) {
            return ValueDisplayer.getDisplayForLabelPosition(parent, title, (LabelPosition)o);
        }
        if (o != null) {
            throw new ClassCastException("ValueDisplayer doesn't know how to display type " + o.getClass());
        }
        return null;
    }

    private class StringListener
    extends AbstractAction {
        private byte type;
        private String prompt;

        StringListener(String prompt, byte type) {
            super("ValueDisplayer StringListener");
            this.prompt = prompt;
            this.type = type;
        }

        public void actionPerformed(ActionEvent e) {
            Object o;
            if (this.enabled && (o = PopupStringChooser.showDialog(ValueDisplayer.this.parent, ValueDisplayer.this.title, this.prompt, ValueDisplayer.this.inputObj, this.type)) != null) {
                ValueDisplayer.this.inputObj = o;
                ValueDisplayer.this.setText(ValueDisplayer.this.inputObj.toString());
                ValueDisplayer.this.fireItemSelected();
            }
        }
    }

    private class IconListener
    extends AbstractAction {
        private PopupIconChooser chooser;
        private ValueDisplayer parent;
        private IconSupport is;

        IconListener(String title, String objectName, IconSupport is, JDialog parentDialog, ValueDisplayer parent) {
            super("ValueDisplayer IconListener");
            this.chooser = new PopupIconChooser(title, objectName, is.getIcons(), is.getCurrentIcon(), parentDialog);
            this.parent = parent;
            this.is = is;
        }

        public void actionPerformed(ActionEvent e) {
            ImageIcon icon;
            if (this.enabled && (icon = this.chooser.showDialog()) != null) {
                this.parent.setContentAreaFilled(false);
                this.parent.setIcon(icon);
                this.parent.inputObj = this.is.getIconType(icon);
                this.parent.fireItemSelected();
            }
        }
    }

    private class FontListener
    extends AbstractAction {
        ValueDisplayer parent;

        FontListener(ValueDisplayer parent) {
            super("ValueDisplayer FontListener");
            this.parent = parent;
        }

        public void actionPerformed(ActionEvent e) {
            Font f = PopupFontChooser.showDialog(this.parent.parent, (Font)this.parent.inputObj);
            if (f != null) {
                this.parent.setSelectedFont(f);
                this.parent.fireItemSelected();
            }
        }
    }

    private class LabelPositionListener
    extends AbstractAction {
        ValueDisplayer parent;

        LabelPositionListener(ValueDisplayer parent) {
            super("ValueDisplayer LabelPositionListener");
            this.parent = parent;
        }

        public void actionPerformed(ActionEvent e) {
            LabelPosition pos;
            if (this.enabled && (pos = PopupLabelPositionChooser.showDialog(this.parent.parent, (LabelPosition)this.parent.inputObj)) != null) {
                this.parent.inputObj = pos;
                ValueDisplayer.this.setText(pos.shortString());
                this.parent.fireItemSelected();
            }
        }
    }

    private class ColorListener
    extends AbstractAction {
        ValueDisplayer parent;

        ColorListener(ValueDisplayer parent) {
            super("ValueDisplayer ColorListener");
            this.parent = parent;
        }

        public void actionPerformed(ActionEvent e) {
            Color tempColor;
            if (this.enabled && (tempColor = CyColorChooser.showDialog(this.parent.parent, this.parent.title, (Color)this.parent.inputObj)) != null) {
                this.parent.inputObj = tempColor;
                this.parent.setBackground(tempColor);
                this.parent.fireItemSelected();
            }
        }
    }
}

