/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui.icon;

import cytoscape.Cytoscape;
import cytoscape.visual.NodeShape;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.ui.icon.VisualPropertyIcon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class NodeIcon
extends VisualPropertyIcon {
    protected Shape newShape;
    protected Graphics2D g2d;

    public NodeIcon() {
        this(((NodeShape)((Object)VisualPropertyType.NODE_SHAPE.getDefault(Cytoscape.getVisualMappingManager().getVisualStyle()))).getShape(), 32, 32, ((NodeShape)((Object)VisualPropertyType.NODE_SHAPE.getDefault(Cytoscape.getVisualMappingManager().getVisualStyle()))).getShapeName(), DEFAULT_ICON_COLOR);
    }

    public NodeIcon(NodeShape ns) {
        this(ns.getShape(), 32, 32, ns.getShapeName(), DEFAULT_ICON_COLOR);
    }

    public NodeIcon(Shape shape, int width, int height, String name) {
        this(shape, width, height, name, DEFAULT_ICON_COLOR);
    }

    public NodeIcon(Shape shape, int width, int height, String name, Color color) {
        super(shape, width, height, name, color);
        this.adjustShape();
    }

    public void setIconWidth(int width) {
        super.setIconWidth(width);
        this.adjustShape();
    }

    public void setIconHeight(int height) {
        super.setIconHeight(height);
        this.adjustShape();
    }

    private void adjustShape() {
        double shapeWidth = this.shape.getBounds2D().getWidth();
        double shapeHeight = this.shape.getBounds2D().getHeight();
        double xRatio = (double)this.width / shapeWidth;
        double yRatio = (double)this.height / shapeHeight;
        AffineTransform af = new AffineTransform();
        Rectangle2D bound = this.shape.getBounds2D();
        double minx = bound.getMinX();
        double miny = bound.getMinY();
        if (minx < 0.0) {
            af.setToTranslation(Math.abs(minx), 0.0);
            this.shape = af.createTransformedShape(this.shape);
        }
        if (miny < 0.0) {
            af.setToTranslation(0.0, Math.abs(miny));
            this.shape = af.createTransformedShape(this.shape);
        }
        af.setToScale(xRatio, yRatio);
        this.shape = af.createTransformedShape(this.shape);
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.g2d = (Graphics2D)g;
        AffineTransform af = new AffineTransform();
        this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2d.translate(0, this.bottomPad);
        this.newShape = this.shape;
        af.setToTranslation(this.leftPad, ((double)c.getHeight() - this.newShape.getBounds2D().getHeight()) / 2.0);
        this.newShape = af.createTransformedShape(this.newShape);
        this.g2d.setColor(this.color);
        this.g2d.setStroke(new BasicStroke(2.0f));
        this.g2d.draw(this.newShape);
        this.g2d.translate(0, -this.bottomPad);
    }

    public NodeIcon clone() {
        NodeIcon cloned = new NodeIcon(this.shape, this.width, this.height, this.name, this.color);
        return cloned;
    }
}

