/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui.icon;

import java.awt.Color;
import java.awt.Shape;
import javax.swing.ImageIcon;

public abstract class VisualPropertyIcon
extends ImageIcon {
    public static final Color DEFAULT_ICON_COLOR = Color.DARK_GRAY;
    public static final int DEFAULT_ICON_SIZE = 32;
    protected int height;
    protected int width;
    protected Color color;
    protected Shape shape;
    protected String name;
    protected int leftPad = 0;
    protected int bottomPad = 0;

    public VisualPropertyIcon(String name, Color color) {
        this(null, 32, 32, name, color);
    }

    public VisualPropertyIcon(Shape shape, int width, int height, String name) {
        this(shape, width, height, name, DEFAULT_ICON_COLOR);
    }

    public VisualPropertyIcon(Shape shape, int width, int height, String name, Color color) {
        this.shape = shape;
        this.width = width;
        this.height = height;
        this.name = name;
        this.color = color != null ? color : DEFAULT_ICON_COLOR;
    }

    public Shape getShape() {
        return this.shape;
    }

    public int getIconHeight() {
        return this.height;
    }

    public int getIconWidth() {
        return this.width;
    }

    public void setIconWidth(int width) {
        this.width = width;
    }

    public void setIconHeight(int height) {
        this.height = height;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setLeftPadding(int pad) {
        this.leftPad = pad;
    }

    public void setBottomPadding(int pad) {
        this.bottomPad = pad;
    }
}

