/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.alignment;

import java.util.List;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.symbol.Alignment;

public abstract class SequenceAlignment {
    public abstract String getAlignmentString() throws Exception;

    public abstract List alignAll(SequenceIterator var1, SequenceDB var2) throws Exception;

    public abstract double pairwiseAlignment(Sequence var1, Sequence var2) throws Exception;

    public abstract Alignment getAlignment(Sequence var1, Sequence var2) throws Exception;

    public static String formatOutput(String queryName, String targetName, String[] align, String path, int queryStart, int queryEnd, long queryLength, int targetStart, int targetEnd, long targetLength, double editdistance, long time) {
        int n;
        int l;
        int k;
        String output = "\n  Time (ms):\t" + time + "\n  Length:\t" + align[0].length() + "\n";
        output = output + "  Score:\t" + -1.0 * editdistance + "\n";
        output = output + "  Query:\t" + queryName + ",\tLength:\t" + queryLength + "\n";
        output = output + "  Target:\t" + targetName + ",\tLength:\t" + targetLength + "\n\n";
        int currline = Math.min(60, align[0].length());
        String space = "  ";
        String kspace = "";
        String jspace = "";
        for (k = 0; k < new Integer(Math.max(queryEnd, targetEnd)).toString().length(); ++k) {
            space = space + " ";
        }
        for (k = new Integer(queryStart + 1).toString().length(); k <= new Integer(Math.max(queryEnd, targetEnd)).toString().length(); ++k) {
            kspace = kspace + " ";
        }
        for (k = new Integer(targetStart + 1).toString().length(); k <= new Integer(Math.max(queryEnd, targetEnd)).toString().length(); ++k) {
            jspace = jspace + " ";
        }
        int i = k = queryStart;
        int j = l = targetStart;
        output = output + "\nQuery:\t" + kspace + (k + 1) + " ";
        for (i = currline - Math.min(60, align[0].length()); i < currline; ++i) {
            if (align[0].charAt(i) != '-' && align[0].charAt(i) != '~') {
                ++k;
            }
            if (align[1].charAt(i) == '-' || align[1].charAt(i) == '~') continue;
            ++j;
        }
        output = output + align[0].substring(0, currline) + " " + k;
        output = output + " \n        " + space + path.substring(0, currline);
        output = output + " \nTarget:\t" + jspace + (l + 1) + " " + align[1].substring(0, currline) + " " + j + " \n";
        while (currline + 60 < path.length()) {
            l = Math.min(j + 1, targetEnd);
            jspace = "";
            kspace = "";
            for (n = new Integer(k + 1).toString().length() - 1; n < new Integer(Math.max(queryEnd, targetEnd)).toString().length(); ++n) {
                kspace = kspace + " ";
            }
            for (n = new Integer(j).toString().length() - 1; n < new Integer(Math.max(queryEnd, targetEnd)).toString().length(); ++n) {
                jspace = jspace + " ";
            }
            output = output + " \nQuery:\t" + kspace + Math.min(k + 1, queryEnd) + " ";
            for (i = currline; i < currline + 60; ++i) {
                if (align[0].charAt(i) != '-' && align[0].charAt(i) != '~') {
                    ++k;
                }
                if (align[1].charAt(i) == '-' || align[1].charAt(i) == '~') continue;
                ++j;
            }
            output = output + align[0].substring(currline, currline + 60) + " " + k;
            output = output + " \n        " + space + path.substring(currline, currline + 60);
            output = output + " \nTarget:\t" + jspace + l + " " + align[1].substring(currline, currline + 60) + " " + j + " \n";
            currline += 60;
        }
        align[0] = align[0] + " " + queryEnd;
        align[1] = align[1] + " " + targetEnd;
        if (currline + 1 < path.length()) {
            jspace = "";
            kspace = "";
            for (n = new Integer(k).toString().length() - 1; n < new Integer(Math.max(queryEnd, targetEnd)).toString().length(); ++n) {
                kspace = kspace + " ";
            }
            for (n = new Integer(j).toString().length() - 1; n < new Integer(Math.max(queryEnd, targetEnd)).toString().length(); ++n) {
                jspace = jspace + " ";
            }
            output = output + " \nQuery:\t" + kspace + Math.min(k + 1, queryEnd) + " " + align[0].substring(currline, align[0].length());
            output = output + " \n        " + space + path.substring(currline, path.length());
            output = output + " \nTarget:\t" + jspace + Math.min(j + 1, targetEnd) + " " + align[1].substring(currline, align[1].length()) + "\n";
        }
        output = output + "\n";
        return output;
    }
}

