/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.alignment;

import java.util.HashMap;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.alignment.NeedlemanWunsch;
import org.biojava.bio.alignment.SubstitutionMatrix;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.impl.SimpleGappedSequence;
import org.biojava.bio.seq.impl.SimpleSequence;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.SimpleAlignment;
import org.biojava.bio.symbol.SimpleSymbolList;

public class SmithWaterman
extends NeedlemanWunsch {
    private double match;
    private double replace;
    private double insert;
    private double delete;
    private double gapExt;
    private double[][] scoreMatrix;

    public SmithWaterman(double match, double replace, double insert, double delete, double gapExtend, SubstitutionMatrix matrix) {
        super(insert, delete, gapExtend, match, replace, matrix);
        this.match = -match;
        this.replace = -replace;
        this.insert = -insert;
        this.delete = -delete;
        this.gapExt = -gapExtend;
        this.subMatrix = matrix;
        this.alignment = "";
    }

    public void setInsert(double ins) {
        this.insert = -ins;
    }

    public void setDelete(double del) {
        this.delete = -del;
    }

    public void setGapExt(double ge) {
        this.gapExt = -ge;
    }

    public void setMatch(double ma) {
        this.match = -ma;
    }

    public void setReplace(double rep) {
        this.replace = -rep;
    }

    public double pairwiseAlignment(Sequence query, Sequence subject) throws BioRuntimeException {
        if (query.getAlphabet().equals(subject.getAlphabet()) && query.getAlphabet().equals(this.subMatrix.getAlphabet())) {
            int j;
            int i;
            SymbolTokenization st;
            long time = System.currentTimeMillis();
            int maxI = 0;
            int maxJ = 0;
            int queryStart = 0;
            int targetStart = 0;
            this.scoreMatrix = new double[query.length() + 1][subject.length() + 1];
            String[] align = new String[]{"", ""};
            String path = "";
            try {
                st = query.getAlphabet().getTokenization("default");
            }
            catch (BioException exc) {
                throw new BioRuntimeException(exc);
            }
            if (this.gapExt != this.delete || this.gapExt != this.insert) {
                int j2;
                int i2;
                double[][] E = new double[query.length() + 1][subject.length() + 1];
                double[][] F = new double[query.length() + 1][subject.length() + 1];
                this.scoreMatrix[0][0] = 0.0;
                F[0][0] = Double.NEGATIVE_INFINITY;
                E[0][0] = Double.NEGATIVE_INFINITY;
                for (i2 = 1; i2 <= query.length(); ++i2) {
                    F[i2][0] = 0.0;
                    this.scoreMatrix[i2][0] = 0.0;
                    E[i2][0] = Double.NEGATIVE_INFINITY;
                }
                for (j2 = 1; j2 <= subject.length(); ++j2) {
                    E[0][j2] = 0.0;
                    this.scoreMatrix[0][j2] = 0.0;
                    F[0][j2] = Double.NEGATIVE_INFINITY;
                }
                for (i2 = 1; i2 <= query.length(); ++i2) {
                    for (j2 = 1; j2 <= subject.length(); ++j2) {
                        E[i2][j2] = Math.max(E[i2][j2 - 1], this.scoreMatrix[i2][j2 - 1] + this.insert) + this.gapExt;
                        F[i2][j2] = Math.max(F[i2 - 1][j2], this.scoreMatrix[i2 - 1][j2] + this.delete) + this.gapExt;
                        this.scoreMatrix[i2][j2] = this.max(0.0, E[i2][j2], F[i2][j2], this.scoreMatrix[i2 - 1][j2 - 1] + this.matchReplace(query, subject, i2, j2));
                        if (!(this.scoreMatrix[i2][j2] > this.scoreMatrix[maxI][maxJ])) continue;
                        maxI = i2;
                        maxJ = j2;
                    }
                }
                try {
                    boolean[] gap_extend = new boolean[]{false, false};
                    j2 = maxJ;
                    i2 = maxI;
                    while (i2 > 0) {
                        do {
                            if (this.scoreMatrix[i2][j2] == 0.0) {
                                queryStart = i2;
                                targetStart = j2;
                                j2 = 0;
                                i2 = 0;
                                continue;
                            }
                            if (this.scoreMatrix[i2][j2] == this.scoreMatrix[i2 - 1][j2 - 1] + this.matchReplace(query, subject, i2, j2) && !gap_extend[0] && !gap_extend[1]) {
                                path = query.symbolAt(i2) == subject.symbolAt(j2) ? '|' + path : ' ' + path;
                                align[0] = st.tokenizeSymbol(query.symbolAt(i2--)) + align[0];
                                align[1] = st.tokenizeSymbol(subject.symbolAt(j2--)) + align[1];
                                continue;
                            }
                            if (this.scoreMatrix[i2][j2] == E[i2][j2] || gap_extend[0]) {
                                gap_extend[0] = E[i2][j2] != this.scoreMatrix[i2][j2 - 1] + this.insert + this.gapExt;
                                align[0] = '-' + align[0];
                                align[1] = st.tokenizeSymbol(subject.symbolAt(j2--)) + align[1];
                                path = ' ' + path;
                                continue;
                            }
                            gap_extend[1] = F[i2][j2] != this.scoreMatrix[i2 - 1][j2] + this.delete + this.gapExt;
                            align[0] = st.tokenizeSymbol(query.symbolAt(i2--)) + align[0];
                            align[1] = '-' + align[1];
                            path = ' ' + path;
                        } while (j2 > 0);
                    }
                }
                catch (BioException exc) {
                    throw new BioRuntimeException(exc);
                }
            }
            for (i = 0; i <= query.length(); ++i) {
                this.scoreMatrix[i][0] = 0.0;
            }
            for (j = 0; j <= subject.length(); ++j) {
                this.scoreMatrix[0][j] = 0.0;
            }
            for (i = 1; i <= query.length(); ++i) {
                for (j = 1; j <= subject.length(); ++j) {
                    this.scoreMatrix[i][j] = this.max(0.0, this.scoreMatrix[i - 1][j] + this.delete, this.scoreMatrix[i][j - 1] + this.insert, this.scoreMatrix[i - 1][j - 1] + this.matchReplace(query, subject, i, j));
                    if (!(this.scoreMatrix[i][j] > this.scoreMatrix[maxI][maxJ])) continue;
                    maxI = i;
                    maxJ = j;
                }
            }
            try {
                j = maxJ;
                i = maxI;
                while (i > 0) {
                    do {
                        if (this.scoreMatrix[i][j] == 0.0) {
                            queryStart = i;
                            targetStart = j;
                            j = 0;
                            i = 0;
                            continue;
                        }
                        if (this.scoreMatrix[i][j] == this.scoreMatrix[i - 1][j - 1] + this.matchReplace(query, subject, i, j)) {
                            path = query.symbolAt(i) == subject.symbolAt(j) ? '|' + path : ' ' + path;
                            align[0] = st.tokenizeSymbol(query.symbolAt(i--)) + align[0];
                            align[1] = st.tokenizeSymbol(subject.symbolAt(j--)) + align[1];
                            continue;
                        }
                        if (this.scoreMatrix[i][j] == this.scoreMatrix[i][j - 1] + this.insert) {
                            align[0] = '-' + align[0];
                            align[1] = st.tokenizeSymbol(subject.symbolAt(j--)) + align[1];
                            path = ' ' + path;
                            continue;
                        }
                        align[0] = st.tokenizeSymbol(query.symbolAt(i--)) + align[0];
                        align[1] = '-' + align[1];
                        path = ' ' + path;
                    } while (j > 0);
                }
            }
            catch (BioException exc) {
                throw new BioRuntimeException(exc);
            }
            try {
                this.CostMatrix = new double[1][1];
                this.CostMatrix[0][0] = -this.scoreMatrix[maxI][maxJ];
                query = new SimpleGappedSequence(new SimpleSequence(new SimpleSymbolList(query.getAlphabet().getTokenization("token"), align[0]), query.getURN(), query.getName(), query.getAnnotation()));
                subject = new SimpleGappedSequence(new SimpleSequence(new SimpleSymbolList(subject.getAlphabet().getTokenization("token"), align[1]), subject.getURN(), subject.getName(), subject.getAnnotation()));
                HashMap<String, Sequence> m = new HashMap<String, Sequence>();
                m.put(query.getName(), query);
                m.put(subject.getName(), subject);
                this.pairalign = new SimpleAlignment(m);
                this.alignment = SmithWaterman.formatOutput(query.getName(), subject.getName(), align, path, queryStart, maxI, this.scoreMatrix.length - 1, targetStart, maxJ, this.scoreMatrix[0].length - 1, this.getEditDistance(), System.currentTimeMillis() - time) + "\n";
                double value = this.scoreMatrix[maxI][maxJ];
                this.scoreMatrix = null;
                Runtime.getRuntime().gc();
                return value;
            }
            catch (BioException exc) {
                throw new BioRuntimeException(exc);
            }
        }
        throw new BioRuntimeException("The alphabets of the sequences and the substitution matrix have to be equal.");
    }

    private double max(double w, double x, double y, double z) {
        if (w > x && w > y && w > z) {
            return w;
        }
        if (x > y && x > z) {
            return x;
        }
        if (y > z) {
            return y;
        }
        return z;
    }

    private double matchReplace(Sequence query, Sequence subject, int i, int j) {
        try {
            return this.subMatrix.getValueAt(query.symbolAt(i), subject.symbolAt(j));
        }
        catch (Exception exc) {
            if (query.symbolAt(i).getMatches().contains(subject.symbolAt(j)) || subject.symbolAt(j).getMatches().contains(query.symbolAt(i))) {
                return this.match;
            }
            return this.replace;
        }
    }
}

