/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence.tracklayout;

import org.biojava.bio.gui.sequence.tracklayout.TrackLayout;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.symbol.RangeLocation;

public class SimpleTrackLayout
implements TrackLayout {
    private RangeLocation loc;
    private int wrap = 50;
    private int wrapInc = 10;

    public SimpleTrackLayout() {
    }

    public SimpleTrackLayout(Sequence seq, int wrap) {
        this.setSequence(seq);
        this.setWrap(wrap);
    }

    public void setSequence(Sequence seq) {
    }

    public void setRange(RangeLocation loc) {
        this.loc = loc;
    }

    public RangeLocation[] getRanges() {
        int min = this.loc.getMin();
        int max = this.loc.getMax();
        int rowCount = (int)Math.ceil((double)(max - min + 1) / (double)this.wrap);
        RangeLocation[] ranges = new RangeLocation[rowCount];
        int count = 0;
        for (int i = min; i <= max; i += this.wrap) {
            int newMax = i + this.wrap - 1;
            if (newMax > max) {
                newMax = max;
            }
            RangeLocation loc = new RangeLocation(i, newMax);
            ranges[count++] = loc;
        }
        return ranges;
    }

    public void setWrap(int wrap) {
        this.wrap = wrap;
    }

    public int getWrap() {
        return this.wrap;
    }

    public int getWrapIncrement() {
        return this.wrapInc;
    }

    public void setWrapIncrement(int inc) {
        this.wrapInc = inc;
    }
}

