/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.sax;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.StringTokenizer;
import org.biojava.bio.program.sax.AbstractNativeAppSAXParser;
import org.biojava.bio.program.sax.QName;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FastaSequenceSAXParser
extends AbstractNativeAppSAXParser {
    private AttributesImpl oAtts = new AttributesImpl();
    private QName oAttQName = new QName(this);
    private char[] aoChars;
    private StringBuffer oSeqName = new StringBuffer();
    private StringBuffer oSeq = new StringBuffer();
    private boolean tOnFirst = true;
    private static final int STARTUP = 0;
    private static final int IN_STREAM = 1;

    public FastaSequenceSAXParser() {
        this.iState = 0;
        this.setNamespacePrefix("biojava");
    }

    public void parse(InputSource poSource) throws IOException, SAXException {
        String oLine = null;
        BufferedReader oContents = this.getContentStream(poSource);
        try {
            oLine = oContents.readLine();
            while (oLine != null) {
                this.interpret(oContents, oLine);
                oLine = oContents.readLine();
            }
        }
        catch (IOException x) {
            System.out.println(x.getMessage());
            System.out.println("Stream read interupted");
        }
        this.emitSequence();
        this.endElement(new QName(this, this.prefix("SequenceCollection")));
        oContents.close();
    }

    private void interpret(BufferedReader poContents, String poLine) throws SAXException {
        if (this.iState == 0) {
            this.oAtts.clear();
            this.startElement(new QName(this, this.prefix("SequenceCollection")), this.oAtts);
            this.changeState(1);
        }
        if (this.iState == 1) {
            if (poLine.startsWith(">")) {
                if (!this.tOnFirst) {
                    this.emitSequence();
                }
                this.parseHeaderLine(poLine);
                this.oSeq.setLength(0);
                return;
            }
            this.appendSequence(poLine);
        }
    }

    private void parseHeaderLine(String poLine) {
        this.oSeqName.setLength(0);
        this.oSeqName.append(poLine.substring(1));
        this.tOnFirst = false;
    }

    private void appendSequence(String poLine) {
        StringTokenizer oSt = new StringTokenizer(poLine, "\n\t\r ");
        while (oSt.hasMoreTokens()) {
            this.oSeq.append(oSt.nextToken());
        }
    }

    private void emitSequence() throws SAXException {
        this.oAtts.clear();
        this.oAttQName.setQName("sequenceName");
        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", this.oSeqName.substring(0));
        this.startElement(new QName(this, this.prefix("Sequence")), this.oAtts);
        this.aoChars = this.oSeq.substring(0).toCharArray();
        this.characters(this.aoChars, 0, this.aoChars.length);
        this.endElement(new QName(this, this.prefix("Sequence")));
    }
}

