/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.Annotation;
import org.biojava.bio.structure.AminoAcid;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.StructureException;

public class ChainImpl
implements Chain {
    public static String DEFAULT_CHAIN_ID = " ";
    String swissprot_id;
    String name = DEFAULT_CHAIN_ID;
    List groups = new ArrayList();
    Annotation annotation = Annotation.EMPTY_ANNOTATION;
    HashMap pdbResnumMap = new HashMap();

    public Object clone() {
        ChainImpl n = new ChainImpl();
        n.setName(this.getName());
        n.setSwissprotId(this.getSwissprotId());
        for (int i = 0; i < this.groups.size(); ++i) {
            Group g = (Group)this.groups.get(i);
            n.addGroup((Group)g.clone());
        }
        return n;
    }

    public void setAnnotation(Annotation anno) {
        this.annotation = anno;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public void setSwissprotId(String sp_id) {
        this.swissprot_id = sp_id;
    }

    public String getSwissprotId() {
        return this.swissprot_id;
    }

    public void addGroup(Group group) {
        group.setParent(this);
        this.groups.add(group);
        String pdbResnum = group.getPDBCode();
        if (pdbResnum != null) {
            Integer pos = new Integer(this.groups.size() - 1);
            if (this.pdbResnumMap.containsKey(pdbResnum)) {
                if (group instanceof AminoAcid) {
                    this.pdbResnumMap.put(pdbResnum, pos);
                }
            } else {
                this.pdbResnumMap.put(pdbResnum, pos);
            }
        }
    }

    public Group getGroup(int position) {
        return (Group)this.groups.get(position);
    }

    public List getGroups(String type) {
        ArrayList<Group> tmp = new ArrayList<Group>();
        for (int i = 0; i < this.groups.size(); ++i) {
            Group g = (Group)this.groups.get(i);
            if (!g.getType().equals(type)) continue;
            tmp.add(g);
        }
        return tmp;
    }

    public List getGroups() {
        return this.groups;
    }

    public Group getGroupByPDB(String pdbresnum) throws StructureException {
        if (this.pdbResnumMap.containsKey(pdbresnum)) {
            Integer pos = (Integer)this.pdbResnumMap.get(pdbresnum);
            return (Group)this.groups.get(pos);
        }
        throw new StructureException("unknown PDB residue number " + pdbresnum + " in chain " + this.name);
    }

    public Group[] getGroupsByPDB(String pdbresnumStart, String pdbresnumEnd) throws StructureException {
        ArrayList<Group> retlst = new ArrayList<Group>();
        Iterator iter = this.groups.iterator();
        boolean adding = false;
        boolean foundStart = false;
        while (iter.hasNext()) {
            Group g = (Group)iter.next();
            if (g.getPDBCode().equals(pdbresnumStart)) {
                adding = true;
                foundStart = true;
            }
            if (adding) {
                retlst.add(g);
            }
            if (!g.getPDBCode().equals(pdbresnumEnd)) continue;
            if (!adding) {
                throw new StructureException("did not find start PDB residue number " + pdbresnumStart + " in chain " + this.name);
            }
            adding = false;
            break;
        }
        if (!foundStart) {
            throw new StructureException("did not find start PDB residue number " + pdbresnumStart + " in chain " + this.name);
        }
        if (adding) {
            throw new StructureException("did not find end PDB residue number " + pdbresnumEnd + " in chain " + this.name);
        }
        return retlst.toArray(new Group[retlst.size()]);
    }

    public int getLength() {
        return this.groups.size();
    }

    public int getLengthAminos() {
        List g = this.getGroups("amino");
        return g.size();
    }

    public void setName(String nam) {
        this.name = nam;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        String str = "Chain >" + this.getName() + "< total length:" + this.getLength() + " residues";
        for (int i = 0; i < this.groups.size(); ++i) {
            Group gr = (Group)this.groups.get(i);
            str = str + gr.toString() + "\n";
        }
        return str;
    }

    public String getSequence() {
        List aminos = this.getGroups("amino");
        StringBuffer sequence = new StringBuffer();
        for (int i = 0; i < aminos.size(); ++i) {
            AminoAcid a = (AminoAcid)aminos.get(i);
            sequence.append(a.getAminoType());
        }
        String s = sequence.toString();
        return s;
    }
}

