/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax;

import org.biojava.bio.seq.io.ParseException;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.DocRef;
import org.biojavax.RankedDocRef;
import org.biojavax.RichObjectFactory;
import org.biojavax.bio.seq.Position;
import org.biojavax.bio.seq.RichLocation;
import org.biojavax.bio.seq.SimplePosition;
import org.biojavax.bio.seq.SimpleRichLocation;
import org.biojavax.bio.seq.io.GenbankLocationParser;

public class SimpleRankedDocRef
extends AbstractChangeable
implements RankedDocRef {
    private DocRef docref;
    private Integer start;
    private Integer end;
    private RichLocation location;
    private int rank;

    public SimpleRankedDocRef(DocRef docref, Integer start, Integer end, int rank) {
        if (docref == null) {
            throw new IllegalArgumentException("Document reference cannot be null");
        }
        this.docref = docref;
        this.setStart(start);
        this.setEnd(end);
        this.rank = rank;
    }

    public SimpleRankedDocRef(DocRef docref, RichLocation location, int rank) {
        if (docref == null) {
            throw new IllegalArgumentException("Document reference cannot be null");
        }
        this.docref = docref;
        this.makeLocation(location);
        this.rank = rank;
    }

    protected SimpleRankedDocRef() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRank(int rank) throws ChangeVetoException {
        if (rank == this.rank) {
            return;
        }
        if (!this.hasListeners(RankedDocRef.RANK)) {
            this.rank = rank;
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, RankedDocRef.RANK, new Integer(rank), new Integer(this.rank));
            ChangeSupport changeSupport = cs = this.getChangeSupport(RankedDocRef.RANK);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.rank = rank;
                cs.firePostChangeEvent(ce);
            }
        }
    }

    public int getRank() {
        return this.rank;
    }

    public DocRef getDocumentReference() {
        return this.docref;
    }

    public Integer getStart() {
        return this.start;
    }

    public Integer getEnd() {
        return this.end;
    }

    void setDocumentReference(DocRef docref) {
        this.docref = docref;
    }

    private void setStart(Integer start) {
        this.start = start;
        this.createLocation();
    }

    private void setEnd(Integer end) {
        this.end = end;
        this.createLocation();
    }

    private void createLocation() {
        this.location = this.start == null && this.end == null ? RichLocation.EMPTY_LOCATION : (this.start == null ? new SimpleRichLocation(null, new SimplePosition(this.end), 0) : (this.end == null ? new SimpleRichLocation((Position)new SimplePosition(this.start), null, 0) : new SimpleRichLocation((Position)new SimplePosition(this.start), new SimplePosition(this.end), 0)));
    }

    private void makeLocation(RichLocation location) {
        if (location == null) {
            throw new IllegalArgumentException("Document location cannot be null");
        }
        this.location = location;
        this.start = new Integer(location.getMin());
        this.end = new Integer(location.getMax());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocation(RichLocation location) throws ChangeVetoException {
        if (!this.hasListeners(RankedDocRef.LOCATION)) {
            this.makeLocation(location);
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, RankedDocRef.LOCATION, location, this.location);
            ChangeSupport changeSupport = cs = this.getChangeSupport(RankedDocRef.LOCATION);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.makeLocation(location);
                cs.firePostChangeEvent(ce);
            }
        }
    }

    public RichLocation getLocation() {
        return this.location;
    }

    final void setLocationText(String theLocation) throws ParseException {
        if (theLocation == null) {
            this.makeLocation(RichLocation.EMPTY_LOCATION);
        } else {
            RichLocation location = GenbankLocationParser.parseLocation(RichObjectFactory.getDefaultNamespace(), null, theLocation);
            this.makeLocation(location);
        }
    }

    final String getLocationText() {
        return this.getLocation() == RichLocation.EMPTY_LOCATION ? null : GenbankLocationParser.writeLocation(this.getLocation());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof RankedDocRef)) {
            return false;
        }
        if (this.docref == null) {
            return false;
        }
        RankedDocRef them = (RankedDocRef)obj;
        return this.rank == them.getRank() && this.location.equals(them.getLocation()) && this.docref.equals(them.getDocumentReference());
    }

    public int compareTo(Object o) {
        if (this.docref == null) {
            return -1;
        }
        RankedDocRef them = (RankedDocRef)o;
        if (this.rank != them.getRank()) {
            return this.rank - them.getRank();
        }
        if (!this.location.equals(them.getLocation())) {
            return this.location.compareTo(them.getLocation());
        }
        return this.docref.compareTo(them.getDocumentReference());
    }

    public int hashCode() {
        int code = 17;
        if (this.docref == null) {
            return code;
        }
        code = 37 * code + this.docref.hashCode();
        code = 37 * code + this.location.hashCode();
        code = 37 * code + this.rank;
        return code;
    }

    public String toString() {
        return "(#" + this.rank + ") " + this.docref;
    }
}

