/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.db;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.db.IDMaker;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.bio.db.AbstractRichSequenceDB;
import org.biojavax.bio.db.RichSequenceDB;
import org.biojavax.bio.seq.RichSequence;

public class HashRichSequenceDB
extends AbstractRichSequenceDB
implements RichSequenceDB {
    private final Map sequenceByID;
    private final IDMaker idMaker;
    private String name;

    public HashRichSequenceDB() {
        this(IDMaker.byName, null);
    }

    public HashRichSequenceDB(IDMaker idMaker) {
        this(idMaker, null);
    }

    public HashRichSequenceDB(String name) {
        this(IDMaker.byName, name);
    }

    public HashRichSequenceDB(IDMaker idMaker, String name) {
        this.idMaker = idMaker;
        this.name = name;
        this.sequenceByID = new HashMap();
    }

    public String getName() {
        return this.name;
    }

    public IDMaker getIDMaker() {
        return this.idMaker;
    }

    public RichSequence getRichSequence(String id) throws BioException, IllegalIDException {
        RichSequence seq = (RichSequence)this.sequenceByID.get(id);
        if (seq == null) {
            throw new IllegalIDException("Sequence with ID " + id + " could not be found");
        }
        return seq;
    }

    public RichSequenceDB getRichSequences(Set ids) throws BioException, IllegalIDException {
        return this.getRichSequences(ids, null);
    }

    public RichSequenceDB getRichSequences(Set ids, RichSequenceDB db) throws BioException, IllegalIDException {
        if (db == null) {
            db = new HashRichSequenceDB();
        }
        Iterator i = ids.iterator();
        while (i.hasNext()) {
            String id = (String)i.next();
            if (!this.sequenceByID.containsKey(id)) {
                throw new IllegalIDException("Sequence with ID " + id + " could not be found");
            }
            try {
                db.addSequence((RichSequence)this.sequenceByID.get(id));
            }
            catch (ChangeVetoException ce) {
                throw new BioException("Unexpectedly couldn't add to a HashRichSequenceDB", ce);
            }
        }
        return db;
    }

    public Set ids() {
        return this.sequenceByID.keySet();
    }

    public void addRichSequence(RichSequence seq) throws IllegalIDException, BioException, ChangeVetoException {
        this.addRichSequence(this.idMaker.calcID(seq), seq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRichSequence(String id, RichSequence seq) throws IllegalIDException, BioException, ChangeVetoException {
        if (!this.hasListeners(RichSequenceDB.SEQUENCES)) {
            this.sequenceByID.put(id, seq);
        } else {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(RichSequenceDB.SEQUENCES);
            synchronized (changeSupport2) {
                ChangeEvent ce = new ChangeEvent(this, RichSequenceDB.SEQUENCES, new Object[]{id, seq}, null);
                changeSupport.firePreChangeEvent(ce);
                this.sequenceByID.put(id, seq);
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSequence(String id) throws IllegalIDException, BioException, ChangeVetoException {
        if (!this.sequenceByID.containsKey(id)) {
            throw new IllegalIDException("Sequence with ID " + id + " could not be found");
        }
        if (!this.hasListeners(RichSequenceDB.SEQUENCES)) {
            this.sequenceByID.remove(id);
        } else {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(RichSequenceDB.SEQUENCES);
            synchronized (changeSupport2) {
                ChangeEvent ce = new ChangeEvent(this, RichSequenceDB.SEQUENCES, null, id);
                changeSupport.firePreChangeEvent(ce);
                this.sequenceByID.remove(id);
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }
}

