/*
 * Decompiled with CFR 0.152.
 */
package cytoscape;

import com.install4j.api.launcher.StartupNotification;
import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.Options;
import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import com.jgoodies.looks.plastic.theme.SkyBluer;
import cytoscape.CyStartupListener;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.CytoscapeVersion;
import cytoscape.init.CyInitParams;
import cytoscape.logger.CyLogger;
import cytoscape.util.FileUtil;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalTheme;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class CyMain
implements CyInitParams {
    protected String[] args;
    protected Properties props = null;
    protected String[] graphFiles = null;
    protected String[] plugins = null;
    protected Properties vizmapProps = null;
    protected static String sessionFile;
    protected String[] nodeAttrFiles;
    protected String[] edgeAttrFiles;
    protected String[] expressionFiles;
    protected int mode;
    protected org.apache.commons.cli.Options options;
    protected CyLogger logger = null;

    public static void main(String[] args) throws Exception {
        if (System.getProperty("os.name").startsWith("Mac")) {
            CytoscapeVersion ver = new CytoscapeVersion();
            String version = ver.getVersion();
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", version);
        }
        CyMain app = new CyMain(args);
    }

    public CyMain(String[] args) throws Exception {
        sessionFile = null;
        this.nodeAttrFiles = null;
        this.edgeAttrFiles = null;
        this.expressionFiles = null;
        this.args = args;
        this.mode = 0;
        this.options = new org.apache.commons.cli.Options();
        this.logger = CyLogger.getLogger(CyMain.class);
        this.parseCommandLine(args);
        StartupNotification.registerStartupListener((StartupNotification.Listener)new CyStartupListener());
        CytoscapeInit initializer = new CytoscapeInit();
        if (!initializer.init(this)) {
            this.printHelp();
            Cytoscape.exit(1);
        }
    }

    protected void parseCommandLine(String[] args) {
        this.options.addOption("h", "help", false, "Print this message.");
        this.options.addOption("v", "version", false, "Print the version number.");
        OptionBuilder.withLongOpt((String)"session");
        OptionBuilder.withDescription((String)"Load a cytoscape session (.cys) file.");
        OptionBuilder.withValueSeparator((char)'\u0000');
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"s"));
        OptionBuilder.withLongOpt((String)"network");
        OptionBuilder.withDescription((String)"Load a network file (any format).");
        OptionBuilder.withValueSeparator((char)'\u0000');
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArgs();
        this.options.addOption(OptionBuilder.create((String)"N"));
        OptionBuilder.withLongOpt((String)"edge-attrs");
        OptionBuilder.withDescription((String)"Load an edge attributes file (edge attribute format).");
        OptionBuilder.withValueSeparator((char)'\u0000');
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArgs();
        this.options.addOption(OptionBuilder.create((String)"e"));
        OptionBuilder.withLongOpt((String)"node-attrs");
        OptionBuilder.withDescription((String)"Load a node attributes file (node attribute format).");
        OptionBuilder.withValueSeparator((char)'\u0000');
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArgs();
        this.options.addOption(OptionBuilder.create((String)"n"));
        OptionBuilder.withLongOpt((String)"matrix");
        OptionBuilder.withDescription((String)"Load a node attribute matrix file (table).");
        OptionBuilder.withValueSeparator((char)'\u0000');
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArgs();
        this.options.addOption(OptionBuilder.create((String)"m"));
        OptionBuilder.withLongOpt((String)"plugin");
        OptionBuilder.withDescription((String)"Load a plugin jar file, directory of jar files, plugin class name, or plugin jar URL.");
        OptionBuilder.withValueSeparator((char)'\u0000');
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArgs();
        this.options.addOption(OptionBuilder.create((String)"p"));
        OptionBuilder.withLongOpt((String)"props");
        OptionBuilder.withDescription((String)"Load cytoscape properties file (Java properties format) or individual property: -P name=value.");
        OptionBuilder.withValueSeparator((char)'\u0000');
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArgs();
        this.options.addOption(OptionBuilder.create((String)"P"));
        OptionBuilder.withLongOpt((String)"vizmap");
        OptionBuilder.withDescription((String)"Load vizmap properties file (Java properties format).");
        OptionBuilder.withValueSeparator((char)'\u0000');
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArgs();
        this.options.addOption(OptionBuilder.create((String)"V"));
        PosixParser parser = new PosixParser();
        CommandLine line = null;
        try {
            line = parser.parse(this.options, args);
        }
        catch (ParseException e) {
            System.err.println("Parsing command line failed: " + e.getMessage());
            this.printHelp();
            System.exit(1);
        }
        for (String freeArg : args) {
            if (!freeArg.contains(".cys")) continue;
            sessionFile = freeArg;
        }
        if (line.hasOption("h")) {
            this.printHelp();
            System.exit(0);
        }
        if (line.hasOption("v")) {
            CytoscapeVersion version = new CytoscapeVersion();
            this.logger.info(version.getVersion());
            System.exit(0);
        }
        if (line.hasOption("H")) {
            this.mode = 2;
        } else {
            this.mode = 1;
            this.setupLookAndFeel();
        }
        this.props = line.hasOption("P") ? this.createProperties(line.getOptionValues("P")) : this.createProperties(new String[0]);
        if (line.hasOption("N")) {
            this.graphFiles = line.getOptionValues("N");
        }
        if (line.hasOption("p")) {
            this.plugins = line.getOptionValues("p");
        }
        this.vizmapProps = line.hasOption("V") ? this.createProperties(line.getOptionValues("V")) : this.createProperties(new String[0]);
        if (line.hasOption("s")) {
            sessionFile = line.getOptionValue("s");
        }
        if (line.hasOption("n")) {
            this.nodeAttrFiles = line.getOptionValues("n");
        }
        if (line.hasOption("e")) {
            this.edgeAttrFiles = line.getOptionValues("e");
        }
        if (line.hasOption("m")) {
            this.expressionFiles = line.getOptionValues("m");
        }
    }

    public static void setSessionFile(String sf) {
        sessionFile = sf;
    }

    protected void setupLookAndFeel() {
        try {
            if (LookUtils.IS_OS_WINDOWS) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            } else if (LookUtils.IS_OS_MAC) {
                System.setProperty("apple.laf.useScreenMenuBar", "true");
            } else {
                UIManager.setLookAndFeel((LookAndFeel)new Plastic3DLookAndFeel());
                Plastic3DLookAndFeel.set3DEnabled((boolean)true);
                Plastic3DLookAndFeel.setCurrentTheme((MetalTheme)new SkyBluer());
                Plastic3DLookAndFeel.setTabStyle((String)"metal");
                Plastic3DLookAndFeel.setHighContrastFocusColorsEnabled((boolean)true);
                Options.setDefaultIconSize((Dimension)new Dimension(18, 18));
                Options.setHiResGrayFilterEnabled((boolean)true);
                Options.setPopupDropShadowEnabled((boolean)true);
                Options.setUseSystemFonts((boolean)true);
                UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
                UIManager.put("Application.useSystemFontSettings", Boolean.TRUE);
            }
        }
        catch (Exception e) {
            this.logger.warn("Can't set look & feel:" + e.getMessage(), e);
        }
    }

    protected void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java -Xmx512M -jar cytoscape.jar [OPTIONS]", this.options);
    }

    public Properties getProps() {
        return this.props;
    }

    public Properties getVizProps() {
        return this.vizmapProps;
    }

    private Properties createProperties(String[] potentialProps) {
        Properties props = new Properties();
        Properties argProps = new Properties();
        Matcher propPattern = Pattern.compile("^((\\w+\\.*)+)\\=(.+)$").matcher("");
        for (int i = 0; i < potentialProps.length; ++i) {
            propPattern.reset(potentialProps[i]);
            if (propPattern.matches()) {
                argProps.setProperty(propPattern.group(1), propPattern.group(3));
                continue;
            }
            try {
                InputStream in = FileUtil.getInputStream(potentialProps[i]);
                if (in != null) {
                    props.load(in);
                    continue;
                }
                this.logger.info("Couldn't load property: " + potentialProps[i]);
                continue;
            }
            catch (IOException e) {
                this.logger.warn("Couldn't load property '" + potentialProps[i] + "' from file: " + e.getMessage(), e);
            }
        }
        props.putAll((Map<?, ?>)argProps);
        return props;
    }

    public List getGraphFiles() {
        return this.createList(this.graphFiles);
    }

    public List getEdgeAttributeFiles() {
        return this.createList(this.edgeAttrFiles);
    }

    public List getNodeAttributeFiles() {
        return this.createList(this.nodeAttrFiles);
    }

    public List getExpressionFiles() {
        return this.createList(this.expressionFiles);
    }

    public List getPlugins() {
        return this.createList(this.plugins);
    }

    public String getSessionFile() {
        return sessionFile;
    }

    public int getMode() {
        return this.mode;
    }

    public String[] getArgs() {
        return this.args;
    }

    private List createList(String[] vals) {
        if (vals == null) {
            return new ArrayList();
        }
        ArrayList<String> a = new ArrayList<String>(vals.length);
        for (int i = 0; i < vals.length; ++i) {
            a.add(i, vals[i]);
        }
        return a;
    }
}

