/*
 * Decompiled with CFR 0.152.
 */
package cytoscape;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeVersion;
import cytoscape.data.readers.CytoscapeSessionReader;
import cytoscape.dialogs.logger.LoggerDialog;
import cytoscape.init.CyInitParams;
import cytoscape.logger.ConsoleLogger;
import cytoscape.logger.CyLogger;
import cytoscape.logger.LogLevel;
import cytoscape.plugin.Category;
import cytoscape.plugin.DownloadableInfo;
import cytoscape.plugin.ManagerException;
import cytoscape.plugin.PluginInfo;
import cytoscape.plugin.PluginManager;
import cytoscape.plugin.PluginStatus;
import cytoscape.plugin.ThemeInfo;
import cytoscape.util.shadegrown.WindowUtilities;
import java.awt.Cursor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.ImageIcon;

public class CytoscapeInit {
    private static final String SPLASH_SCREEN_LOCATION = "/cytoscape/images/CytoscapeSplashScreen.png";
    private static Properties properties;
    private static Properties visualProperties;
    private static CyLogger logger;
    private static CyInitParams initParams;
    private static File mrud;
    private static File mruf;
    private static String ErrorMsg;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(CyInitParams params) {
        long begintime = System.currentTimeMillis();
        if (logger == null) {
            logger = CyLogger.getLogger(CytoscapeInit.class);
        }
        try {
            initParams = params;
            CytoscapeInit.initProperties();
            logger = CyLogger.getLogger(CytoscapeInit.class);
            properties.putAll((Map<?, ?>)initParams.getProps());
            visualProperties.putAll((Map<?, ?>)initParams.getVizProps());
            Cytoscape.buildOntologyServer();
            PluginManager.getPluginManager();
            if (initParams.getMode() == 1 || initParams.getMode() == 4) {
                ImageIcon image = new ImageIcon(this.getClass().getResource(SPLASH_SCREEN_LOCATION));
                WindowUtilities.showSplash(image, 8000);
                String consoleLogger = properties.getProperty("logger.console");
                if (consoleLogger == null || Boolean.parseBoolean(consoleLogger)) {
                    logger.addLogHandler(ConsoleLogger.getLogger(), LogLevel.LOG_DEBUG);
                } else {
                    logger.info("Log information can now be found in the Help->Error Console menu");
                }
                logger.addLogHandler(LoggerDialog.getLoggerDialog(), LogLevel.LOG_DEBUG);
                Cytoscape.getDesktop();
                Cytoscape.getDesktop().setCursor(Cursor.getPredefinedCursor(3));
                this.setUpAttributesChangedListener();
            } else {
                logger.addLogHandler(ConsoleLogger.getLogger(), LogLevel.LOG_DEBUG);
            }
            logger.info("init mode: " + initParams.getMode());
            PluginManager mgr = PluginManager.getPluginManager();
            try {
                logger.info("Updating plugins...");
                mgr.delete();
            }
            catch (ManagerException me) {
                logger.warn("Error updating plugins: " + me.getMessage(), me);
            }
            mgr.install();
            logger.info("loading plugins....");
            ArrayList<String> InstalledPlugins = new ArrayList<String>();
            InstalledPlugins.addAll(initParams.getPlugins());
            List<DownloadableInfo> MgrInstalledPlugins = mgr.getDownloadables(PluginStatus.CURRENT);
            for (DownloadableInfo dInfo : MgrInstalledPlugins) {
                if (dInfo.getCategory().equals(Category.CORE.getCategoryText())) continue;
                switch (dInfo.getType()) {
                    case PLUGIN: {
                        InstalledPlugins.add(((PluginInfo)dInfo).getInstallLocation());
                        break;
                    }
                    case THEME: {
                        ThemeInfo tInfo = (ThemeInfo)dInfo;
                        for (PluginInfo plugin : tInfo.getPlugins()) {
                            InstalledPlugins.add(plugin.getInstallLocation());
                        }
                        break;
                    }
                }
            }
            mgr.loadPlugins(InstalledPlugins);
            List<Throwable> pluginLoadingErrors = mgr.getLoadingErrors();
            for (Throwable t : pluginLoadingErrors) {
                logger.warn("Plugin loading error: " + t.toString(), t);
            }
            mgr.clearErrorList();
            logger.info("loading session...");
            boolean sessionLoaded = false;
            if (initParams.getMode() == 1 || initParams.getMode() == 4) {
                this.loadSessionFile();
                sessionLoaded = true;
            }
            logger.info("loading networks...");
            this.loadNetworks();
            logger.info("loading attributes...");
            this.loadAttributes();
            logger.info("loading expression files...");
            CytoscapeInit.loadExpressionFiles();
            if (!(initParams.getMode() != 1 && initParams.getMode() != 4 || sessionLoaded)) {
                logger.info("Initializing VizMapper...");
                this.initVizmapper();
            }
        }
        finally {
            if (initParams.getMode() == 1 || initParams.getMode() == 4) {
                WindowUtilities.hideSplash();
                Cytoscape.getDesktop().setCursor(Cursor.getDefaultCursor());
                Cytoscape.getDesktop().repaint();
            }
        }
        long endtime = System.currentTimeMillis() - begintime;
        logger.info("Cytoscape initialized successfully in: " + endtime + " ms");
        Cytoscape.firePropertyChange(Cytoscape.CYTOSCAPE_INITIALIZED, null, null);
        return true;
    }

    public static CyInitParams getCyInitParams() {
        return initParams;
    }

    public static Properties getProperties() {
        return properties;
    }

    public static File getMRUD() {
        if (mrud == null) {
            mrud = new File(properties.getProperty("mrud", System.getProperty("user.dir")));
        }
        return mrud;
    }

    public static File getMRUF() {
        return mruf;
    }

    public static void setMRUD(File mrud_new) {
        mrud = mrud_new;
    }

    public static void setMRUF(File mruf_new) {
        mruf = mruf_new;
    }

    public static File getConfigVersionDirectory() {
        File Parent2 = CytoscapeInit.getConfigDirectory();
        File VersionDir = new File(Parent2, new CytoscapeVersion().getMajorVersion());
        VersionDir.mkdir();
        return VersionDir;
    }

    public static File getConfigDirectory() {
        Object dir = null;
        try {
            String dirName = properties.getProperty("alternative.config.dir", System.getProperty("user.home"));
            File parent_dir = new File(dirName, ".cytoscape");
            if (parent_dir.mkdir()) {
                logger.info("Parent_Dir: " + parent_dir + " created.");
            }
            return parent_dir;
        }
        catch (Exception e) {
            logger.warn("error getting config directory", e);
            return null;
        }
    }

    public static File getConfigFile(String file_name) {
        try {
            File parent_dir = CytoscapeInit.getConfigDirectory();
            File file = new File(parent_dir, file_name);
            if (file.createNewFile()) {
                logger.info("Config file: " + file + " created.");
            }
            return file;
        }
        catch (Exception e) {
            logger.warn("error getting config file:" + file_name, e);
            return null;
        }
    }

    public static Properties getVisualProperties() {
        return visualProperties;
    }

    private static void loadStaticProperties(String defaultName, Properties props) {
        if (props == null) {
            logger.info("input props is null");
            props = new Properties();
        }
        String tryName = "";
        try {
            tryName = "cytoscape.jar";
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            URL vmu = null;
            if (cl != null) {
                vmu = cl.getResource(defaultName);
            } else {
                logger.warn("ClassLoader for reading cytoscape.jar is null");
            }
            if (vmu != null) {
                props.load(vmu.openStream());
            } else {
                logger.warn("couldn't read " + defaultName + " from " + tryName);
            }
            tryName = "$HOME/.cytoscape";
            File vmp = CytoscapeInit.getConfigFile(defaultName);
            if (vmp != null) {
                props.load(new FileInputStream(vmp));
            } else {
                logger.warn("couldn't read " + defaultName + " from " + tryName);
            }
        }
        catch (IOException ioe) {
            logger.warn("couldn't open '" + tryName + " " + defaultName + "' file: " + ioe.getMessage() + " - creating a hardcoded default", ioe);
        }
    }

    private static void loadExpressionFiles() {
        List ef = initParams.getExpressionFiles();
        if (ef != null && ef.size() > 0) {
            for (String expDataFilename : ef) {
                if (expDataFilename == null) continue;
                try {
                    Cytoscape.loadExpressionData(expDataFilename, true);
                }
                catch (Exception e) {
                    logger.error("Couldn't open expression file: '" + expDataFilename + "': " + e.getMessage(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadSessionFile() {
        String sessionFile = initParams.getSessionFile();
        try {
            String sessionName = "";
            if (sessionFile != null) {
                CytoscapeSessionReader reader = null;
                if (sessionFile.matches("^(jar\\:)?(\\w+\\:\\/+\\S+)(\\!\\/\\S*)?$")) {
                    URL u = new URL(sessionFile);
                    reader = new CytoscapeSessionReader(u);
                    sessionName = u.getFile();
                } else {
                    Cytoscape.setCurrentSessionFileName(sessionFile);
                    File shortName = new File(sessionFile);
                    URL sessionURL = shortName.toURL();
                    reader = new CytoscapeSessionReader(sessionURL);
                    sessionName = shortName.getName();
                }
                if (reader != null) {
                    reader.read();
                    Cytoscape.getDesktop().setTitle("Cytoscape Desktop (Session Name: " + sessionName + ")");
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (Exception e) {
            logger.error("couldn't create session from file '" + sessionFile + "': " + e.getMessage(), e);
        }
        finally {
            Cytoscape.getDesktop().getVizMapperUI().initVizmapperGUI();
            System.gc();
        }
        return false;
    }

    private static void initProperties() {
        if (properties == null) {
            properties = new Properties();
            CytoscapeInit.loadStaticProperties("cytoscape.props", properties);
        }
        if (visualProperties == null) {
            visualProperties = new Properties();
            CytoscapeInit.loadStaticProperties("vizmap.props", visualProperties);
        }
    }

    private void setUpAttributesChangedListener() {
        PropertyChangeListener attsChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals(Cytoscape.ATTRIBUTES_CHANGED)) {
                    Cytoscape.getCurrentNetworkView().redrawGraph(false, true);
                }
            }
        };
        Cytoscape.getSwingPropertyChangeSupport().addPropertyChangeListener(attsChangeListener);
    }

    private void loadNetworks() {
        for (String net : initParams.getGraphFiles()) {
            logger.info("Load: " + net);
            CyNetwork network = null;
            boolean createView = false;
            if (initParams.getMode() == 1 || initParams.getMode() == 4) {
                createView = true;
            }
            if (net.matches("^(jar\\:)?(\\w+\\:\\/+\\S+)(\\!\\/\\S*)?$")) {
                try {
                    network = Cytoscape.createNetworkFromURL(new URL(net), createView);
                }
                catch (Exception mue) {
                    logger.error("Couldn't load network from URL '" + net + "': " + mue.getMessage(), mue);
                }
            } else {
                try {
                    network = Cytoscape.createNetworkFromFile(net, createView);
                }
                catch (Exception mue) {
                    logger.error("Couldn't load network from file '" + net + "': " + mue.getMessage(), mue);
                }
            }
            Object[] ret_val = new Object[]{network, net, new Integer(0)};
            Cytoscape.firePropertyChange("NETWORK_LOADED", null, ret_val);
        }
    }

    private void loadAttributes() {
        try {
            Cytoscape.loadAttributes(initParams.getNodeAttributeFiles().toArray(new String[0]), initParams.getEdgeAttributeFiles().toArray(new String[0]));
        }
        catch (Exception ex) {
            logger.error("failure loading specified attributes: " + ex.getMessage(), ex);
        }
    }

    private void initVizmapper() {
        Cytoscape.getDesktop().getVizMapperUI().initVizmapperGUI();
    }

    static {
        logger = null;
        logger = CyLogger.getLogger(CytoscapeInit.class);
        logger.info("CytoscapeInit static initialization");
        CytoscapeInit.initProperties();
        ErrorMsg = "";
    }
}

