/*
 * Decompiled with CFR 0.152.
 */
package cytoscape;

import cytoscape.CyEdge;
import cytoscape.CyMain;
import cytoscape.Cytoscape;
import giny.model.Node;
import java.awt.Robot;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import junit.framework.TestCase;
import swingunit.extensions.ExtendedRobotEventFactory;
import swingunit.framework.EventPlayer;
import swingunit.framework.ExecuteException;
import swingunit.framework.FinderMethodSet;
import swingunit.framework.RobotEventFactory;
import swingunit.framework.Scenario;
import swingunit.framework.TestUtility;

public class CytoscapeTestSwing
extends TestCase {
    private Scenario scenario;
    private RobotEventFactory robotEventFactory = new ExtendedRobotEventFactory();
    private FinderMethodSet methodSet = new FinderMethodSet();
    private Robot robot;
    private EventPlayer player;
    private CyMain application;
    protected int totalNodesHidden = 0;
    protected int totalEdgesHidden = 0;

    protected void setUp() throws Exception {
        System.setProperty("TestSetting", "testData/TestSetting.properties");
        Runnable r = new Runnable(){

            public void run() {
                try {
                    String[] args = new String[]{"-p", "plugins/core"};
                    CytoscapeTestSwing.this.application = new CyMain(args);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        SwingUtilities.invokeAndWait(r);
        this.robot = new Robot();
        TestUtility.waitForCalm();
        String filePath = CytoscapeTestSwing.class.getResource("CytoscapeSwingUnitOperations.xml").getFile();
        this.scenario = new Scenario(this.robotEventFactory, this.methodSet);
        this.scenario.read(filePath);
        UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        this.player = new EventPlayer(this.scenario);
    }

    protected void tearDown() throws Exception {
        this.application = null;
        this.scenario = null;
        this.robot = null;
        this.player = null;
    }

    public void testFileMenu() throws IllegalStateException, IllegalArgumentException, ExecuteException, ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        this.scenario.setTestSetting("PAUSE", "DURATION", "5000");
        this.player.run(this.robot, "PAUSE");
        this.player.run(this.robot, "SHOW_HIDE_ATTRIBUTE_BROWSER");
        this.loadNetworks(this.player);
        this.loadAttributes(this.player);
        this.createNewNetworksFromExistingOnes(this.player);
        this.importVizMap(this.player, "swingTestVisual.props");
        this.exportNetworks(this.player, "network_export");
        this.saveSession(this.player, "testResult.cys");
        this.restoreSessionFromFile(this.player, "testResult.cys");
    }

    private void loadNetworks(EventPlayer player) throws IllegalStateException, IllegalArgumentException, ExecuteException {
        System.out.println("loadNetworks start");
        this.scenario.setTestSetting("IMPORT_NETWORK_FILE", "IMPORT_DIR", "testData");
        this.scenario.setTestSetting("IMPORT_NETWORK_FILE", "FILE_TO_IMPORT", "galFiltered.xgmml");
        player.run(this.robot, "IMPORT_NETWORK_FILE");
        this.scenario.setTestSetting("IMPORT_NETWORK_FILE", "FILE_TO_IMPORT", "yeastHighQuality.sif");
        player.run(this.robot, "IMPORT_NETWORK_FILE");
        this.scenario.setTestSetting("IMPORT_GML_FILE", "IMPORT_DIR", "testData");
        this.scenario.setTestSetting("IMPORT_GML_FILE", "FILE_TO_IMPORT", "galFiltered.gml");
        player.run(this.robot, "IMPORT_GML_FILE");
        this.scenario.setTestSetting("IMPORT_NETWORK_FILE", "FILE_TO_IMPORT", "BIOGRID-Mouse.psi25.xml");
        player.run(this.robot, "IMPORT_NETWORK_FILE");
        this.scenario.setTestSetting("IMPORT_NETWORK_FILE", "FILE_TO_IMPORT", "bca00030.owl");
        player.run(this.robot, "IMPORT_NETWORK_FILE");
        this.scenario.setTestSetting("IMPORT_REMOTE_NETWORK_FILE", "REMORE_NETWORK_FILE", "http://www.reactome.org/cgi-bin/sbml_export?DB=gk_current&ID=73894");
        player.run(this.robot, "IMPORT_REMOTE_NETWORK_FILE");
        this.scenario.setTestSetting("IMPORT_REMOTE_NETWORK_FILE_FROM_BOOKMARK", "BOOKMARK_INDEX", "3");
        player.run(this.robot, "IMPORT_REMOTE_NETWORK_FILE_FROM_BOOKMARK");
        System.out.println("loadNetworks stop");
    }

    private void loadAttributes(EventPlayer player) throws IllegalStateException, IllegalArgumentException, ExecuteException {
        System.out.println("loadAttributes start");
        this.scenario.setTestSetting("IMPORT_NODE_ATTRIBUTES", "IMPORT_DIR", "testData");
        this.scenario.setTestSetting("IMPORT_NODE_ATTRIBUTES", "FILE_TO_IMPORT", "RUAL.na");
        player.run(this.robot, "IMPORT_NODE_ATTRIBUTES");
        this.scenario.setTestSetting("IMPORT_EDGE_ATTRIBUTES", "IMPORT_DIR", "testData");
        this.scenario.setTestSetting("IMPORT_EDGE_ATTRIBUTES", "FILE_TO_IMPORT", "Edge String Attr.ea");
        player.run(this.robot, "IMPORT_EDGE_ATTRIBUTES");
        this.scenario.setTestSetting("IMPORT_EXPRESSION_MATRIX", "IMPORT_DIR", "testData");
        this.scenario.setTestSetting("IMPORT_EXPRESSION_MATRIX", "MATRIX_FILE_NAME", "galExpData.pvals");
        player.run(this.robot, "IMPORT_EXPRESSION_MATRIX");
        System.out.println("loadAttributes stop");
    }

    private void loadOntologyAndAnnotation(EventPlayer player) {
    }

    private void importVizMap(EventPlayer player, String vizmapFileName) throws IllegalStateException, IllegalArgumentException, ExecuteException {
        System.out.println("importVizMap start");
        this.scenario.setTestSetting("IMPORT_VIZMAP", "FILE_TO_IMPORT", vizmapFileName);
        this.scenario.setTestSetting("IMPORT_VIZMAP", "IMPORT_DIR", "testData");
        player.run(this.robot, "IMPORT_VIZMAP");
        System.out.println("importVizMap stop");
    }

    private void saveSession(EventPlayer player, String sessionFileName) throws IllegalStateException, IllegalArgumentException, ExecuteException {
        System.out.println("saveSession start");
        this.scenario.setTestSetting("SAVE_SESSION", "SESSION_FILE_NAME", sessionFileName);
        player.run(this.robot, "SAVE_SESSION");
        System.out.println("saveSession stop");
    }

    private void restoreSessionFromFile(EventPlayer player, String sessionFileName) throws IllegalStateException, IllegalArgumentException, ExecuteException {
        System.out.println("restoreSessionFromFile start");
        this.scenario.setTestSetting("OPEN_SESSION", "SESSION_FILE_NAME", sessionFileName);
        this.scenario.setTestSetting("OPEN_SESSION", "SESSION_DIR", "testData");
        player.run(this.robot, "OPEN_SESSION");
        this.scenario.setTestSetting("PAUSE", "DURATION", "3000");
        player.run(this.robot, "PAUSE");
        System.out.println("restoreSessionFromFile stop");
    }

    private void exportNetworks(EventPlayer player, String exportFileName) throws IllegalStateException, IllegalArgumentException, ExecuteException {
        System.out.println("export network and attributes start");
        this.scenario.setTestSetting("EXPORT_AS_XGMML_FILE", "EXPORT_FILE_NAME", exportFileName + ".xgmml");
        player.run(this.robot, "EXPORT_AS_XGMML_FILE");
        this.scenario.setTestSetting("EXPORT_AS_SIF_FILE", "EXPORT_FILE_NAME", exportFileName + ".sif");
        player.run(this.robot, "EXPORT_AS_SIF_FILE");
        this.scenario.setTestSetting("EXPORT_AS_GML_FILE", "EXPORT_FILE_NAME", exportFileName + ".gml");
        player.run(this.robot, "EXPORT_AS_GML_FILE");
        System.out.println("export network and attributes start stop");
    }

    private void createNewNetworksFromExistingOnes(EventPlayer player) throws ExecuteException {
        System.out.println("create new network from existing one start");
        this.scenario.setTestSetting("PAUSE", "DURATION", "1000");
        this.scenario.setTestSetting("IMPORT_NETWORK_FILE", "IMPORT_DIR", "testData");
        this.scenario.setTestSetting("IMPORT_NETWORK_FILE", "FILE_TO_IMPORT", "galFiltered.sif");
        player.run(this.robot, "IMPORT_NETWORK_FILE");
        this.scenario.setTestSetting("PAUSE", "DURATION", "1000");
        this.scenario.setTestSetting("SELECT_NODES_FROM_FILE", "IMPORT_DIR", "testData");
        this.scenario.setTestSetting("SELECT_NODES_FROM_FILE", "FILE_TO_IMPORT", "galFiltered.select.from.file.txt");
        this.scenario.setTestSetting("PAUSE", "DURATION", "1000");
        player.run(this.robot, "SELECT_NODES_FROM_FILE");
        Set nodes = Cytoscape.getCurrentNetwork().getSelectedNodes();
        HashSet<CyEdge> edges = new HashSet<CyEdge>();
        Object[] nodeObj = nodes.toArray();
        for (int i = 0; i < nodeObj.length; ++i) {
            CyEdge pdSelfEdge;
            Node node1 = (Node)nodeObj[i];
            CyEdge ppSelfEdge = Cytoscape.getCyEdge(node1, node1, "interaction", "pp", false);
            if (ppSelfEdge != null) {
                edges.add(ppSelfEdge);
            }
            if ((pdSelfEdge = Cytoscape.getCyEdge(node1, node1, "interaction", "pd", false)) != null) {
                edges.add(pdSelfEdge);
            }
            for (int j = i + 1; j < nodeObj.length; ++j) {
                CyEdge pd2Edge;
                CyEdge pp2Edge;
                CyEdge pdEdge;
                Node node2 = (Node)nodeObj[j];
                CyEdge ppEdge = Cytoscape.getCyEdge(node1, node2, "interaction", "pp", false, true);
                if (ppEdge != null) {
                    edges.add(ppEdge);
                }
                if ((pdEdge = Cytoscape.getCyEdge(node1, node2, "interaction", "pd", false, true)) != null) {
                    edges.add(pdEdge);
                }
                if ((pp2Edge = Cytoscape.getCyEdge(node2, node1, "interaction", "pp", false, true)) != null) {
                    edges.add(pp2Edge);
                }
                if ((pd2Edge = Cytoscape.getCyEdge(node2, node1, "interaction", "pd", false, true)) == null) continue;
                edges.add(pd2Edge);
            }
        }
        this.scenario.setTestSetting("PAUSE", "DURATION", "3000");
        player.run(this.robot, "NEW_NETWORK_FROM_SELECTED_NODES_ALL_EDGES");
        Iterator nodesIter = Cytoscape.getCurrentNetwork().nodesIterator();
        while (nodesIter.hasNext()) {
            CytoscapeTestSwing.assertTrue((boolean)nodes.remove((Node)nodesIter.next()));
        }
        CytoscapeTestSwing.assertTrue((boolean)nodes.isEmpty());
        for (CyEdge edge : edges) {
            CytoscapeTestSwing.assertNotNull((Object)Cytoscape.getCurrentNetwork().getEdge(edge.getRootGraphIndex()));
        }
        System.out.println("create new network from existing one stop");
    }

    public void testlayoutMenu() throws IllegalStateException, IllegalArgumentException, ExecuteException, ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        System.out.println("testLayoutMenu start");
        this.scenario.setTestSetting("PAUSE", "DURATION", "1000");
        this.scenario.setTestSetting("IMPORT_NETWORK_FILE", "IMPORT_DIR", "testData");
        this.scenario.setTestSetting("IMPORT_NETWORK_FILE", "FILE_TO_IMPORT", "galFiltered.sif");
        this.player.run(this.robot, "IMPORT_NETWORK_FILE");
        this.scenario.setTestSetting("DO_LAYOUT", "LAYOUT_CATEGORY", "yFiles");
        this.scenario.setTestSetting("DO_LAYOUT", "LAYOUT_ALGORITHM", "Circular");
        this.player.run(this.robot, "DO_LAYOUT");
        this.scenario.setTestSetting("DO_LAYOUT", "LAYOUT_CATEGORY", "yFiles");
        this.scenario.setTestSetting("DO_LAYOUT", "LAYOUT_ALGORITHM", "Organic");
        this.player.run(this.robot, "DO_LAYOUT");
        this.scenario.setTestSetting("DO_LAYOUT", "LAYOUT_CATEGORY", "yFiles");
        this.scenario.setTestSetting("DO_LAYOUT", "LAYOUT_ALGORITHM", "Hierarchic");
        this.player.run(this.robot, "DO_LAYOUT");
        this.scenario.setTestSetting("DO_LAYOUT", "LAYOUT_CATEGORY", "yFiles");
        this.scenario.setTestSetting("DO_LAYOUT", "LAYOUT_ALGORITHM", "Random");
        this.player.run(this.robot, "DO_LAYOUT");
        this.scenario.setTestSetting("DO_LAYOUT", "LAYOUT_CATEGORY", "yFiles");
        this.scenario.setTestSetting("DO_LAYOUT", "LAYOUT_ALGORITHM", "MirrorX");
        this.player.run(this.robot, "DO_LAYOUT");
        this.scenario.setTestSetting("DO_LAYOUT", "LAYOUT_CATEGORY", "yFiles");
        this.scenario.setTestSetting("DO_LAYOUT", "LAYOUT_ALGORITHM", "MirrorY");
        this.player.run(this.robot, "DO_LAYOUT");
        this.scenario.setTestSetting("DO_LAYOUT", "LAYOUT_CATEGORY", "JGraph Layouts");
        this.scenario.setTestSetting("DO_LAYOUT", "LAYOUT_ALGORITHM", "Radial");
        this.player.run(this.robot, "DO_LAYOUT");
        this.scenario.setTestSetting("DO_LAYOUT", "LAYOUT_CATEGORY", "JGraph Layouts");
        this.scenario.setTestSetting("DO_LAYOUT", "LAYOUT_ALGORITHM", "Spring");
        this.player.run(this.robot, "DO_LAYOUT");
        this.scenario.setTestSetting("DO_LAYOUT", "LAYOUT_CATEGORY", "JGraph Layouts");
        this.scenario.setTestSetting("DO_LAYOUT", "LAYOUT_ALGORITHM", "Sugiyama");
        this.player.run(this.robot, "DO_LAYOUT");
        this.scenario.setTestSetting("DO_LAYOUT", "LAYOUT_CATEGORY", "Cytoscape Layouts");
        this.scenario.setTestSetting("DO_LAYOUT", "LAYOUT_ALGORITHM", "Hierarchical");
        this.player.run(this.robot, "DO_LAYOUT");
        this.scenario.setTestSetting("DO_LAYOUT_WITH_OPTION", "LAYOUT_CATEGORY", "Cytoscape Layouts");
        this.scenario.setTestSetting("DO_LAYOUT_WITH_OPTION", "LAYOUT_ALGORITHM", "Spring Embedded");
        this.scenario.setTestSetting("DO_LAYOUT_WITH_OPTION", "LAYOUT_OPTION", "All Nodes");
        this.player.run(this.robot, "DO_LAYOUT_WITH_OPTION");
        this.scenario.setTestSetting("DO_LAYOUT_WITH_OPTION", "LAYOUT_CATEGORY", "Cytoscape Layouts");
        this.scenario.setTestSetting("DO_LAYOUT_WITH_OPTION", "LAYOUT_ALGORITHM", "Attribute Circle Layout");
        this.scenario.setTestSetting("DO_LAYOUT_WITH_OPTION", "LAYOUT_OPTION", "canonicalName");
        this.player.run(this.robot, "DO_LAYOUT_WITH_OPTION");
        this.scenario.setTestSetting("DO_LAYOUT", "LAYOUT_CATEGORY", "Cytoscape Layouts");
        this.scenario.setTestSetting("DO_LAYOUT", "LAYOUT_ALGORITHM", "Degree Sorted Circle Layout");
        this.player.run(this.robot, "DO_LAYOUT");
        this.scenario.setTestSetting("DO_LAYOUT_WITH_OPTION2", "LAYOUT_CATEGORY", "Cytoscape Layouts");
        this.scenario.setTestSetting("DO_LAYOUT_WITH_OPTION2", "LAYOUT_ALGORITHM", "Edge-weighted");
        this.scenario.setTestSetting("DO_LAYOUT_WITH_OPTION2", "LAYOUT_OPTION1", "Edge-weighted Spring Embedded");
        this.scenario.setTestSetting("DO_LAYOUT_WITH_OPTION2", "LAYOUT_OPTION2", "(unweighted)");
        this.player.run(this.robot, "DO_LAYOUT_WITH_OPTION2");
    }
}

