/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.Cytoscape;
import cytoscape.actions.ExportAsGraphicsAction;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.task.util.TaskManager;
import cytoscape.util.export.Exporter;
import cytoscape.view.CyNetworkView;
import java.awt.Container;
import java.io.FileOutputStream;
import java.io.IOException;

class ExportTask {
    ExportTask() {
    }

    public static void run(final String title, final Exporter exporter, final CyNetworkView view, final FileOutputStream stream) {
        Task task = new Task(){
            TaskMonitor monitor;

            public String getTitle() {
                return title;
            }

            public void setTaskMonitor(TaskMonitor monitor) {
                this.monitor = monitor;
            }

            public void halt() {
            }

            public void run() {
                try {
                    exporter.export(view, stream);
                }
                catch (IOException e) {
                    this.monitor.setException((Throwable)e, "Could not complete export of network");
                }
                try {
                    stream.close();
                }
                catch (IOException ioe) {
                    ExportAsGraphicsAction.logger.warn("Unable to close the stream: " + ioe.getMessage(), ioe);
                }
            }
        };
        JTaskConfig jTaskConfig = new JTaskConfig();
        jTaskConfig.displayCancelButton(false);
        jTaskConfig.displayCloseButton(false);
        jTaskConfig.displayStatus(false);
        jTaskConfig.displayTimeElapsed(true);
        jTaskConfig.displayTimeRemaining(false);
        jTaskConfig.setAutoDispose(true);
        jTaskConfig.setModal(true);
        jTaskConfig.setOwner((Container)Cytoscape.getDesktop());
        TaskManager.executeTask((Task)task, (JTaskConfig)jTaskConfig);
    }
}

