/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.view.CyNetworkView;
import giny.model.GraphPerspective;
import giny.model.Node;
import giny.view.EdgeView;
import giny.view.GraphView;
import giny.view.NodeView;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class GinyUtils {
    static Map<GraphPerspective, Set<HiddenNode>> hiddenNodesMap = new HashMap<GraphPerspective, Set<HiddenNode>>();
    static Map<GraphPerspective, Set<Integer>> hiddenEdgesMap = new HashMap<GraphPerspective, Set<Integer>>();
    static GraphDestroyedListener graphDestroyedListener = null;

    private static void ensureGraph(GraphPerspective graph) {
        if (hiddenNodesMap.containsKey(graph)) {
            return;
        }
        hiddenNodesMap.put(graph, new HashSet());
        hiddenEdgesMap.put(graph, new HashSet());
        GinyUtils.ensureGraphDestroyedListener();
    }

    private static void ensureGraphDestroyedListener() {
        if (graphDestroyedListener != null) {
            return;
        }
        graphDestroyedListener = new GraphDestroyedListener();
        Cytoscape.getPropertyChangeSupport().addPropertyChangeListener(Cytoscape.NETWORK_DESTROYED, graphDestroyedListener);
    }

    public static void hideSelectedNodes(GraphView view) {
        if (view == null) {
            return;
        }
        GraphPerspective graph = view.getGraphPerspective();
        GinyUtils.ensureGraph(graph);
        Set<HiddenNode> hiddenNodes = hiddenNodesMap.get(graph);
        Set<Integer> hiddenEdges = hiddenEdgesMap.get(graph);
        for (NodeView nview : view.getSelectedNodes()) {
            HiddenNode hiddenNode = new HiddenNode(nview);
            hiddenNodes.add(hiddenNode);
            int[] edges = graph.getAdjacentEdgeIndicesArray(hiddenNode.index, true, true, true);
            for (int edgeIndex = 0; edgeIndex < edges.length; ++edgeIndex) {
                hiddenEdges.add(edges[edgeIndex]);
                graph.hideEdge(edges[edgeIndex]);
            }
            graph.hideNode(hiddenNode.index);
        }
        view.updateView();
    }

    public static void unHideSelectedNodes(GraphView view) {
        if (view == null) {
            return;
        }
        for (NodeView nview : view.getSelectedNodes()) {
            view.showGraphObject((Object)nview);
            int[] na = view.getGraphPerspective().neighborsArray(nview.getGraphPerspectiveIndex());
            for (int i2 = 0; i2 < na.length; ++i2) {
                int[] edges = view.getGraphPerspective().getEdgeIndicesArray(nview.getGraphPerspectiveIndex(), na[i2], true, true);
                for (int j = 0; j < edges.length; ++j) {
                    view.showGraphObject((Object)view.getEdgeView(edges[j]));
                }
            }
        }
        view.updateView();
    }

    public static void unHideAll(GraphView view) {
        if (view == null) {
            return;
        }
        GraphPerspective graph = view.getGraphPerspective();
        Set<HiddenNode> hiddenNodes = hiddenNodesMap.get(graph);
        if (hiddenNodes == null) {
            return;
        }
        for (HiddenNode hiddenNode : hiddenNodes) {
            graph.restoreNode(hiddenNode.index);
            NodeView nodeView = view.getNodeView(hiddenNode.index);
            if (nodeView == null) {
                nodeView = view.addNodeView(hiddenNode.index);
            }
            if (view instanceof CyNetworkView) {
                ((CyNetworkView)view).applyVizMap(nodeView);
            }
            nodeView.setXPosition(hiddenNode.x);
            nodeView.setYPosition(hiddenNode.y);
        }
        hiddenNodes.clear();
        Set<Integer> hiddenEdges = hiddenEdgesMap.get(graph);
        for (Integer hiddenEdge : hiddenEdges) {
            graph.restoreEdge(hiddenEdge.intValue());
            EdgeView edgeView = view.getEdgeView(hiddenEdge.intValue());
            if (edgeView == null) {
                edgeView = view.addEdgeView(hiddenEdge.intValue());
            }
            if (!(view instanceof CyNetworkView)) continue;
            ((CyNetworkView)view).applyVizMap(edgeView);
        }
        hiddenEdges.clear();
        view.updateView();
    }

    public static void unHideNodesAndInterconnectingEdges(GraphView view) {
        if (view == null) {
            return;
        }
        Iterator i = view.getNodeViewsIterator();
        while (i.hasNext()) {
            NodeView nview = (NodeView)i.next();
            Node n = nview.getNode();
            view.showGraphObject((Object)nview);
            int[] na = view.getGraphPerspective().neighborsArray(nview.getGraphPerspectiveIndex());
            for (int i2 = 0; i2 < na.length; ++i2) {
                int[] edges = view.getGraphPerspective().getEdgeIndicesArray(nview.getGraphPerspectiveIndex(), na[i2], true);
                if (edges == null) continue;
                for (int j = 0; j < edges.length; ++j) {
                    EdgeView ev = view.getEdgeView(edges[j]);
                    view.showGraphObject((Object)ev);
                }
            }
        }
        view.updateView();
    }

    public static void hideSelectedEdges(GraphView view) {
        if (view == null) {
            return;
        }
        GraphPerspective graph = view.getGraphPerspective();
        GinyUtils.ensureGraph(graph);
        Set<Integer> hiddenEdges = hiddenEdgesMap.get(graph);
        for (EdgeView eview : view.getSelectedEdges()) {
            hiddenEdges.add(eview.getEdge().getRootGraphIndex());
            graph.hideEdge(eview.getEdge());
        }
        view.updateView();
    }

    public static void unHideSelectedEdges(GraphView view) {
        if (view == null) {
            return;
        }
        for (EdgeView eview : view.getSelectedEdges()) {
            view.showGraphObject((Object)eview);
        }
        view.updateView();
    }

    public static void invertSelectedNodes(GraphView view) {
        if (view == null) {
            return;
        }
        Iterator i = view.getNodeViewsIterator();
        while (i.hasNext()) {
            NodeView nview;
            nview.setSelected(!(nview = (NodeView)i.next()).isSelected());
        }
        view.updateView();
    }

    public static void invertSelectedEdges(GraphView view) {
        if (view == null) {
            return;
        }
        Iterator i = view.getEdgeViewsList().iterator();
        while (i.hasNext()) {
            EdgeView eview;
            eview.setSelected(!(eview = (EdgeView)i.next()).isSelected());
        }
        view.updateView();
    }

    public static void selectFirstNeighbors(GraphView view) {
        if (view == null) {
            return;
        }
        GraphPerspective graphPerspective = view.getGraphPerspective();
        HashSet<NodeView> nodeViewsToSelect = new HashSet<NodeView>();
        for (NodeView nview : view.getSelectedNodes()) {
            Node n = nview.getNode();
            for (Node neib : graphPerspective.neighborsList(n)) {
                NodeView neibview = view.getNodeView(neib);
                nodeViewsToSelect.add(neibview);
            }
        }
        for (NodeView nview : nodeViewsToSelect) {
            nview.setSelected(true);
        }
        view.updateView();
    }

    public static void selectAllNodes(GraphView view) {
        if (view == null) {
            return;
        }
        Iterator i = view.getNodeViewsIterator();
        while (i.hasNext()) {
            NodeView nview = (NodeView)i.next();
            nview.setSelected(true);
        }
        view.updateView();
    }

    public static void deselectAllNodes(GraphView view) {
        if (view == null) {
            return;
        }
        Iterator i = view.getNodeViewsIterator();
        while (i.hasNext()) {
            NodeView nview = (NodeView)i.next();
            nview.setSelected(false);
        }
        view.updateView();
    }

    public static void selectAllEdges(GraphView view) {
        if (view == null) {
            return;
        }
        for (EdgeView eview : view.getEdgeViewsList()) {
            eview.setSelected(true);
        }
        view.updateView();
    }

    public static void deselectAllEdges(GraphView view) {
        if (view == null) {
            return;
        }
        for (EdgeView eview : view.getEdgeViewsList()) {
            eview.setSelected(false);
        }
        view.updateView();
    }

    public static void hideAllEdges(GraphView view) {
        if (view == null) {
            return;
        }
        GraphPerspective graph = view.getGraphPerspective();
        GinyUtils.ensureGraph(graph);
        Set<Integer> hiddenEdges = hiddenEdgesMap.get(graph);
        for (EdgeView eview : view.getEdgeViewsList()) {
            hiddenEdges.add(eview.getEdge().getRootGraphIndex());
            graph.hideEdge(eview.getEdge());
        }
        view.updateView();
    }

    public static void unHideAllEdges(GraphView view) {
        if (view == null) {
            return;
        }
        GraphPerspective graph = view.getGraphPerspective();
        Set<Integer> hiddenEdges = hiddenEdgesMap.get(graph);
        if (hiddenEdges == null) {
            return;
        }
        for (Integer hiddenEdge : hiddenEdges) {
            graph.restoreEdge(hiddenEdge.intValue());
            EdgeView edgeView = view.getEdgeView(hiddenEdge.intValue());
            if (edgeView == null) {
                edgeView = view.addEdgeView(hiddenEdge.intValue());
            }
            if (!(view instanceof CyNetworkView)) continue;
            ((CyNetworkView)view).applyVizMap(edgeView);
        }
        hiddenEdges.clear();
        view.updateView();
    }

    static class GraphDestroyedListener
    implements PropertyChangeListener {
        GraphDestroyedListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            CyNetwork graph = Cytoscape.getNetwork((String)event.getNewValue());
            if (!hiddenNodesMap.containsKey(graph)) {
                return;
            }
            hiddenNodesMap.remove(graph);
            hiddenEdgesMap.remove(graph);
        }
    }

    static class HiddenNode {
        public int index;
        public double x;
        public double y;

        public HiddenNode(NodeView nview) {
            this.index = nview.getNode().getRootGraphIndex();
            this.x = nview.getXPosition();
            this.y = nview.getYPosition();
        }
    }
}

