/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.servers.ui;

import com.nexes.wizard.Wizard;
import com.nexes.wizard.WizardPanelDescriptor;
import cytoscape.Cytoscape;
import cytoscape.actions.MapOntologyAction;
import cytoscape.data.servers.ui.AnotationPanelDescriptor;
import cytoscape.data.servers.ui.LoadGeneOntologyTask;
import cytoscape.data.servers.ui.ManifestFileSelectionPanelDescriptor;
import cytoscape.data.servers.ui.OboPanelDescriptor;
import cytoscape.data.servers.ui.SelectFormatPanelDescriptor;
import cytoscape.logger.CyLogger;
import cytoscape.task.Task;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.task.util.TaskManager;
import java.awt.Container;
import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;

@Deprecated
public class GeneOntologyWizard {
    Wizard wizard;
    WizardPanelDescriptor startDescriptor;
    WizardPanelDescriptor manifestDescriptor;
    WizardPanelDescriptor oboDescriptor;
    WizardPanelDescriptor annotationDescriptor;
    WizardPanelDescriptor speciesDescriptor;
    private boolean flip = false;
    private String species = null;
    private String oldManifest = null;
    private final String FS = System.getProperty("file.separator");
    private final String AUTO_MANIFEST = "auto_generated_manifest";
    String manifestFullPath = null;
    private CyLogger logger = CyLogger.getLogger(GeneOntologyWizard.class);

    public GeneOntologyWizard() {
        this.wizard = new Wizard((Frame)Cytoscape.getDesktop());
        this.wizard.getDialog().setTitle("Gene Ontology Wizard");
        this.startDescriptor = new SelectFormatPanelDescriptor();
        this.wizard.registerWizardPanel((Object)"INTRODUCTION_PANEL", this.startDescriptor);
        this.manifestDescriptor = new ManifestFileSelectionPanelDescriptor();
        this.wizard.registerWizardPanel((Object)"SELECT_OLDFILE_PANEL", this.manifestDescriptor);
        this.annotationDescriptor = new AnotationPanelDescriptor();
        this.wizard.registerWizardPanel((Object)"ANNOTATION_CHOOSE_PANEL", this.annotationDescriptor);
        this.oboDescriptor = new OboPanelDescriptor();
        this.wizard.registerWizardPanel((Object)"OBO_PANEL", this.oboDescriptor);
        this.wizard.setCurrentPanel((Object)"INTRODUCTION_PANEL");
    }

    public int show() {
        int ret = this.wizard.showModalDialog();
        if (ret == 0) {
            LoadGeneOntologyTask task;
            this.oldManifest = ((ManifestFileSelectionPanelDescriptor)this.manifestDescriptor).getManifestFileName();
            if (this.oldManifest == null) {
                this.flip = ((AnotationPanelDescriptor)this.annotationDescriptor).isFlip();
                this.logger.info("Flip = " + this.flip);
                this.generateManifest();
                task = new LoadGeneOntologyTask(this.manifestFullPath);
            } else {
                task = new LoadGeneOntologyTask(this.oldManifest);
            }
            JTaskConfig jTaskConfig = new JTaskConfig();
            jTaskConfig.setOwner((Container)Cytoscape.getDesktop());
            jTaskConfig.displayCancelButton(true);
            jTaskConfig.displayCloseButton(true);
            jTaskConfig.displayStatus(true);
            jTaskConfig.setAutoDispose(false);
            TaskManager.executeTask((Task)task, (JTaskConfig)jTaskConfig);
            MapOntologyAction mapGO = new MapOntologyAction();
            mapGO.actionPerformed(null);
        }
        return ret;
    }

    public void appendSpecies(String parentPath) {
        boolean append = true;
        String autoManifest = parentPath + this.FS + "auto_generated_manifest";
        try {
            FileWriter fw = new FileWriter(autoManifest, append);
            BufferedWriter br = new BufferedWriter(fw);
            PrintWriter pw = new PrintWriter(br);
            pw.println("species=" + this.species);
            pw.close();
        }
        catch (Exception e) {
            this.logger.warn("Unable to append species to: " + autoManifest, e);
        }
    }

    public boolean getFlip() {
        return this.flip;
    }

    public String getManifestFileName() {
        return this.manifestFullPath;
    }

    private void generateManifest() {
        try {
            HashMap gaMap = (HashMap)((AnotationPanelDescriptor)this.annotationDescriptor).getAnotationFiles();
            Iterator it = gaMap.keySet().iterator();
            File[] gaList = new File[gaMap.size()];
            int idx = 0;
            while (it.hasNext()) {
                gaList[idx] = (File)gaMap.get(it.next());
                ++idx;
            }
            File oboFile = ((OboPanelDescriptor)this.oboDescriptor).getOboFile();
            String parentPath = null;
            if (oboFile.canRead()) {
                parentPath = oboFile.getParent() + this.FS;
                this.manifestFullPath = parentPath + "auto_generated_manifest";
                PrintWriter wt = new PrintWriter(new BufferedWriter(new FileWriter(this.manifestFullPath)));
                wt.println("flip=" + this.flip);
                wt.println("obo=" + oboFile.getName());
                for (int i = 0; i < gaList.length; ++i) {
                    wt.println("gene_association=" + gaList[i].getName());
                }
                wt.close();
            }
            this.logger.info("Manifest Created.");
        }
        catch (IOException e1) {
            this.logger.warn("I/O error while generating ontology", e1);
        }
    }
}

