/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.servers.ui;

import cytoscape.logger.CyLogger;
import cytoscape.util.OpenBrowser;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdesktop.layout.GroupLayout;

public class SelectFormatPanel
extends JPanel {
    private static final String HTML_RESOURCE_FILE = "/cytoscape/resources/Gene_Ontology_Wizard.html";
    private CyLogger logger = CyLogger.getLogger(SelectFormatPanel.class);
    private ButtonGroup fileTypeButtonGroup;
    private JEditorPane descriptionEditorPane;
    private JLabel titleLabel;
    private JLabel messageLabel;
    private JRadioButton bdsRadioButton;
    private JRadioButton oboRadioButton;
    private JScrollPane htmlScrollPane;
    private JSeparator jSeparator1;

    public SelectFormatPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.fileTypeButtonGroup = new ButtonGroup();
        this.titleLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.htmlScrollPane = new JScrollPane();
        this.messageLabel = new JLabel();
        this.bdsRadioButton = new JRadioButton();
        this.oboRadioButton = new JRadioButton();
        this.titleLabel.setFont(new Font("Dialog", 1, 14));
        this.titleLabel.setText("Welcome to Gene Ontology Wizard");
        URL descriptionDoc = null;
        try {
            descriptionDoc = this.getClass().getResource(HTML_RESOURCE_FILE);
            this.descriptionEditorPane = new JEditorPane(descriptionDoc);
        }
        catch (MalformedURLException e) {
            this.logger.warn("Illegal URL: " + descriptionDoc.toString(), e);
        }
        catch (IOException e) {
            this.logger.warn("I/O Error while reading from: " + descriptionDoc.toString(), e);
        }
        this.descriptionEditorPane.setEditable(false);
        this.descriptionEditorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                SelectFormatPanel.this.descriptionEditorPaneHyperlinkUpdate(evt);
            }
        });
        this.htmlScrollPane.setHorizontalScrollBarPolicy(31);
        this.htmlScrollPane.setViewportView(this.descriptionEditorPane);
        this.messageLabel.setText("Which file format do you want to load?");
        this.fileTypeButtonGroup.add(this.bdsRadioButton);
        this.bdsRadioButton.setSelected(false);
        this.bdsRadioButton.setText("Cytoscape BioDataServer (.anno and .onto)");
        this.bdsRadioButton.setActionCommand("annoAndOnto");
        this.bdsRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.bdsRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.fileTypeButtonGroup.add(this.oboRadioButton);
        this.oboRadioButton.setText("Gene Ontology (.obo and gene_association)");
        this.oboRadioButton.setActionCommand("oboAndGa");
        this.oboRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.oboRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.oboRadioButton.setSelected(true);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.htmlScrollPane, -1, 328, Short.MAX_VALUE)).add(1, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.titleLabel, -2, 254, -2)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add(65, 65, 65).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.oboRadioButton).add((Component)this.bdsRadioButton))).add(1, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jSeparator1, -2, 328, -2)).add(1, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.messageLabel))).addContainerGap()));
        layout.linkSize(new Component[]{this.bdsRadioButton, this.oboRadioButton}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.titleLabel).add(8, 8, 8).add((Component)this.jSeparator1, -2, 14, -2).addPreferredGap(0).add((Component)this.messageLabel).add(21, 21, 21).add((Component)this.bdsRadioButton, -2, 16, -2).addPreferredGap(0).add((Component)this.oboRadioButton).add(19, 19, 19).add((Component)this.htmlScrollPane, -1, 182, Short.MAX_VALUE).addContainerGap()));
    }

    public String getFileFormatRadioButtonSelected() {
        return this.fileTypeButtonGroup.getSelection().getActionCommand();
    }

    private void descriptionEditorPaneHyperlinkUpdate(HyperlinkEvent evt) {
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            OpenBrowser.openURL(evt.getURL().toString());
        }
    }

    private ImageIcon getImageIcon() {
        return null;
    }

    private Object getResource(String key) {
        URL url = null;
        String name = key;
        if (name != null) {
            try {
                Class<?> c = Class.forName("cytoscape.util.swing.BioDataServerWizard");
                url = c.getResource(name);
            }
            catch (ClassNotFoundException cnfe) {
                this.logger.warn("Unable to find Parent class", cnfe);
            }
            return url;
        }
        return null;
    }
}

