/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.webservice;

import cytoscape.data.webservice.CyWebServiceEventSupport;
import cytoscape.data.webservice.WebServiceClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceClientManager {
    private static Map<String, WebServiceClient> clients;
    private static Map<String, WebServiceClient> clientNameMap;
    private static CyWebServiceEventSupport cwseSupport;

    private WebServiceClientManager() {
        clients = new HashMap<String, WebServiceClient>();
        clientNameMap = new HashMap<String, WebServiceClient>();
        cwseSupport = new CyWebServiceEventSupport();
    }

    public static void registerClient(WebServiceClient client) {
        if (client == null) {
            return;
        }
        clients.put(client.getDisplayName(), client);
        clientNameMap.put(client.getClientID(), client);
    }

    public static List<WebServiceClient> getAllClients() {
        ArrayList<WebServiceClient> clientList = new ArrayList<WebServiceClient>();
        for (String key : clients.keySet()) {
            clientList.add(clients.get(key));
        }
        return clientList;
    }

    public static WebServiceClient getClient(String clientID) {
        return clientNameMap.get(clientID);
    }

    public static void removeClient(String serviceName) {
        if (serviceName == null) {
            return;
        }
        WebServiceClient cl = clientNameMap.get(serviceName);
        if (cl != null) {
            clientNameMap.remove(serviceName);
            clients.remove(cl.getDisplayName());
            cl = null;
        }
    }

    public static CyWebServiceEventSupport getCyWebServiceEventSupport() {
        return cwseSupport;
    }

    static {
        new WebServiceClientManager();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ClientType {
        ANALYSIS,
        ATTRIBUTE,
        NETWORK;

    }
}

