/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs;

import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.util.CyFileFilter;
import cytoscape.util.FileUtil;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.Calculator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class ExportAsGraphicsFileChooser
extends JDialog
implements ActionListener {
    protected File selectedFile;
    private boolean exportTextAsFont = new Boolean(CytoscapeInit.getProperties().getProperty("exportTextAsShape")) == false;
    private static int eventCount = 0;
    private JPanel btnPanel;
    private JButton cancelButton;
    private JCheckBox chkExportTextAsFont;
    private JButton chooseFileButton;
    private JTextField filePathField;
    private JComboBox formatComboBox;
    private JLabel formatLabel;
    private JSeparator jSeparator1;
    private JButton okButton;
    private JLabel selectFileLabel;

    public ExportAsGraphicsFileChooser(CyFileFilter[] formats) {
        super((Frame)Cytoscape.getDesktop(), "Export Network View as Graphics");
        this.setDefaultCloseOperation(2);
        this.initComponents();
        this.setModal(true);
        this.chooseFileButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.formatComboBox.addActionListener(this);
        this.chkExportTextAsFont.addActionListener(this);
        this.chkExportTextAsFont.setSelected(this.exportTextAsFont);
        this.formatComboBox.setModel(new DefaultComboBoxModel<CyFileFilter>(formats));
        this.formatComboBox.setSelectedIndex(0);
        this.formatComboBox.addItemListener(new MyItemListener());
        this.removeFile();
        this.setLocationRelativeTo(Cytoscape.getDesktop());
        this.pack();
    }

    private boolean useTransparency() {
        String tmp;
        VisualStyle vs = Cytoscape.getVisualMappingManager().getVisualStyle();
        Properties node_default_props = vs.getNodeAppearanceCalculator().getDefaultAppearance().getDefaultProperties("");
        Properties edge_default_props = vs.getEdgeAppearanceCalculator().getDefaultAppearance().getDefaultProperties("");
        Enumeration<?> nodePropNames = node_default_props.propertyNames();
        Enumeration<?> edgePropNames = edge_default_props.propertyNames();
        while (nodePropNames.hasMoreElements()) {
            tmp = (String)nodePropNames.nextElement();
            if (!tmp.contains("Opacity") || new Float(node_default_props.getProperty(tmp)).floatValue() == 255.0f) continue;
            return true;
        }
        while (edgePropNames.hasMoreElements()) {
            tmp = (String)edgePropNames.nextElement();
            if (!tmp.contains("Opacity") || new Float(edge_default_props.getProperty(tmp)).floatValue() == 255.0f) continue;
            return true;
        }
        List<Calculator> node_calculators = vs.getNodeAppearanceCalculator().getCalculators();
        for (Calculator cal : node_calculators) {
            if (cal.getVisualPropertyType() != VisualPropertyType.NODE_OPACITY && cal.getVisualPropertyType() != VisualPropertyType.NODE_BORDER_OPACITY && cal.getVisualPropertyType() != VisualPropertyType.NODE_LABEL_OPACITY) continue;
            return true;
        }
        List<Calculator> edge_calculators = vs.getEdgeAppearanceCalculator().getCalculators();
        for (Calculator cal : edge_calculators) {
            if (cal.getVisualPropertyType() != VisualPropertyType.EDGE_OPACITY && cal.getVisualPropertyType() != VisualPropertyType.EDGE_LABEL_OPACITY && cal.getVisualPropertyType() != VisualPropertyType.EDGE_TGTARROW_OPACITY && cal.getVisualPropertyType() != VisualPropertyType.EDGE_SRCARROW_OPACITY) continue;
            return true;
        }
        return false;
    }

    public CyFileFilter getSelectedFormat() {
        return (CyFileFilter)this.formatComboBox.getSelectedItem();
    }

    public File getSelectedFile() {
        return this.selectedFile;
    }

    public void addActionListener(ActionListener l) {
        this.okButton.addActionListener(l);
    }

    protected void assignFile(File file) {
        this.selectedFile = file;
        this.filePathField.setText(this.selectedFile.getPath());
        this.okButton.setEnabled(true);
        if (this.formatComboBox.getSelectedItem().toString().equalsIgnoreCase("EPS (*.eps)") && this.useTransparency()) {
            this.okButton.setEnabled(false);
        }
    }

    protected void removeFile() {
        this.selectedFile = null;
        this.filePathField.setText("");
        this.okButton.setEnabled(false);
    }

    protected void updateExtension() {
        if (this.selectedFile == null) {
            return;
        }
        String name = this.selectedFile.getName();
        int extensionIndex = name.lastIndexOf(46);
        if (extensionIndex != -1) {
            name = name.substring(0, extensionIndex);
        }
        CyFileFilter filter = (CyFileFilter)this.formatComboBox.getSelectedItem();
        String newExtension = (String)filter.getExtensionSet().iterator().next();
        this.selectedFile = new File(this.selectedFile.getParent(), name + "." + newExtension);
        this.filePathField.setText(this.selectedFile.getPath());
        this.okButton.setEnabled(true);
        if (this.formatComboBox.getSelectedItem().toString().equalsIgnoreCase("EPS (*.eps)") && this.useTransparency()) {
            this.okButton.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent e) {
        JButton btn;
        Object obj = e.getSource();
        if (obj instanceof JButton && (btn = (JButton)obj) != this.okButton) {
            if (btn == this.cancelButton) {
                this.dispose();
            } else if (btn == this.chooseFileButton) {
                CyFileFilter filter = this.getSelectedFormat();
                String extension = "." + (String)filter.getExtensionSet().iterator().next();
                CyFileFilter[] filters = new CyFileFilter[]{filter};
                File[] files = FileUtil.getFiles("Export Network View as Graphics", FileUtil.SAVE, filters, null, null, false);
                if (files != null && files.length != 0 && files[0] != null) {
                    File file = files[0];
                    if (!file.getName().endsWith(extension)) {
                        file = new File(file.getPath() + extension);
                    }
                    this.assignFile(file);
                }
            }
        }
        if (obj instanceof JComboBox) {
            this.updateExtension();
            CyFileFilter filter = (CyFileFilter)this.formatComboBox.getSelectedItem();
            if (filter.getClass().getName().equalsIgnoreCase("cytoscape.actions.PDFExportFilter") || filter.getClass().getName().equalsIgnoreCase("cytoscape.actions.SVGExportFilter") || filter.getClass().getName().equalsIgnoreCase("cytoscape.actions.PSExportFilter")) {
                this.chkExportTextAsFont.setEnabled(true);
            } else {
                this.chkExportTextAsFont.setEnabled(false);
            }
        }
        if (obj instanceof JCheckBox) {
            this.exportTextAsFont = this.chkExportTextAsFont.isSelected();
            String exportTextAsShape = "false";
            if (!this.exportTextAsFont) {
                exportTextAsShape = "true";
            }
            CytoscapeInit.getProperties().setProperty("exportTextAsShape", exportTextAsShape);
        }
    }

    public boolean getExportTextAsFont() {
        return this.exportTextAsFont;
    }

    private void initComponents() {
        this.selectFileLabel = new JLabel();
        this.filePathField = new JTextField();
        this.chooseFileButton = new JButton();
        this.formatLabel = new JLabel();
        this.formatComboBox = new JComboBox();
        this.btnPanel = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.chkExportTextAsFont = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.selectFileLabel.setText("File to export to:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        this.getContentPane().add((Component)this.selectFileLabel, gridBagConstraints);
        this.filePathField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        this.getContentPane().add((Component)this.filePathField, gridBagConstraints);
        this.chooseFileButton.setText("Choose...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.getContentPane().add((Component)this.chooseFileButton, gridBagConstraints);
        this.formatLabel.setText("Format:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.getContentPane().add((Component)this.formatLabel, gridBagConstraints);
        this.formatComboBox.setPreferredSize(new Dimension(120, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        this.getContentPane().add((Component)this.formatComboBox, gridBagConstraints);
        this.okButton.setText("OK");
        this.btnPanel.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.btnPanel.add(this.cancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(15, 0, 15, 0);
        this.getContentPane().add((Component)this.btnPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.chkExportTextAsFont.setText("Export text as font");
        this.chkExportTextAsFont.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkExportTextAsFont.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 10, 0);
        this.getContentPane().add((Component)this.chkExportTextAsFont, gridBagConstraints);
    }

    private class MyItemListener
    implements ItemListener {
        private MyItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            eventCount++;
            if (eventCount % 2 == 0) {
                eventCount = 0;
                return;
            }
            if (ExportAsGraphicsFileChooser.this.formatComboBox.getSelectedItem().toString().equalsIgnoreCase("EPS (*.eps)") && ExportAsGraphicsFileChooser.this.useTransparency()) {
                JOptionPane.showMessageDialog(Cytoscape.getDesktop(), "Could not export in EPS format, because transparency is used in the visual style!");
                ExportAsGraphicsFileChooser.this.okButton.setEnabled(false);
                ExportAsGraphicsFileChooser.this.chooseFileButton.setEnabled(false);
            } else {
                if (ExportAsGraphicsFileChooser.this.selectedFile != null) {
                    ExportAsGraphicsFileChooser.this.okButton.setEnabled(true);
                } else {
                    ExportAsGraphicsFileChooser.this.okButton.setEnabled(false);
                }
                ExportAsGraphicsFileChooser.this.chooseFileButton.setEnabled(true);
            }
        }
    }
}

