/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs;

import cytoscape.logger.CyLogger;
import java.awt.GridLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class IntegerEntryField
extends JPanel {
    JTextField sizeField;
    JLabel sizeLabel;
    JFrame mainFrame;
    JPanel mainPanel;

    public IntegerEntryField(String fieldName, int defaultValue, int maxValue) {
        super(new GridLayout(1, 2, 10, 10));
        this.sizeLabel = new JLabel(fieldName);
        this.sizeField = new JTextField(Integer.toString(defaultValue));
        this.sizeField.addFocusListener(new PositiveIntegerListener(defaultValue, maxValue));
        this.add(this.sizeLabel);
        this.add(this.sizeField);
    }

    public Integer getInteger() {
        return new Integer(this.sizeField.getText());
    }

    public void setInteger(Integer newVal) {
        this.sizeField.setText(newVal.toString());
    }

    public int getInt() {
        return Integer.parseInt(this.sizeField.getText());
    }

    public void setInt(int newVal) {
        this.sizeField.setText(Integer.toString(newVal));
    }

    public JTextField getField() {
        return this.sizeField;
    }

    public JLabel getLabel() {
        return this.sizeLabel;
    }

    public class PositiveIntegerListener
    implements FocusListener {
        private int digits;
        private int maxval;
        private int defaultVal;
        private String maxvalString;
        private String defaultString;

        public PositiveIntegerListener(int defaultVal, int maxval) {
            this.maxval = maxval;
            this.defaultVal = defaultVal;
            this.maxvalString = Integer.toString(maxval);
            this.defaultString = Integer.toString(defaultVal);
            this.digits = this.maxvalString.length();
        }

        public void focusGained(FocusEvent e) {
            this.validate((JTextField)e.getSource());
        }

        public void focusLost(FocusEvent e) {
            this.validate((JTextField)e.getSource());
        }

        private void validate(JTextField field) {
            block8: {
                String fieldStr = field.getText();
                if ((fieldStr = fieldStr.replaceAll("[^0-9]", "")).length() > 0) {
                    if (fieldStr.length() > this.digits) {
                        field.setText(this.maxvalString);
                    } else {
                        try {
                            int val = Integer.parseInt(fieldStr);
                            if (val <= 0) {
                                field.setText(this.defaultString);
                                break block8;
                            }
                            if (val > this.maxval) {
                                field.setText(this.maxvalString);
                                break block8;
                            }
                            field.setText(fieldStr);
                        }
                        catch (NumberFormatException nfe) {
                            CyLogger.getLogger().info("Not an integer: " + fieldStr, nfe);
                            field.setText(this.defaultString);
                        }
                    }
                } else {
                    field.setText(this.defaultString);
                }
            }
        }
    }
}

