/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs;

import cytoscape.CyNetwork;
import cytoscape.data.readers.MetadataEntries;
import cytoscape.data.readers.MetadataParser;
import cytoscape.dialogs.NetworkMetaDataTableModel;
import cytoscape.logger.CyLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URISyntaxException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.xml.bind.JAXBException;
import org.jdesktop.layout.GroupLayout;

public class NetworkMetaDataDialog
extends JDialog
implements TableModelListener {
    private NetworkMetaDataTableModel metaTM;
    private MetadataParser mdp;
    private CyNetwork network;
    private String description;
    private CyLogger logger = CyLogger.getLogger(NetworkMetaDataDialog.class);
    private JButton okButton;
    private JButton cancelButton;
    private JTextArea descriptionTextArea;
    private JLabel titleLabel;
    private JPanel jPanel1;
    private JScrollPane metadataTableScrollPane;
    private JScrollPane descriptionScrollPane;
    private JSplitPane mainSplitPane;
    private JTable metadataTable;

    public NetworkMetaDataDialog(Frame parent, boolean modal, CyNetwork network) {
        super(parent, modal);
        this.network = network;
        this.mdp = new MetadataParser(network);
        this.metaTM = new NetworkMetaDataTableModel(network);
        try {
            this.metaTM.setTable();
        }
        catch (URISyntaxException e) {
            this.logger.warn("Unable to parse some of the network meta-data", e);
        }
        this.description = this.metaTM.getDescription();
        this.initComponents();
    }

    private void initComponents() {
        Font titleFont = new Font("SansSerif", 1, 14);
        this.setTitle("Network Metadata Editor");
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.titleLabel = new JLabel();
        this.mainSplitPane = new JSplitPane();
        this.metadataTableScrollPane = new JScrollPane();
        this.descriptionScrollPane = new JScrollPane();
        this.descriptionTextArea = new JTextArea();
        this.setDefaultCloseOperation(2);
        this.okButton.setText("Update");
        this.okButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                NetworkMetaDataDialog.this.okButtonMouseClicked(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                NetworkMetaDataDialog.this.cancelButtonMouseClicked(evt);
            }
        });
        this.titleLabel.setText("Network Metadata for " + this.network.getTitle());
        this.titleLabel.setFont(titleFont);
        this.titleLabel.setForeground(Color.BLUE);
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.titleLabel, -2, 500, -2).addContainerGap(5, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((Component)this.titleLabel)));
        this.mainSplitPane.setDividerLocation(120);
        this.mainSplitPane.setDividerSize(5);
        this.mainSplitPane.setOrientation(0);
        this.metadataTableScrollPane.setViewportView(this.getMetadataTable());
        this.mainSplitPane.setTopComponent(this.metadataTableScrollPane);
        this.descriptionScrollPane.setBorder(null);
        this.descriptionScrollPane.setBorder(BorderFactory.createTitledBorder("Description"));
        this.descriptionTextArea.setText(this.description);
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setWrapStyleWord(false);
        this.descriptionTextArea.setTabSize(4);
        this.descriptionTextArea.setEditable(true);
        this.descriptionScrollPane.setViewportView(this.descriptionTextArea);
        this.descriptionScrollPane.setHorizontalScrollBarPolicy(31);
        this.mainSplitPane.setRightComponent(this.descriptionScrollPane);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(201, Short.MAX_VALUE).add((Component)this.okButton).addPreferredGap(0).add((Component)this.cancelButton).addContainerGap()).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((Component)this.mainSplitPane, -1, 343, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.mainSplitPane, -1, 339, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.okButton).add((Component)this.cancelButton)).addContainerGap()));
        this.pack();
    }

    private void cancelButtonMouseClicked(MouseEvent evt) {
        this.dispose();
    }

    private void okButtonMouseClicked(MouseEvent evt) {
        try {
            this.update();
        }
        catch (JAXBException e1) {
            this.logger.warn("Unable to update network metadata", e1);
        }
        this.dispose();
    }

    private void update() throws JAXBException {
        Vector<Vector> dataVector = this.metaTM.getDataVector();
        for (Vector row : dataVector) {
            String label = (String)row.get(0);
            Object value = row.get(1);
            if (label == null) continue;
            if (value == null) {
                this.mdp.setMetadata(MetadataEntries.valueOf(label.toUpperCase()), "N/A");
                continue;
            }
            this.mdp.setMetadata(MetadataEntries.valueOf(label.toUpperCase()), value.toString());
        }
        this.mdp.setMetadata(MetadataEntries.DESCRIPTION, this.descriptionTextArea.getText());
    }

    private JTable getMetadataTable() {
        if (this.metadataTable == null) {
            this.metaTM.addTableModelListener(new metadataTableListener());
            this.metadataTable = new JTable(this.metaTM);
            this.metadataTable.setRowSelectionAllowed(true);
        }
        return this.metadataTable;
    }

    public void tableChanged(TableModelEvent arg0) {
    }

    class metadataTableListener
    implements TableModelListener {
        metadataTableListener() {
        }

        public void tableChanged(TableModelEvent arg0) {
        }
    }
}

