/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs.plugins;

import cytoscape.Cytoscape;
import cytoscape.CytoscapeVersion;
import cytoscape.dialogs.plugins.LicenseDialog;
import cytoscape.dialogs.plugins.ManagerModel;
import cytoscape.dialogs.plugins.PluginUrlDialog;
import cytoscape.dialogs.plugins.TreeCellRenderer;
import cytoscape.dialogs.plugins.TreeNode;
import cytoscape.logger.CyLogger;
import cytoscape.plugin.Category;
import cytoscape.plugin.DownloadableInfo;
import cytoscape.plugin.Installable;
import cytoscape.plugin.ManagerException;
import cytoscape.plugin.PluginException;
import cytoscape.plugin.PluginInfo;
import cytoscape.plugin.PluginManager;
import cytoscape.plugin.ThemeInfo;
import cytoscape.plugin.WebstartException;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.task.util.TaskManager;
import cytoscape.util.OpenBrowser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginManageDialog
extends JDialog
implements TreeSelectionListener,
ActionListener {
    private static CyLogger logger = CyLogger.getLogger(PluginManageDialog.class);
    private String baseSiteLabel = "Plugins available for download from: ";
    private JLabel availablePluginsLabel;
    private JPanel bottomPane;
    private JPanel buttonPanel;
    private JButton changeSiteButton;
    private JButton closeButton;
    private JScrollPane infoScrollPane;
    private JEditorPane infoTextPane;
    private JButton installDeleteButton;
    private JSplitPane jSplitPane1;
    private JTextArea downloadLocText;
    private JLabel msgLabel;
    private JTextArea msgPanel;
    private JTree pluginTree;
    private JPanel sitePanel;
    private JPanel topPane;
    private JScrollPane treeScrollPane;
    private JCheckBox versionCheck;
    private TreeNode rootTreeNode;
    private TreeNode installedNode;
    private TreeNode availableNode;
    private ManagerModel treeModel;
    private TreeCellRenderer treeRenderer;
    private HashMap<TreeNode, List<TreeNode>> hiddenNodes;

    public PluginManageDialog() {
        this.setTitle("Manage Plugins");
        this.initComponents();
        this.initTree();
        this.setSize(600, 500);
    }

    public PluginManageDialog(JDialog owner) {
        super((Dialog)owner, "Manage Plugins");
        this.setLocationRelativeTo(owner);
        this.initComponents();
        this.initTree();
        this.setSize(600, 500);
    }

    public PluginManageDialog(JFrame owner) {
        super((Frame)owner, "Manage Plugins");
        this.setLocationRelativeTo(owner);
        this.initComponents();
        this.initTree();
        this.setSize(600, 500);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        logger.info("URL DIALOG: " + evt.getSource().toString());
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreeNode Node2 = (TreeNode)this.pluginTree.getLastSelectedPathComponent();
        if (Node2 == null) {
            return;
        }
        if (Node2.isLeaf()) {
            this.infoTextPane.setContentType("text/html");
            this.infoTextPane.setText(Node2.getObject().htmlOutput());
            this.infoTextPane.setCaretPosition(0);
            this.infoTextPane.setEditable(false);
            this.infoTextPane.addHyperlinkListener(new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent evt) {
                    if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        OpenBrowser.openURL(evt.getURL().toString());
                    }
                }
            });
            if (Node2.isNodeAncestor(this.installedNode)) {
                this.installDeleteButton.setText("Delete");
                if (PluginManager.usingWebstartManager()) {
                    this.installDeleteButton.setEnabled(false);
                    this.setMessage("Delete is unavailable when using Web Start");
                } else {
                    this.installDeleteButton.setEnabled(true);
                }
            } else if (Node2.isNodeAncestor(this.availableNode)) {
                this.installDeleteButton.setText("Install");
                this.installDeleteButton.setEnabled(true);
            }
        } else {
            this.installDeleteButton.setEnabled(false);
        }
    }

    public void setMessage(String Msg) {
        this.msgPanel.setForeground(Color.BLACK);
        this.msgPanel.setText(Msg);
    }

    public void setError(String Msg) {
        this.msgPanel.setForeground(new Color(204, 0, 51));
        this.msgPanel.setText(Msg);
    }

    public void setSiteName(String SiteName) {
        this.downloadLocText.setText(SiteName);
    }

    public void switchDownloadSites() {
        this.hiddenNodes.clear();
        Vector<TreeNode> AvailableNodes = new Vector<TreeNode>(this.availableNode.getChildren());
        for (TreeNode child : AvailableNodes) {
            this.treeModel.removeNodeFromParent(child);
        }
    }

    public void addCategory(String CategoryName, List<DownloadableInfo> Plugins2, PluginInstallStatus Status) {
        switch (Status) {
            case INSTALLED: {
                this.addCategory(CategoryName, Plugins2, this.installedNode);
                break;
            }
            case AVAILABLE: {
                this.addCategory(CategoryName, Plugins2, this.availableNode);
                if (this.treeModel.getIndexOfChild(this.rootTreeNode, this.availableNode) >= 0) break;
                this.treeModel.addNodeToParent(this.rootTreeNode, this.availableNode);
            }
        }
        ToolTipManager.sharedInstance().registerComponent(this.pluginTree);
        ImageIcon warningIcon = this.createImageIcon("/cytoscape/images/misc/alert-red2.gif", "Warning");
        ImageIcon okIcon = this.createImageIcon("/cytoscape/images/misc/check-mark.gif", "Ok");
        if (warningIcon != null) {
            this.treeRenderer = new TreeCellRenderer((Icon)warningIcon, okIcon);
            this.pluginTree.setCellRenderer(this.treeRenderer);
        }
        this.pluginTree.expandPath(new TreePath(this.availableNode.getPath()));
        this.pluginTree.expandPath(new TreePath(this.installedNode.getPath()));
    }

    private void addCategory(String CategoryName, List<DownloadableInfo> Plugins2, TreeNode node) {
        TreeNode Category2 = new TreeNode(CategoryName, true);
        for (DownloadableInfo CurrentPlugin : Plugins2) {
            TreeNode PluginNode = new TreeNode(CurrentPlugin);
            if (node.equals(this.availableNode) && !CurrentPlugin.isPluginCompatibleWithCurrent()) {
                List<TreeNode> hiddenCat = this.hiddenNodes.get(Category2);
                if (hiddenCat == null) {
                    hiddenCat = new ArrayList<TreeNode>();
                }
                hiddenCat.add(PluginNode);
                this.hiddenNodes.put(Category2, hiddenCat);
                if (!this.versionCheck.isSelected()) continue;
                this.treeModel.addNodeToParent(Category2, PluginNode);
                continue;
            }
            this.treeModel.addNodeToParent(Category2, PluginNode);
        }
        if (Category2.getChildCount() > 0) {
            this.treeModel.addNodeToParent(node, Category2);
        }
    }

    private void changeSiteButtonActionPerformed(ActionEvent evt) {
        PluginUrlDialog dialog = new PluginUrlDialog(this);
        dialog.setVisible(true);
    }

    private void versionCheckItemStateChanged(ItemEvent evt) {
        TreePath[] SelectedPaths = this.pluginTree.getSelectionPaths();
        if (evt.getStateChange() == 1) {
            this.pluginTree.collapsePath(new TreePath(this.availableNode.getPath()));
            this.availableNode.removeChildren();
            for (TreeNode Category2 : this.hiddenNodes.keySet()) {
                for (TreeNode Plugin2 : this.hiddenNodes.get(Category2)) {
                    this.treeModel.addNodeToParent(Category2, Plugin2);
                }
                this.treeModel.addNodeToParent(this.availableNode, Category2);
            }
        } else if (evt.getStateChange() == 2) {
            for (TreeNode Category2 : this.hiddenNodes.keySet()) {
                for (TreeNode Plugin2 : this.hiddenNodes.get(Category2)) {
                    this.hiddenNodes.get(Category2);
                    this.treeModel.removeNodesFromParent(this.hiddenNodes.get(Category2));
                    if (Category2.getChildCount() > 0) continue;
                    this.availableNode.removeChild(Category2);
                    this.treeModel.reload();
                }
            }
        }
        if (SelectedPaths != null) {
            for (TreePath Path2 : SelectedPaths) {
                this.pluginTree.expandPath(Path2);
                this.pluginTree.setSelectionPath(Path2);
            }
        } else {
            this.pluginTree.expandPath(new TreePath(this.availableNode.getPath()));
            this.pluginTree.expandPath(new TreePath(this.installedNode.getPath()));
        }
    }

    private void installDeleteButtonActionPerformed(ActionEvent evt) {
        if (this.installDeleteButton.getText().equals("Delete")) {
            this.deleteButtonActionPerformed(evt);
        } else if (this.installDeleteButton.getText().equals("Install")) {
            this.installButtonActionPerformed(evt);
        }
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        TreeNode Node2 = (TreeNode)this.pluginTree.getLastSelectedPathComponent();
        if (Node2 == null) {
            return;
        }
        DownloadableInfo NodeInfo = Node2.getObject();
        String ChangeMsg = "Changes will not take effect until you have restarted Cytoscape.";
        String VerifyMsg = "";
        VerifyMsg = NodeInfo.getCategory().equalsIgnoreCase("core") ? "This is a 'core' plugin and other plugins may depend on it, are you sure you want to delete it?\n" + ChangeMsg : "Are you sure you want to delete the plugin '" + NodeInfo.getName() + "'?\n" + ChangeMsg;
        if (0 == JOptionPane.showConfirmDialog(this, VerifyMsg, "Verify Delete Plugin", 0, 3)) {
            try {
                PluginManager.getPluginManager().delete(NodeInfo);
                this.treeModel.removeNodeFromParent(Node2);
                this.setMessage(NodeInfo.getName() + " will be removed when you restart Cytoscape.");
            }
            catch (WebstartException we) {
                logger.warn("Unable to remove '" + NodeInfo.getName() + "': " + we.getMessage(), we);
            }
        }
    }

    private void installButtonActionPerformed(ActionEvent evt) {
        final TreeNode node = (TreeNode)this.pluginTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        DownloadableInfo nodeInfo = node.getObject();
        if (node.isLeaf()) {
            boolean licenseRequired = false;
            final LicenseDialog License2 = new LicenseDialog(this);
            final DownloadableInfo infoObj = nodeInfo;
            switch (infoObj.getType()) {
                case PLUGIN: {
                    if (infoObj.getLicenseText() == null) break;
                    License2.addPlugin(infoObj);
                    licenseRequired = true;
                    break;
                }
                case THEME: {
                    ThemeInfo themeInfo = (ThemeInfo)infoObj;
                    for (PluginInfo pInfo : themeInfo.getPlugins()) {
                        if (pInfo.getLicenseText() == null) continue;
                        License2.addPlugin(pInfo);
                        licenseRequired = true;
                    }
                    break;
                }
            }
            if (licenseRequired) {
                License2.addListenerToOk(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        License2.dispose();
                        PluginManageDialog.this.createInstallTask(infoObj, node);
                    }
                });
                License2.selectDefault();
                License2.setVisible(true);
            } else {
                this.createInstallTask(infoObj, node);
            }
        }
    }

    private void updateCurrent(DownloadableInfo info) {
        boolean categoryMatched = false;
        for (TreeNode Child2 : this.installedNode.getChildren()) {
            if (!Child2.getTitle().equals(info.getCategory())) continue;
            Child2.addChild(new TreeNode(info));
            categoryMatched = true;
        }
        if (!categoryMatched) {
            ArrayList<DownloadableInfo> NewPlugin = new ArrayList<DownloadableInfo>();
            NewPlugin.add(info);
            this.addCategory(info.getCategory(), NewPlugin, PluginInstallStatus.INSTALLED);
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void initTree() {
        this.pluginTree.setRootVisible(false);
        this.pluginTree.addTreeSelectionListener(this);
        this.pluginTree.getSelectionModel().setSelectionMode(1);
        this.rootTreeNode = new TreeNode("Plugins", true);
        this.installedNode = new TreeNode(PluginInstallStatus.INSTALLED.toString(), true);
        this.availableNode = new TreeNode(PluginInstallStatus.AVAILABLE.toString(), true);
        this.treeModel = new ManagerModel(this.rootTreeNode);
        this.treeModel.addNodeToParent(this.rootTreeNode, this.installedNode);
        this.treeModel.addNodeToParent(this.rootTreeNode, this.availableNode);
        this.pluginTree.setModel(this.treeModel);
        this.hiddenNodes = new HashMap();
    }

    private void initComponents() {
        this.topPane = new JPanel();
        this.availablePluginsLabel = new JLabel();
        this.downloadLocText = new JTextArea();
        this.sitePanel = new JPanel();
        this.changeSiteButton = new JButton();
        this.versionCheck = new JCheckBox();
        this.jSplitPane1 = new JSplitPane();
        this.treeScrollPane = new JScrollPane();
        this.pluginTree = new JTree();
        this.infoScrollPane = new JScrollPane();
        this.infoTextPane = new JEditorPane();
        this.bottomPane = new JPanel();
        this.msgLabel = new JLabel();
        this.msgPanel = new JTextArea();
        this.buttonPanel = new JPanel();
        this.installDeleteButton = new JButton();
        this.closeButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.topPane.setLayout(new GridBagLayout());
        this.availablePluginsLabel.setText("Plugins available for download from:");
        this.availablePluginsLabel.setEnabled(false);
        this.availablePluginsLabel.setFocusable(false);
        this.availablePluginsLabel.setInheritsPopupMenu(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 5, 0);
        this.topPane.add((Component)this.availablePluginsLabel, gridBagConstraints);
        this.downloadLocText.setBackground(new Color(230, 230, 230));
        this.downloadLocText.setColumns(20);
        this.downloadLocText.setEditable(false);
        this.downloadLocText.setLineWrap(true);
        this.downloadLocText.setRows(5);
        this.downloadLocText.setWrapStyleWord(true);
        this.downloadLocText.setFocusable(false);
        this.downloadLocText.setMinimumSize(new Dimension(102, 50));
        this.downloadLocText.setPreferredSize(new Dimension(100, 60));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 30);
        this.topPane.add((Component)this.downloadLocText, gridBagConstraints);
        this.sitePanel.setLayout(new GridBagLayout());
        this.changeSiteButton.setText("Change Download Site");
        this.changeSiteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PluginManageDialog.this.changeSiteButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 10);
        this.sitePanel.add((Component)this.changeSiteButton, gridBagConstraints);
        this.versionCheck.setText("Show outdated Plugins");
        this.versionCheck.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.versionCheck.setMargin(new Insets(0, 0, 0, 0));
        this.versionCheck.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                PluginManageDialog.this.versionCheckItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.sitePanel.add((Component)this.versionCheck, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.topPane.add((Component)this.sitePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.getContentPane().add((Component)this.topPane, gridBagConstraints);
        this.jSplitPane1.setDividerLocation(250);
        this.jSplitPane1.setPreferredSize(new Dimension(400, 326));
        this.treeScrollPane.setViewportView(this.pluginTree);
        this.jSplitPane1.setLeftComponent(this.treeScrollPane);
        this.infoScrollPane.setViewportView(this.infoTextPane);
        this.jSplitPane1.setRightComponent(this.infoScrollPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.getContentPane().add((Component)this.jSplitPane1, gridBagConstraints);
        this.bottomPane.setLayout(new GridBagLayout());
        this.msgLabel.setText("Messages:");
        this.msgLabel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 5, 0);
        this.bottomPane.add((Component)this.msgLabel, gridBagConstraints);
        this.msgPanel.setBackground(new Color(230, 230, 230));
        this.msgPanel.setColumns(20);
        this.msgPanel.setEditable(false);
        this.msgPanel.setLineWrap(true);
        this.msgPanel.setRows(5);
        this.msgPanel.setWrapStyleWord(true);
        this.msgPanel.setMinimumSize(new Dimension(30, 50));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 10, 20);
        this.bottomPane.add((Component)this.msgPanel, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.installDeleteButton.setText("Install");
        this.installDeleteButton.setEnabled(false);
        this.installDeleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PluginManageDialog.this.installDeleteButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        this.buttonPanel.add((Component)this.installDeleteButton, gridBagConstraints);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PluginManageDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add((Component)this.closeButton, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 20, 0, 20);
        this.bottomPane.add((Component)this.buttonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.bottomPane, gridBagConstraints);
        this.pack();
    }

    private void createInstallTask(DownloadableInfo obj, TreeNode node) {
        InstallTask task = new InstallTask(obj, node);
        JTaskConfig jTaskConfig = new JTaskConfig();
        jTaskConfig.setOwner((Container)Cytoscape.getDesktop());
        jTaskConfig.displayCloseButton(false);
        jTaskConfig.displayStatus(true);
        jTaskConfig.setAutoDispose(true);
        jTaskConfig.displayCancelButton(true);
        TaskManager.executeTask((Task)task, (JTaskConfig)jTaskConfig);
        DownloadableInfo info = task.getDownloadedPlugin();
        if (info != null) {
            this.updateCurrent(info);
            this.cleanTree(node);
        }
    }

    private void cleanTree(TreeNode node) {
        DownloadableInfo info = node.getObject();
        ArrayList<TreeNode> RemovableNodes = new ArrayList<TreeNode>();
        for (int i = 0; i < node.getParent().getChildCount(); ++i) {
            TreeNode Child2 = node.getParent().getChildAt(i);
            DownloadableInfo childInfo = Child2.getObject();
            if (!childInfo.getID().equals(info.getID()) || !childInfo.getName().equals(info.getName())) continue;
            RemovableNodes.add(Child2);
        }
        for (TreeNode treeNode : RemovableNodes) {
            this.treeModel.removeNodeFromParent(treeNode);
        }
    }

    public static void main(String[] args) {
        PluginManageDialog pd = new PluginManageDialog();
        pd.setSiteName("Testing");
        ArrayList<DownloadableInfo> Plugins2 = new ArrayList<DownloadableInfo>();
        PluginInfo infoC = new PluginInfo("1", "A Plugin");
        infoC.addCytoscapeVersion(CytoscapeVersion.version);
        Plugins2.add(infoC);
        infoC = new PluginInfo("2", "B Plugin");
        infoC.addCytoscapeVersion(CytoscapeVersion.version);
        Plugins2.add(infoC);
        infoC = new PluginInfo("3", "C");
        infoC.addCytoscapeVersion(CytoscapeVersion.version);
        Plugins2.add(infoC);
        pd.addCategory(Category.NONE.toString(), Plugins2, PluginInstallStatus.AVAILABLE);
        ArrayList<DownloadableInfo> Outdated = new ArrayList<DownloadableInfo>();
        PluginInfo infoOD = new PluginInfo("11", "CyGoose");
        infoOD.addCytoscapeVersion("2.3");
        Outdated.add(infoOD);
        infoOD = new PluginInfo("12", "Y");
        infoOD.addCytoscapeVersion("2.3");
        Outdated.add(infoOD);
        pd.addCategory("Outdated", Outdated, PluginInstallStatus.AVAILABLE);
        pd.setMessage("Foo bar");
        pd.setVisible(true);
    }

    private ImageIcon createImageIcon(String path, String description) {
        URL imgURL = this.getClass().getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL, description);
        }
        CyLogger.getLogger().warn("Couldn't find file: " + path);
        return null;
    }

    private class InstallTask
    implements Task {
        private TaskMonitor taskMonitor;
        private DownloadableInfo infoObj;
        private TreeNode node;

        public InstallTask(DownloadableInfo Info, TreeNode Node2) throws IllegalArgumentException {
            String ErrorMsg = null;
            if (Info == null) {
                ErrorMsg = "DownloadableInfo object cannot be null\n";
                throw new IllegalArgumentException(ErrorMsg);
            }
            this.infoObj = Info;
            this.node = Node2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.taskMonitor == null) {
                throw new IllegalStateException("Task Monitor is not set.");
            }
            this.taskMonitor.setStatus("Installing " + this.infoObj.getName() + " v" + this.infoObj.getObjectVersion());
            this.taskMonitor.setPercentCompleted(-1);
            PluginManager Mgr = PluginManager.getPluginManager();
            Installable ins = this.infoObj.getInstallable();
            try {
                this.infoObj = Mgr.download(this.infoObj, this.taskMonitor);
                this.taskMonitor.setStatus(this.infoObj.getName() + " v" + this.infoObj.getObjectVersion() + " complete.");
                PluginManageDialog.this.setMessage(this.infoObj.toString() + " install complete.");
                this.taskMonitor.setStatus(this.infoObj.toString() + " loading...");
                Mgr.install(this.infoObj);
                Mgr.loadPlugin(this.infoObj);
            }
            catch (IOException ioe) {
                this.taskMonitor.setException((Throwable)ioe, "Failed to download " + this.infoObj.getName() + " from " + this.infoObj.getObjectUrl());
                this.infoObj = null;
                logger.warn("Failed to download " + this.infoObj.getName() + " from " + this.infoObj.getObjectUrl(), ioe);
            }
            catch (ManagerException me) {
                PluginManageDialog.this.setError("Failed to install " + this.infoObj.toString());
                this.taskMonitor.setException((Throwable)me, me.getMessage());
                this.infoObj = null;
                logger.warn("Failed to install " + this.infoObj.toString(), me);
            }
            catch (PluginException pe) {
                PluginManageDialog.this.setError("Failed to install " + this.infoObj.toString());
                this.infoObj = null;
                this.taskMonitor.setException((Throwable)pe, pe.getMessage());
                logger.warn("Failed to install " + this.infoObj.toString(), pe);
            }
            catch (ClassNotFoundException cne) {
                this.taskMonitor.setException((Throwable)cne, cne.getMessage());
                PluginManageDialog.this.setError("Failed to install " + this.infoObj.toString());
                this.infoObj = null;
                logger.warn("Failed to install " + this.infoObj.toString(), cne);
            }
            finally {
                this.taskMonitor.setPercentCompleted(100);
            }
            try {
                if (this.infoObj == null) {
                    ins.uninstall();
                }
            }
            catch (ManagerException me) {
                logger.warn("Failed to cleanup after installation failure", me);
            }
        }

        public DownloadableInfo getDownloadedPlugin() {
            return this.infoObj;
        }

        public void halt() {
        }

        public void setTaskMonitor(TaskMonitor monitor) throws IllegalThreadStateException {
            this.taskMonitor = monitor;
        }

        public String getTitle() {
            return "Installing Cytoscape " + this.infoObj.getType().name() + " '" + this.infoObj.getName() + "'";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CommonError {
        NOXML("ERROR: Failed to read XML file "),
        BADXML("ERROR: XML file may be incorrectly formatted, unable to read ");

        private String errorText;

        private CommonError(String error) {
            this.errorText = error;
        }

        public String toString() {
            return this.errorText;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PluginInstallStatus {
        INSTALLED("Currently Installed"),
        AVAILABLE("Available for Install");

        private String typeText;

        private PluginInstallStatus(String type) {
            this.typeText = type;
        }

        public String toString() {
            return this.typeText;
        }
    }
}

