/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.dialogs.preferences;

import cytoscape.Cytoscape;
import cytoscape.bookmarks.Bookmarks;
import cytoscape.bookmarks.DataSource;
import cytoscape.logger.CyLogger;
import cytoscape.util.BookmarksUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.xml.bind.JAXBException;

public class BookmarkDialog
extends JDialog
implements ActionListener,
ListSelectionListener,
ItemListener {
    private String bookmarkCategory;
    private Bookmarks theBookmarks = null;
    private String[] bookmarkCategories = new String[]{"network", "annotation", "plugins"};
    private JButton btnAddBookmark;
    private JButton btnDeleteBookmark;
    private JButton btnEditBookmark;
    private JButton btnOK;
    private JComboBox cmbCategory;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JList listBookmark;

    public BookmarkDialog(JFrame pParent) throws JAXBException, IOException {
        super((Frame)pParent, true);
        this.setTitle("Bookmark manager");
        this.initComponents();
        this.bookmarkCategory = this.cmbCategory.getSelectedItem().toString();
        this.theBookmarks = Cytoscape.getBookmarks();
        this.loadBookmarks();
        this.setSize(new Dimension(500, 250));
        this.setLocationRelativeTo(pParent);
    }

    public BookmarkDialog(JFrame pParent, String pCategoryName) throws JAXBException, IOException {
        this(pParent);
        Dimension winSize = this.getSize();
        for (int i = 0; i < this.cmbCategory.getItemCount(); ++i) {
            if (!this.cmbCategory.getItemAt(i).toString().equalsIgnoreCase(pCategoryName)) continue;
            this.cmbCategory.setSelectedIndex(i);
            this.setPreferredSize(winSize);
            this.pack();
            break;
        }
    }

    private void initComponents() {
        this.cmbCategory = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.listBookmark = new JList();
        this.jPanel1 = new JPanel();
        this.btnAddBookmark = new JButton();
        this.btnEditBookmark = new JButton();
        this.btnDeleteBookmark = new JButton();
        this.btnOK = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.cmbCategory.setToolTipText("Bookmark category");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        this.getContentPane().add((Component)this.cmbCategory, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.listBookmark);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.btnAddBookmark.setText("Add");
        this.btnAddBookmark.setToolTipText("Add a new bookmark");
        this.jPanel1.add((Component)this.btnAddBookmark, new GridBagConstraints());
        this.btnEditBookmark.setText("Edit");
        this.btnEditBookmark.setToolTipText("Edit a bookmark");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.jPanel1.add((Component)this.btnEditBookmark, gridBagConstraints);
        this.btnDeleteBookmark.setText("Delete");
        this.btnDeleteBookmark.setToolTipText("Delete a bookmark");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        this.jPanel1.add((Component)this.btnDeleteBookmark, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.btnOK.setText("OK");
        this.btnOK.setToolTipText("Close Bookmark dialog");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(20, 0, 20, 0);
        this.getContentPane().add((Component)this.btnOK, gridBagConstraints);
        for (String AnItem : this.bookmarkCategories) {
            this.cmbCategory.addItem(AnItem);
        }
        this.cmbCategory.addItemListener(this);
        this.btnEditBookmark.setEnabled(false);
        this.btnDeleteBookmark.setEnabled(false);
        this.btnOK.addActionListener(this);
        this.btnAddBookmark.addActionListener(this);
        this.btnEditBookmark.addActionListener(this);
        this.btnDeleteBookmark.addActionListener(this);
        this.listBookmark.addListSelectionListener(this);
        this.listBookmark.setCellRenderer(new MyListCellRenderer());
        this.listBookmark.setSelectionMode(0);
    }

    private void loadBookmarks() {
        List<DataSource> theDataSourceList = BookmarksUtil.getDataSourceList(this.bookmarkCategory, this.theBookmarks.getCategory());
        MyListModel theModel = new MyListModel(theDataSourceList);
        this.listBookmark.setModel(theModel);
    }

    public void itemStateChanged(ItemEvent e) {
        this.bookmarkCategory = this.cmbCategory.getSelectedItem().toString();
        this.loadBookmarks();
    }

    public void actionPerformed(ActionEvent e) {
        Object _actionObject = e.getSource();
        if (_actionObject instanceof JButton) {
            JButton _btn = (JButton)_actionObject;
            if (_btn == this.btnOK) {
                this.dispose();
            } else if (_btn == this.btnAddBookmark) {
                EditBookmarkDialog theNewDialog = new EditBookmarkDialog(this, true, this.theBookmarks, this.bookmarkCategory, "new", null);
                theNewDialog.setSize(300, 250);
                theNewDialog.setLocationRelativeTo(this);
                theNewDialog.setVisible(true);
                this.loadBookmarks();
            } else if (_btn == this.btnEditBookmark) {
                DataSource theDataSource = (DataSource)this.listBookmark.getSelectedValue();
                EditBookmarkDialog theEditDialog = new EditBookmarkDialog(this, true, this.theBookmarks, this.bookmarkCategory, "edit", theDataSource);
                theEditDialog.setSize(300, 250);
                theEditDialog.setLocationRelativeTo(this);
                theEditDialog.setVisible(true);
                this.loadBookmarks();
            } else if (_btn == this.btnDeleteBookmark) {
                DataSource theDataSource = (DataSource)this.listBookmark.getSelectedValue();
                MyListModel theModel = (MyListModel)this.listBookmark.getModel();
                theModel.removeElement(this.listBookmark.getSelectedIndex());
                BookmarksUtil.deleteBookmark(this.theBookmarks, this.bookmarkCategory, theDataSource);
                if (theModel.getSize() == 0) {
                    this.btnEditBookmark.setEnabled(false);
                    this.btnDeleteBookmark.setEnabled(false);
                }
            }
        }
    }

    public void valueChanged(ListSelectionEvent pListSelectionEvent) {
        if (this.listBookmark.getSelectedIndex() == -1) {
            this.btnEditBookmark.setEnabled(false);
            this.btnDeleteBookmark.setEnabled(false);
        } else {
            this.btnEditBookmark.setEnabled(true);
            this.btnDeleteBookmark.setEnabled(true);
        }
    }

    public static void main(String[] args) {
        BookmarkDialog theDialog = new BookmarkDialog();
        theDialog.setPreferredSize(new Dimension(350, 400));
        theDialog.pack();
        theDialog.setVisible(true);
    }

    public BookmarkDialog() {
        this.setTitle("Bookmark manager");
        this.theBookmarks = this.getTestBookmarks();
        this.initComponents();
        this.bookmarkCategory = this.cmbCategory.getSelectedItem().toString();
        this.loadBookmarks();
    }

    private Bookmarks getTestBookmarks() {
        Bookmarks tmpBookmarks = null;
        File tmpBookmarkFile = new File("bookmarks_kei.xml");
        CyLogger.getLogger().info("tmpBookmarkFile =" + tmpBookmarkFile.getAbsolutePath());
        try {
            tmpBookmarks = BookmarksUtil.getBookmarks(tmpBookmarkFile.toURL());
        }
        catch (IOException e) {
            CyLogger.getLogger().info("IOException -- bookmarkSource");
        }
        catch (JAXBException e) {
            CyLogger.getLogger().info("JAXBException -- bookmarkSource");
        }
        catch (Exception e) {
            CyLogger.getLogger().info("Can not read the bookmark file, the bookmark file may not exist!");
        }
        return tmpBookmarks;
    }

    public class EditBookmarkDialog
    extends JDialog
    implements ActionListener {
        private String name;
        private String URLstr;
        private JDialog parent;
        private Bookmarks theBookmarks;
        private String categoryName;
        private URL bookmarkURL;
        private String mode;
        private DataSource dataSource;
        private JButton btnCancel;
        private JButton btnOK;
        private JPanel jPanel1;
        private JLabel lbCategory;
        private JLabel lbCategoryValue;
        private JLabel lbName;
        private JLabel lbURL;
        private JTextField tfName;
        private JTextField tfURL;

        public EditBookmarkDialog(JDialog parent, boolean modal, Bookmarks pBookmarks, String categoryName, String pMode, DataSource pDataSource) {
            super((Dialog)parent, modal);
            this.mode = "new";
            this.dataSource = null;
            this.parent = parent;
            this.theBookmarks = pBookmarks;
            this.categoryName = categoryName;
            this.mode = pMode;
            this.dataSource = pDataSource;
            this.initComponents();
            this.lbCategoryValue.setText(categoryName);
            if (pMode.equalsIgnoreCase("new")) {
                this.setTitle("Add new bookmark");
            }
            if (pMode.equalsIgnoreCase("edit")) {
                this.setTitle("Edit bookmark");
                this.tfName.setText(this.dataSource.getName());
                this.tfName.setEditable(false);
                this.tfURL.setText(this.dataSource.getHref());
            }
        }

        public void actionPerformed(ActionEvent e) {
            Object _actionObject = e.getSource();
            if (_actionObject instanceof JButton) {
                DataSource theDataSource;
                JButton _btn = (JButton)_actionObject;
                if (_btn == this.btnOK && this.mode.equalsIgnoreCase("new")) {
                    this.name = this.tfName.getText();
                    this.URLstr = this.tfURL.getText();
                    if (this.name.trim().equals("") || this.URLstr.trim().equals("")) {
                        String msg = "Please provide a name/URL!";
                        JOptionPane.showMessageDialog(this.parent, msg, "Warning", 1);
                        return;
                    }
                    theDataSource = new DataSource();
                    theDataSource.setName(this.name);
                    theDataSource.setHref(this.URLstr);
                    if (BookmarksUtil.isInBookmarks(this.bookmarkURL, this.categoryName, theDataSource)) {
                        String msg = "Bookmark already existed!";
                        JOptionPane.showMessageDialog(this.parent, msg, "Warning", 1);
                        return;
                    }
                    BookmarksUtil.saveBookmark(this.theBookmarks, this.categoryName, theDataSource);
                    this.dispose();
                }
                if (_btn == this.btnOK && this.mode.equalsIgnoreCase("edit")) {
                    this.name = this.tfName.getText();
                    this.URLstr = this.tfURL.getText();
                    if (this.URLstr.trim().equals("")) {
                        String msg = "URL is empty!";
                        JOptionPane.showMessageDialog(this.parent, msg, "Warning", 1);
                        return;
                    }
                    theDataSource = new DataSource();
                    theDataSource.setName(this.name);
                    theDataSource.setHref(this.URLstr);
                    BookmarksUtil.deleteBookmark(this.theBookmarks, BookmarkDialog.this.bookmarkCategory, theDataSource);
                    BookmarksUtil.saveBookmark(this.theBookmarks, this.categoryName, theDataSource);
                    this.dispose();
                } else if (_btn == this.btnCancel) {
                    this.dispose();
                }
            }
        }

        private void initComponents() {
            this.lbName = new JLabel();
            this.tfName = new JTextField();
            this.lbURL = new JLabel();
            this.tfURL = new JTextField();
            this.jPanel1 = new JPanel();
            this.btnOK = new JButton();
            this.btnCancel = new JButton();
            this.lbCategory = new JLabel();
            this.lbCategoryValue = new JLabel();
            this.getContentPane().setLayout(new GridBagLayout());
            this.setDefaultCloseOperation(2);
            this.lbName.setText("Name:");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(10, 10, 10, 10);
            this.getContentPane().add((Component)this.lbName, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(10, 10, 10, 10);
            this.getContentPane().add((Component)this.tfName, gridBagConstraints);
            this.lbURL.setText("URL:");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(10, 10, 10, 10);
            this.getContentPane().add((Component)this.lbURL, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(10, 10, 10, 10);
            this.getContentPane().add((Component)this.tfURL, gridBagConstraints);
            this.btnOK.setText("OK");
            this.btnOK.setPreferredSize(new Dimension(65, 23));
            this.jPanel1.add(this.btnOK);
            this.btnCancel.setText("Cancel");
            this.jPanel1.add(this.btnCancel);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets = new Insets(20, 20, 20, 20);
            this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
            this.lbCategory.setText("Category:");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(20, 10, 10, 0);
            this.getContentPane().add((Component)this.lbCategory, gridBagConstraints);
            this.lbCategoryValue.setText("network");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(20, 10, 10, 0);
            this.getContentPane().add((Component)this.lbCategoryValue, gridBagConstraints);
            this.btnOK.addActionListener(this);
            this.btnCancel.addActionListener(this);
            this.pack();
        }
    }

    class MyListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public MyListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            DataSource theDataSource = (DataSource)value;
            this.setText(theDataSource.getName());
            this.setToolTipText(theDataSource.getHref());
            this.setBackground(isSelected ? Color.red : Color.white);
            this.setForeground(isSelected ? Color.white : Color.black);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyListModel
    extends AbstractListModel {
        List<DataSource> theDataSourceList = new ArrayList<DataSource>(0);

        public MyListModel(List<DataSource> pDataSourceList) {
            this.theDataSourceList = pDataSourceList;
        }

        @Override
        public int getSize() {
            if (this.theDataSourceList == null) {
                return 0;
            }
            return this.theDataSourceList.size();
        }

        @Override
        public Object getElementAt(int i) {
            if (this.theDataSourceList == null) {
                return null;
            }
            return this.theDataSourceList.get(i);
        }

        public void addElement(DataSource pDataSource) {
            this.theDataSourceList.add(pDataSource);
        }

        public void removeElement(int pIndex) {
            this.theDataSourceList.remove(pIndex);
            this.fireContentsChanged(this, pIndex, pIndex);
        }
    }
}

