/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.layout.ui;

import cytoscape.Cytoscape;
import cytoscape.layout.CyLayoutAlgorithm;
import cytoscape.layout.CyLayouts;
import cytoscape.layout.LayoutProperties;
import cytoscape.layout.LayoutTask;
import cytoscape.layout.ui.LayoutMenuManager;
import cytoscape.task.Task;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.task.util.TaskManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class LayoutSettingsDialog
extends JDialog
implements ActionListener {
    private CyLayoutAlgorithm currentLayout = null;
    private static Object defaultLayout = null;
    private JLabel titleLabel;
    private JPanel mainPanel;
    private JPanel buttonBox;
    private JComboBox algorithmSelector;
    private JPanel algorithmPanel;

    public LayoutSettingsDialog() {
        super(Cytoscape.getDesktop(), "Layout Settings", false);
        this.initializeOnce();
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("done")) {
            this.updateAllSettings();
            this.setVisible(false);
        } else if (command.equals("save")) {
            this.updateAllSettings();
            this.saveAllProperties();
        } else if (command.equals("execute")) {
            this.updateAllSettings();
            TaskManager.executeTask((Task)new LayoutTask(this.currentLayout, Cytoscape.getCurrentNetworkView()), (JTaskConfig)LayoutTask.getDefaultTaskConfig());
        } else if (command.equals("cancel")) {
            this.revertAllSettings();
            this.setVisible(false);
        } else {
            this.initialize();
            this.pack();
            this.setLocationRelativeTo(Cytoscape.getDesktop());
            this.setVisible(true);
        }
    }

    private void initializeOnce() {
        this.setDefaultCloseOperation(1);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 3));
        JPanel algorithmSelectorPanel = new JPanel();
        this.algorithmSelector = new JComboBox();
        algorithmSelectorPanel.add(this.algorithmSelector);
        Border selBorder = BorderFactory.createEtchedBorder(1);
        TitledBorder titleBorder = BorderFactory.createTitledBorder(selBorder, "Layout Algorithm");
        titleBorder.setTitlePosition(1);
        titleBorder.setTitlePosition(2);
        algorithmSelectorPanel.setBorder(titleBorder);
        this.mainPanel.add(algorithmSelectorPanel);
        this.algorithmPanel = new JPanel();
        this.mainPanel.add(this.algorithmPanel);
        this.buttonBox = new JPanel();
        JButton doneButton = new JButton("Done");
        doneButton.setActionCommand("done");
        doneButton.addActionListener(this);
        JButton saveButton = new JButton("Save Settings");
        saveButton.setActionCommand("save");
        saveButton.addActionListener(this);
        JButton executeButton = new JButton("Execute Layout");
        executeButton.setActionCommand("execute");
        executeButton.addActionListener(this);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setActionCommand("cancel");
        cancelButton.addActionListener(this);
        this.buttonBox.add(executeButton);
        this.buttonBox.add(saveButton);
        this.buttonBox.add(cancelButton);
        this.buttonBox.add(doneButton);
        this.buttonBox.setBorder(BorderFactory.createEtchedBorder(1));
        this.mainPanel.add(this.buttonBox);
        this.setContentPane(this.mainPanel);
    }

    private void initialize() {
        this.algorithmSelector.removeAllItems();
        this.algorithmSelector.setRenderer(new MyItemRenderer());
        this.algorithmSelector.addItem("Select algorithm to view settings");
        Set<String> menus = LayoutMenuManager.getLayoutMenuNames();
        for (String menu : menus) {
            if (menus.size() > 1) {
                this.algorithmSelector.addItem(menu);
            }
            for (CyLayoutAlgorithm algo : LayoutMenuManager.getLayoutsInMenu(menu)) {
                if (algo.getSettingsPanel() == null) continue;
                this.algorithmSelector.addItem(algo);
            }
        }
        this.algorithmSelector.addItemListener(new AlgorithmItemListener());
        if (defaultLayout != null) {
            this.algorithmSelector.setSelectedItem(defaultLayout);
        }
    }

    private void updateAllSettings() {
        for (CyLayoutAlgorithm algo : CyLayouts.getAllLayouts()) {
            algo.updateSettings();
        }
    }

    private void saveAllProperties() {
        for (CyLayoutAlgorithm algo : CyLayouts.getAllLayouts()) {
            LayoutProperties props = algo.getSettings();
            if (props == null) continue;
            props.saveProperties();
        }
    }

    private void revertAllSettings() {
        for (CyLayoutAlgorithm algo : CyLayouts.getAllLayouts()) {
            algo.revertSettings();
        }
    }

    private class MyItemRenderer
    extends JLabel
    implements ListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Font f = this.getFont();
            if (value.getClass() == String.class) {
                this.setFont(f.deriveFont(0));
                this.setText((String)value);
                this.setHorizontalAlignment(0);
                this.setForeground(Color.GRAY);
                this.setEnabled(false);
            } else {
                this.setForeground(list.getForeground());
                this.setHorizontalAlignment(2);
                this.setEnabled(true);
                if (isSelected) {
                    this.setFont(f.deriveFont(1));
                } else {
                    this.setFont(f.deriveFont(0));
                }
                this.setText(value.toString());
            }
            return this;
        }
    }

    private class AlgorithmItemListener
    implements ItemListener,
    ComponentListener {
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                LayoutSettingsDialog.this.algorithmPanel.removeAll();
                if (e.getItem().getClass() == String.class) {
                    LayoutSettingsDialog.this.currentLayout = null;
                    defaultLayout = null;
                    LayoutSettingsDialog.this.algorithmPanel.setBorder(null);
                } else {
                    CyLayoutAlgorithm newLayout = (CyLayoutAlgorithm)e.getItem();
                    defaultLayout = newLayout;
                    JPanel panel = newLayout.getSettingsPanel();
                    LayoutSettingsDialog.this.algorithmPanel.removeAll();
                    LayoutSettingsDialog.this.algorithmPanel.add(panel);
                    panel.addComponentListener(this);
                    Border selBorder = BorderFactory.createEtchedBorder(1);
                    TitledBorder titleBorder = BorderFactory.createTitledBorder(selBorder, newLayout.toString() + " Settings");
                    titleBorder.setTitlePosition(1);
                    titleBorder.setTitlePosition(2);
                    LayoutSettingsDialog.this.algorithmPanel.setBorder(titleBorder);
                    LayoutSettingsDialog.this.currentLayout = newLayout;
                }
                LayoutSettingsDialog.this.validate();
                LayoutSettingsDialog.this.pack();
            }
        }

        public void componentHidden(ComponentEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
            LayoutSettingsDialog.this.validate();
            LayoutSettingsDialog.this.doLayout();
            LayoutSettingsDialog.this.pack();
        }

        public void componentShown(ComponentEvent e) {
        }
    }
}

