/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.view.CyNetworkView;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public abstract class CytoscapeAction
extends AbstractAction
implements MenuListener {
    protected String preferredMenu = null;
    protected String preferredButtonGroup = null;
    protected Integer menuIndex = new Integer(-1);
    protected boolean acceleratorSet = false;
    protected int keyModifiers;
    protected int keyCode;
    protected String consoleName;
    private static List actionList = new LinkedList();
    protected boolean useCheckBoxMenuItem = false;

    public CytoscapeAction() {
        this.initialize();
    }

    public CytoscapeAction(String name) {
        super(name);
        this.consoleName = name;
        this.consoleName = this.consoleName.replaceAll(":. '", "");
        actionList.add(this);
        this.initialize();
    }

    public CytoscapeAction(String name, Icon icon) {
        super(name, icon);
        this.consoleName = name;
        this.consoleName = this.consoleName.replaceAll(" ", "");
        actionList.add(this);
        this.initialize();
    }

    public static List getActionList() {
        return actionList;
    }

    public void setName(String name) {
        this.consoleName = name;
    }

    public String getName() {
        return this.consoleName;
    }

    public String actionHelp() {
        return "";
    }

    public String[] completions() {
        return new String[0];
    }

    public void takeArgs(String[] argv) {
    }

    public abstract void actionPerformed(ActionEvent var1);

    protected void initialize() {
    }

    public Object clone() {
        return this;
    }

    public boolean isInMenuBar() {
        return true;
    }

    public boolean isInToolBar() {
        return false;
    }

    public void setPreferredIndex(int index) {
        this.menuIndex = new Integer(index);
    }

    public Integer getPrefferedIndex() {
        return this.menuIndex;
    }

    public void setAcceleratorCombo(int key_code, int key_mods) {
        this.acceleratorSet = true;
        this.keyCode = key_code;
        this.keyModifiers = key_mods;
    }

    public boolean isAccelerated() {
        return this.acceleratorSet;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public int getKeyModifiers() {
        return this.keyModifiers;
    }

    public String getPreferredMenu() {
        return this.preferredMenu;
    }

    public void setPreferredMenu(String new_preferred) {
        if (this.preferredMenu == new_preferred || this.preferredMenu != null && this.preferredMenu.equals(new_preferred)) {
            return;
        }
        String old_preferred = this.preferredMenu;
        this.preferredMenu = new_preferred;
        this.firePropertyChange("preferredMenu", old_preferred, new_preferred);
    }

    public String getPreferredButtonGroup() {
        return this.preferredButtonGroup;
    }

    public void setPreferredButtonGroup(String new_preferred) {
        if (this.preferredButtonGroup.equals(new_preferred)) {
            return;
        }
        String old_preferred = this.preferredButtonGroup;
        this.preferredButtonGroup = new_preferred;
        this.firePropertyChange("preferredButtonGroup", old_preferred, new_preferred);
    }

    boolean useCheckBoxMenuItem() {
        return this.useCheckBoxMenuItem;
    }

    public void menuCanceled(MenuEvent e) {
    }

    public void menuDeselected(MenuEvent e) {
    }

    public void menuSelected(MenuEvent e) {
    }

    protected void enableForNetwork() {
        CyNetwork n = Cytoscape.getCurrentNetwork();
        if (n == null || n == Cytoscape.getNullNetwork()) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    protected void enableForNetworkAndView() {
        CyNetwork n = Cytoscape.getCurrentNetwork();
        if (n == null || n == Cytoscape.getNullNetwork()) {
            this.setEnabled(false);
            return;
        }
        CyNetworkView v = Cytoscape.getCurrentNetworkView();
        if (v == null || v == Cytoscape.getNullNetworkView()) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }
}

