/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.CytoscapeInit;
import cytoscape.logger.CyLogger;
import java.io.IOException;
import java.util.Properties;

public abstract class OpenBrowser {
    static String UNIX_PATH = "htmlview";
    static String MAC_PATH = "open";
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";

    public static void openURL(String url) {
        Properties prop = CytoscapeInit.getProperties();
        String defBrowser = prop.getProperty("defaultWebBrowser");
        String osName = System.getProperty("os.name");
        try {
            String cmd = osName.startsWith("Windows") ? "rundll32 url.dll,FileProtocolHandler " + url : (osName.startsWith("Mac") ? MAC_PATH + " " + url : (defBrowser != null && !defBrowser.equals("") ? defBrowser + " " + url : UNIX_PATH + " " + url));
            CyLogger.getLogger().info("Opening URL by command \"" + cmd + "\"");
            Process p = Runtime.getRuntime().exec(cmd);
            try {
                int exitCode = p.waitFor();
                if (exitCode != 0) {
                    CyLogger.getLogger().warn("cmd failed, start new browser");
                    cmd = UNIX_PATH + " " + url;
                    p = Runtime.getRuntime().exec(cmd);
                }
            }
            catch (InterruptedException ex) {
                CyLogger.getLogger().warn("failed to launch browser", ex);
            }
        }
        catch (IOException ioe) {
            CyLogger.getLogger().warn("failed to launch browser", ioe);
        }
    }
}

