/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util.swing;

import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.util.swing.CheckBoxJList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.layout.GroupLayout;

public abstract class AttributeImportPanel
extends JPanel
implements PropertyChangeListener {
    public static final String CLOSE_EVENT = "CLOSE";
    private static final String DEF_TITLE = "Attribute Import Utility";
    private static final String DATASOURCE = "Data Source";
    private static final String KEY_ATTR = "Key Attribute";
    private static final String ATTR_PANEL_TITLE = "Available Annotations";
    protected String panelTitle;
    protected Icon logo;
    protected String attributePanelTitle;
    protected JComboBox attributeComboBox;
    protected JLabel attributeLabel;
    protected JPanel attributePanel;
    protected JComboBox attributeTypeComboBox;
    protected JLabel attributeTypeLabel;
    protected JButton cancelButton;
    protected JComboBox databaseComboBox;
    protected JPanel databasePanel;
    protected JPanel attrListPanel;
    protected JPanel availableAttrPanel;
    protected JScrollPane availableAttrScrollPane;
    protected JButton importButton;
    protected JLabel titleLabel;
    protected JButton resetButton;
    protected CheckBoxJList attrList;
    protected DefaultListModel model;

    protected AttributeImportPanel() {
        this(null, DEF_TITLE, ATTR_PANEL_TITLE);
    }

    protected AttributeImportPanel(Icon logo, String title, String attrPanelTitle) {
        this.logo = logo;
        this.panelTitle = title;
        this.attributePanelTitle = attrPanelTitle;
        this.initComponents();
        this.setAttributes();
        Cytoscape.getPropertyChangeSupport().addPropertyChangeListener(this);
    }

    protected void initComponents() {
        this.attrList = new CheckBoxJList();
        this.model = new DefaultListModel();
        this.attrList.setModel(this.model);
        this.titleLabel = new JLabel();
        this.databasePanel = new JPanel();
        this.databaseComboBox = new JComboBox();
        this.attributePanel = new JPanel();
        this.attributeLabel = new JLabel();
        this.attributeComboBox = new JComboBox();
        this.attributeTypeLabel = new JLabel();
        this.attributeTypeComboBox = new JComboBox();
        this.availableAttrPanel = new JPanel();
        this.availableAttrScrollPane = new JScrollPane();
        this.attrListPanel = new JPanel();
        this.importButton = new JButton();
        this.cancelButton = new JButton();
        this.resetButton = new JButton();
        this.setBackground(new Color(255, 255, 255));
        this.titleLabel.setBackground(new Color(255, 255, 255));
        this.titleLabel.setIcon(this.logo);
        this.titleLabel.setText(this.panelTitle);
        this.databasePanel.setBackground(new Color(255, 255, 255));
        this.databasePanel.setBorder(BorderFactory.createTitledBorder(DATASOURCE));
        this.attributeComboBox.setBackground(Color.white);
        this.databaseComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttributeImportPanel.this.databaseComboBoxActionPerformed(evt);
            }
        });
        this.databaseComboBox.setBackground(Color.white);
        GroupLayout databasePanelLayout = new GroupLayout((Container)this.databasePanel);
        this.databasePanel.setLayout((LayoutManager)databasePanelLayout);
        databasePanelLayout.setHorizontalGroup((GroupLayout.Group)databasePanelLayout.createParallelGroup(1).add((GroupLayout.Group)databasePanelLayout.createSequentialGroup().addContainerGap().add((Component)this.databaseComboBox, 0, 350, Short.MAX_VALUE).addContainerGap()));
        databasePanelLayout.setVerticalGroup((GroupLayout.Group)databasePanelLayout.createParallelGroup(1).add((GroupLayout.Group)databasePanelLayout.createSequentialGroup().add((Component)this.databaseComboBox, -2, -1, -2).addContainerGap(14, Short.MAX_VALUE)));
        this.attributePanel.setBackground(new Color(255, 255, 255));
        this.attributePanel.setBorder(BorderFactory.createTitledBorder(KEY_ATTR));
        this.attributeLabel.setText("Attribute:");
        this.attributeTypeLabel.setText("Data Type:");
        this.attributeTypeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttributeImportPanel.this.attributeTypeComboBoxActionPerformed(evt);
            }
        });
        this.attributeTypeComboBox.setBackground(Color.white);
        GroupLayout attributePanelLayout = new GroupLayout((Container)this.attributePanel);
        this.attributePanel.setLayout((LayoutManager)attributePanelLayout);
        attributePanelLayout.setHorizontalGroup((GroupLayout.Group)attributePanelLayout.createParallelGroup(1).add((GroupLayout.Group)attributePanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)attributePanelLayout.createParallelGroup(1).add((Component)this.attributeLabel).add((Component)this.attributeTypeLabel)).addPreferredGap(0).add((GroupLayout.Group)attributePanelLayout.createParallelGroup(1).add((Component)this.attributeTypeComboBox, 0, 350, Short.MAX_VALUE).add((Component)this.attributeComboBox, 0, 350, Short.MAX_VALUE)).addContainerGap()));
        attributePanelLayout.setVerticalGroup((GroupLayout.Group)attributePanelLayout.createParallelGroup(1).add((GroupLayout.Group)attributePanelLayout.createSequentialGroup().add((GroupLayout.Group)attributePanelLayout.createParallelGroup(3).add((Component)this.attributeLabel).add((Component)this.attributeComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)attributePanelLayout.createParallelGroup(3).add((Component)this.attributeTypeLabel).add((Component)this.attributeTypeComboBox, -2, -1, -2)).addContainerGap(13, Short.MAX_VALUE)));
        this.availableAttrPanel.setBackground(new Color(255, 255, 255));
        this.availableAttrPanel.setBorder(BorderFactory.createTitledBorder(this.attributePanelTitle));
        this.availableAttrScrollPane.setHorizontalScrollBarPolicy(31);
        this.availableAttrScrollPane.setViewportView(this.attrList);
        GroupLayout availableAttrPanelLayout = new GroupLayout((Container)this.availableAttrPanel);
        this.availableAttrPanel.setLayout((LayoutManager)availableAttrPanelLayout);
        availableAttrPanelLayout.setHorizontalGroup((GroupLayout.Group)availableAttrPanelLayout.createParallelGroup(1).add((GroupLayout.Group)availableAttrPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.availableAttrScrollPane, -1, 350, Short.MAX_VALUE).addContainerGap()));
        availableAttrPanelLayout.setVerticalGroup((GroupLayout.Group)availableAttrPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)availableAttrPanelLayout.createSequentialGroup().add((Component)this.availableAttrScrollPane, -1, 362, Short.MAX_VALUE).addContainerGap()));
        this.importButton.setText("Import");
        this.importButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttributeImportPanel.this.importButtonActionPerformed(evt);
            }
        });
        this.importButton.setBackground(Color.white);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttributeImportPanel.this.cancelButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setBackground(Color.white);
        this.resetButton.setText("Reset");
        this.resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AttributeImportPanel.this.resetButtonActionPerformed(evt);
            }
        });
        this.resetButton.setBackground(Color.white);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.availableAttrPanel, -1, -1, Short.MAX_VALUE).add(1, (Component)this.attributePanel, -1, -1, Short.MAX_VALUE).add(1, (Component)this.databasePanel, -1, -1, Short.MAX_VALUE).add(1, (Component)this.titleLabel).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.resetButton).addPreferredGap(0, 343, Short.MAX_VALUE).add((Component)this.cancelButton).addPreferredGap(0).add((Component)this.importButton))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.titleLabel).addPreferredGap(0).add((Component)this.databasePanel, -2, -1, -2).addPreferredGap(0).add((Component)this.attributePanel, -2, -1, -2).addPreferredGap(0).add((Component)this.availableAttrPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.importButton).add((Component)this.cancelButton).add((Component)this.resetButton)).addContainerGap()));
    }

    protected void resetButtonActionPerformed(ActionEvent evt) {
    }

    protected void importButtonActionPerformed(ActionEvent evt) {
        this.importAttributes();
    }

    protected void cancelButtonActionPerformed(ActionEvent evt) {
        this.firePropertyChange(CLOSE_EVENT, null, null);
    }

    private void attributeTypeComboBoxActionPerformed(ActionEvent evt) {
    }

    protected abstract void databaseComboBoxActionPerformed(ActionEvent var1);

    protected abstract void importAttributes();

    protected void setAttributes() {
        CyAttributes nodeAttr = Cytoscape.getNodeAttributes();
        String[] names = nodeAttr.getAttributeNames();
        this.attributeComboBox.removeAllItems();
        this.attributeComboBox.addItem("ID");
        for (String name : names) {
            if (!nodeAttr.getUserVisible(name)) continue;
            this.attributeComboBox.addItem(name);
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals(Cytoscape.ATTRIBUTES_CHANGED)) {
            this.setAttributes();
        }
    }
}

