/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.view;

import cytoscape.data.SelectEvent;
import cytoscape.data.SelectEventListener;
import cytoscape.data.SelectFilter;
import giny.model.Edge;
import giny.model.Node;
import giny.model.RootGraph;
import giny.view.EdgeView;
import giny.view.GraphView;
import giny.view.GraphViewChangeEvent;
import giny.view.GraphViewChangeListener;
import giny.view.NodeView;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class FlagAndSelectionHandler
implements SelectEventListener,
GraphViewChangeListener {
    private SelectFilter selectFilter;
    private GraphView view;

    public FlagAndSelectionHandler(SelectFilter selectFilter, GraphView view) {
        this.selectFilter = selectFilter;
        this.view = view;
        this.syncFilterAndView();
        selectFilter.addSelectEventListener(this);
        view.addGraphViewChangeListener((GraphViewChangeListener)this);
    }

    private void syncFilterAndView() {
        Set flaggedNodes = this.selectFilter.getSelectedNodes();
        Set flaggedEdges = this.selectFilter.getSelectedEdges();
        List selectedNodes = this.view.getSelectedNodes();
        List selectedEdges = this.view.getSelectedEdges();
        for (Node node : flaggedNodes) {
            NodeView nv = this.view.getNodeView(node);
            if (nv == null || nv.isSelected()) continue;
            nv.setSelected(true);
        }
        for (Edge edge : flaggedEdges) {
            EdgeView ev = this.view.getEdgeView(edge);
            if (ev == null || ev.isSelected()) continue;
            ev.setSelected(true);
        }
        for (NodeView nv : selectedNodes) {
            Node node = nv.getNode();
            this.selectFilter.setSelected(node, true);
        }
        for (EdgeView ev : selectedEdges) {
            Edge edge = ev.getEdge();
            this.selectFilter.setSelected(edge, true);
        }
    }

    public void graphViewChanged(GraphViewChangeEvent event) {
        GraphView source = (GraphView)event.getSource();
        RootGraph rootGraph = source.getGraphPerspective().getRootGraph();
        if (event.isNodesSelectedType()) {
            int[] objIndecies = event.getSelectedNodeIndices();
            ArrayList<Node> selList = new ArrayList<Node>();
            for (int index = 0; index < objIndecies.length; ++index) {
                selList.add(rootGraph.getNode(objIndecies[index]));
            }
            this.selectFilter.setSelectedNodes(selList, true);
        } else if (event.isNodesUnselectedType() || event.isNodesHiddenType()) {
            int[] objIndecies = event.isNodesUnselectedType() ? event.getUnselectedNodeIndices() : event.getHiddenNodeIndices();
            ArrayList<Node> unselList = new ArrayList<Node>();
            for (int index = 0; index < objIndecies.length; ++index) {
                unselList.add(rootGraph.getNode(objIndecies[index]));
            }
            this.selectFilter.setSelectedNodes(unselList, false);
        } else if (event.isEdgesSelectedType()) {
            int[] objIndecies = event.getSelectedEdgeIndices();
            ArrayList<Edge> selList = new ArrayList<Edge>();
            for (int index = 0; index < objIndecies.length; ++index) {
                selList.add(rootGraph.getEdge(objIndecies[index]));
            }
            this.selectFilter.setSelectedEdges(selList, true);
        } else if (event.isEdgesUnselectedType() || event.isEdgesHiddenType()) {
            int[] objIndecies = event.isEdgesUnselectedType() ? event.getUnselectedEdgeIndices() : event.getHiddenEdgeIndices();
            ArrayList<Edge> unselList = new ArrayList<Edge>();
            for (int index = 0; index < objIndecies.length; ++index) {
                unselList.add(rootGraph.getEdge(objIndecies[index]));
            }
            this.selectFilter.setSelectedEdges(unselList, false);
        }
    }

    public void onSelectEvent(SelectEvent event) {
        if (event.getTargetType() == 0) {
            this.setNodeSelected((Node)event.getTarget(), event.getEventType());
        } else if (event.getTargetType() == 1) {
            this.setEdgeSelected((Edge)event.getTarget(), event.getEventType());
        } else if (event.getTargetType() == 2) {
            Set nodeSet = (Set)event.getTarget();
            for (Node node : nodeSet) {
                this.setNodeSelected(node, event.getEventType());
            }
        } else if (event.getTargetType() == 3) {
            Set edgeSet = (Set)event.getTarget();
            for (Edge edge : edgeSet) {
                this.setEdgeSelected(edge, event.getEventType());
            }
        } else {
            return;
        }
    }

    private void setNodeSelected(Node node, boolean selectOn) {
        NodeView nodeView = this.view.getNodeView(node);
        if (nodeView == null) {
            return;
        }
        if (nodeView.isSelected() != selectOn) {
            nodeView.setSelected(selectOn);
        }
    }

    private void setEdgeSelected(Edge edge, boolean selectOn) {
        EdgeView edgeView = this.view.getEdgeView(edge);
        if (edgeView == null) {
            return;
        }
        if (edgeView.isSelected() != selectOn) {
            edgeView.setSelected(selectOn);
        }
    }
}

