/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.view;

import cytoscape.Cytoscape;
import cytoscape.data.SelectFilter;
import cytoscape.giny.CytoscapeRootGraph;
import cytoscape.view.FlagAndSelectionHandler;
import ding.view.DGraphView;
import giny.model.Edge;
import giny.model.GraphPerspective;
import giny.model.Node;
import giny.view.EdgeView;
import giny.view.GraphView;
import giny.view.NodeView;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class FlagAndSelectionHandlerTest
extends TestCase {
    SelectFilter filter;
    Node node1;
    Node node2;
    Edge edge1;
    Edge edge2;
    GraphPerspective gp;
    GraphView view;
    NodeView nodeView1;
    NodeView nodeView2;
    EdgeView edgeView1;
    EdgeView edgeView2;
    FlagAndSelectionHandler handler;

    public FlagAndSelectionHandlerTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        int i;
        CytoscapeRootGraph rootGraph = Cytoscape.getRootGraph();
        this.node1 = rootGraph.getNode(rootGraph.createNode());
        this.node2 = rootGraph.getNode(rootGraph.createNode());
        this.edge1 = rootGraph.getEdge(rootGraph.createEdge(this.node1, this.node2));
        this.edge2 = rootGraph.getEdge(rootGraph.createEdge(this.node2, this.node1));
        Node[] nodeArray = new Node[]{this.node1, this.node2};
        Edge[] edgeArray = new Edge[]{this.edge1, this.edge2};
        this.gp = rootGraph.createGraphPerspective(nodeArray, edgeArray);
        this.filter = new SelectFilter(this.gp);
        this.view = new DGraphView(this.gp);
        for (i = 0; i < nodeArray.length; ++i) {
            this.view.addNodeView(nodeArray[i].getRootGraphIndex());
        }
        for (i = 0; i < edgeArray.length; ++i) {
            this.view.addEdgeView(edgeArray[i].getRootGraphIndex());
        }
        this.nodeView1 = this.view.getNodeView(this.node1);
        this.nodeView2 = this.view.getNodeView(this.node2);
        this.edgeView1 = this.view.getEdgeView(this.edge1);
        this.edgeView2 = this.view.getEdgeView(this.edge2);
        this.filter.setSelected(this.node1, true);
        this.edgeView2.setSelected(true);
        this.handler = new FlagAndSelectionHandler(this.filter, this.view);
        FlagAndSelectionHandlerTest.assertTrue((boolean)this.filter.isSelected(this.edge2));
        FlagAndSelectionHandlerTest.assertTrue((boolean)this.nodeView1.isSelected());
        this.filter.unselectAllNodes();
        this.filter.unselectAllEdges();
    }

    public void tearDown() throws Exception {
    }

    public void testFilterToView() throws Exception {
        this.checkState(false, false, false, false);
        this.filter.setSelected(this.node1, true);
        this.checkState(true, false, false, false);
        this.filter.setSelected(this.edge2, true);
        this.checkState(true, false, false, true);
        this.filter.selectAllNodes();
        this.checkState(true, true, false, true);
        this.filter.selectAllEdges();
        this.checkState(true, true, true, true);
        this.filter.setSelected(this.node2, false);
        this.checkState(true, false, true, true);
        this.filter.setSelected(this.edge1, false);
        this.checkState(true, false, false, true);
        this.filter.unselectAllEdges();
        this.checkState(true, false, false, false);
        this.filter.unselectAllNodes();
        this.checkState(false, false, false, false);
    }

    public void testViewToFilter() throws Exception {
        this.checkState(false, false, false, false);
        this.nodeView1.setSelected(true);
        this.checkState(true, false, false, false);
        this.edgeView2.setSelected(true);
        this.checkState(true, false, false, true);
        this.nodeView2.setSelected(true);
        this.checkState(true, true, false, true);
        this.edgeView1.setSelected(true);
        this.checkState(true, true, true, true);
        this.nodeView2.setSelected(false);
        this.checkState(true, false, true, true);
        this.edgeView1.setSelected(false);
        this.checkState(true, false, false, true);
        this.edgeView2.setSelected(false);
        this.checkState(true, false, false, false);
        this.nodeView1.setSelected(false);
        this.checkState(false, false, false, false);
    }

    public void checkState(boolean n1, boolean n2, boolean e1, boolean e2) {
        FlagAndSelectionHandlerTest.assertTrue((this.filter.isSelected(this.node1) == n1 ? 1 : 0) != 0);
        FlagAndSelectionHandlerTest.assertTrue((this.filter.isSelected(this.node2) == n2 ? 1 : 0) != 0);
        FlagAndSelectionHandlerTest.assertTrue((this.filter.isSelected(this.edge1) == e1 ? 1 : 0) != 0);
        FlagAndSelectionHandlerTest.assertTrue((this.filter.isSelected(this.edge2) == e2 ? 1 : 0) != 0);
        FlagAndSelectionHandlerTest.assertTrue((this.nodeView1.isSelected() == n1 ? 1 : 0) != 0);
        FlagAndSelectionHandlerTest.assertTrue((this.nodeView2.isSelected() == n2 ? 1 : 0) != 0);
        FlagAndSelectionHandlerTest.assertTrue((this.edgeView1.isSelected() == e1 ? 1 : 0) != 0);
        FlagAndSelectionHandlerTest.assertTrue((this.edgeView2.isSelected() == e2 ? 1 : 0) != 0);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(FlagAndSelectionHandlerTest.class));
    }
}

