/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.visual.ArrowShape;
import java.awt.Color;
import java.io.Serializable;

public class Arrow
implements Serializable {
    private static final Color DEFAULT_ARROW_COLOR = Color.BLACK;
    public static final Arrow NONE = new Arrow(ArrowShape.NONE, DEFAULT_ARROW_COLOR);
    public static final Arrow DIAMOND = new Arrow(ArrowShape.DIAMOND, DEFAULT_ARROW_COLOR);
    public static final Arrow DELTA = new Arrow(ArrowShape.DELTA, DEFAULT_ARROW_COLOR);
    public static final Arrow ARROW = new Arrow(ArrowShape.ARROW, DEFAULT_ARROW_COLOR);
    public static final Arrow T = new Arrow(ArrowShape.T, DEFAULT_ARROW_COLOR);
    public static final Arrow CIRCLE = new Arrow(ArrowShape.CIRCLE, DEFAULT_ARROW_COLOR);
    @Deprecated
    public static final Arrow COLOR_DIAMOND = DIAMOND;
    @Deprecated
    public static final Arrow COLOR_DELTA = DELTA;
    @Deprecated
    public static final Arrow COLOR_ARROW = ARROW;
    @Deprecated
    public static final Arrow COLOR_T = T;
    @Deprecated
    public static final Arrow COLOR_CIRCLE = CIRCLE;
    @Deprecated
    public static final Arrow BLACK_DIAMOND = new Arrow(ArrowShape.DIAMOND, Color.BLACK);
    @Deprecated
    public static final Arrow WHITE_DIAMOND = new Arrow(ArrowShape.DIAMOND, Color.WHITE);
    @Deprecated
    public static final Arrow BLACK_DELTA = new Arrow(ArrowShape.DELTA, Color.BLACK);
    @Deprecated
    public static final Arrow WHITE_DELTA = new Arrow(ArrowShape.DELTA, Color.WHITE);
    @Deprecated
    public static final Arrow BLACK_ARROW = new Arrow(ArrowShape.ARROW, Color.BLACK);
    @Deprecated
    public static final Arrow WHITE_ARROW = new Arrow(ArrowShape.ARROW, Color.WHITE);
    @Deprecated
    public static final Arrow BLACK_T = new Arrow(ArrowShape.T, Color.BLACK);
    @Deprecated
    public static final Arrow WHITE_T = new Arrow(ArrowShape.T, Color.WHITE);
    @Deprecated
    public static final Arrow BLACK_CIRCLE = new Arrow(ArrowShape.CIRCLE, Color.BLACK);
    @Deprecated
    public static final Arrow WHITE_CIRCLE = new Arrow(ArrowShape.CIRCLE, Color.WHITE);
    private Color arrowColor;
    private ArrowShape shape;
    private int size;
    @Deprecated
    private String name;

    public Arrow(ArrowShape shape, Color arrowColor) {
        this.shape = shape;
        this.arrowColor = arrowColor;
    }

    @Deprecated
    public Arrow(String name) {
        this.name = name;
        this.arrowColor = DEFAULT_ARROW_COLOR;
        this.shape = ArrowShape.parseArrowText(name);
    }

    @Deprecated
    public int getGinyArrow() {
        if (this.name == null) {
            return this.shape.getGinyArrow();
        }
        if (this.name.equals("WHITE_DIAMOND")) {
            return 7;
        }
        if (this.name.equals("BLACK_DIAMOND")) {
            return 8;
        }
        if (this.name.equals("COLOR_DIAMOND")) {
            return 9;
        }
        if (this.name.equals("WHITE_DELTA")) {
            return 1;
        }
        if (this.name.equals("BLACK_DELTA")) {
            return 2;
        }
        if (this.name.equals("COLOR_DELTA")) {
            return 3;
        }
        if (this.name.equals("WHITE_ARROW")) {
            return 4;
        }
        if (this.name.equals("BLACK_ARROW")) {
            return 5;
        }
        if (this.name.equals("COLOR_ARROW")) {
            return 6;
        }
        if (this.name.equals("WHITE_T")) {
            return 13;
        }
        if (this.name.equals("BLACK_T")) {
            return 14;
        }
        if (this.name.equals("COLOR_T")) {
            return 15;
        }
        if (this.name.equals("WHITE_CIRCLE")) {
            return 10;
        }
        if (this.name.equals("BLACK_CIRCLE")) {
            return 11;
        }
        if (this.name.equals("COLOR_CIRCLE")) {
            return 12;
        }
        return 0;
    }

    public ArrowShape getShape() {
        return this.shape;
    }

    public void setShape(ArrowShape newShape) {
        this.shape = newShape;
    }

    public Color getColor() {
        return this.arrowColor;
    }

    public void setColor(Color newColor) {
        this.arrowColor = newColor;
    }

    @Deprecated
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.shape.getGinyName();
    }

    public static Arrow parseArrowText(String text) {
        String arrowtext = text.trim();
        if (arrowtext.equals("WHITE_DIAMOND")) {
            return new Arrow(ArrowShape.DIAMOND, Color.white);
        }
        if (arrowtext.equals("BLACK_DIAMOND")) {
            return DIAMOND;
        }
        if (arrowtext.equals("COLOR_DIAMOND")) {
            return DIAMOND;
        }
        if (arrowtext.equals("WHITE_DELTA")) {
            return new Arrow(ArrowShape.DELTA, Color.white);
        }
        if (arrowtext.equals("BLACK_DELTA")) {
            return DELTA;
        }
        if (arrowtext.equals("COLOR_DELTA")) {
            return DELTA;
        }
        if (arrowtext.equals("WHITE_ARROW")) {
            return new Arrow(ArrowShape.ARROW, Color.white);
        }
        if (arrowtext.equals("BLACK_ARROW")) {
            return ARROW;
        }
        if (arrowtext.equals("COLOR_ARROW")) {
            return ARROW;
        }
        if (arrowtext.equals("WHITE_T")) {
            return new Arrow(ArrowShape.T, Color.white);
        }
        if (arrowtext.equals("BLACK_T")) {
            return T;
        }
        if (arrowtext.equals("COLOR_T")) {
            return T;
        }
        if (arrowtext.equals("WHITE_CIRCLE")) {
            return new Arrow(ArrowShape.CIRCLE, Color.white);
        }
        if (arrowtext.equals("BLACK_CIRCLE")) {
            return CIRCLE;
        }
        if (arrowtext.equals("COLOR_CIRCLE")) {
            return CIRCLE;
        }
        return NONE;
    }
}

