/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.visual.DuplicateCalculatorNameException;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.calculators.BasicCalculator;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.mappings.ObjectMapping;
import cytoscape.visual.mappings.PassThroughMapping;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalculatorCatalog {
    private static final String label = "label";
    private Map<VisualPropertyType, Map<String, Calculator>> calculators;
    private Map<VisualPropertyType, List> listeners;
    private Map<String, VisualStyle> visualStyles;
    private Map<String, Class> mappers;
    protected transient ChangeEvent changeEvent;

    public CalculatorCatalog() {
        this.clear();
    }

    public CalculatorCatalog(Properties props) {
        this.clear();
    }

    public void clear() {
        this.calculators = new EnumMap<VisualPropertyType, Map<String, Calculator>>(VisualPropertyType.class);
        this.listeners = new EnumMap<VisualPropertyType, List>(VisualPropertyType.class);
        this.visualStyles = new HashMap<String, VisualStyle>();
        this.mappers = new HashMap<String, Class>();
    }

    @Deprecated
    protected List getListenerList(byte type) throws IllegalArgumentException {
        return this.getListenerList(VisualPropertyType.getVisualPorpertyType(type));
    }

    protected List getListenerList(VisualPropertyType type) throws IllegalArgumentException {
        ArrayList l = this.listeners.get((Object)type);
        if (l == null) {
            l = new ArrayList();
            this.listeners.put(type, l);
        }
        return l;
    }

    @Deprecated
    public void addChangeListener(ChangeListener l, byte type) throws IllegalArgumentException {
        this.addChangeListener(l, VisualPropertyType.getVisualPorpertyType(type));
    }

    public void addChangeListener(ChangeListener l, VisualPropertyType type) throws IllegalArgumentException {
        List theListeners = this.getListenerList(type);
        theListeners.add(l);
    }

    @Deprecated
    protected void fireStateChanged(byte type) throws IllegalArgumentException {
        this.fireStateChanged(VisualPropertyType.getVisualPorpertyType(type));
    }

    protected void fireStateChanged(VisualPropertyType type) throws IllegalArgumentException {
        List notifyEvents = this.getListenerList(type);
        for (int i = notifyEvents.size() - 1; i >= 0; --i) {
            ChangeListener listener = (ChangeListener)notifyEvents.get(i);
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            listener.stateChanged(this.changeEvent);
        }
    }

    @Deprecated
    protected Map<String, Calculator> getCalculatorMap(byte type) {
        return this.getCalculatorMap(VisualPropertyType.getVisualPorpertyType(type));
    }

    protected Map<String, Calculator> getCalculatorMap(VisualPropertyType type) {
        Map<String, Calculator> m = this.calculators.get((Object)type);
        if (m == null) {
            m = new HashMap<String, Calculator>();
            if (type == null) {
                return m;
            }
            this.calculators.put(type, m);
        }
        return m;
    }

    public void addCalculator(Calculator dupe) throws DuplicateCalculatorNameException, IllegalArgumentException {
        VisualPropertyType calcType = dupe.getVisualPropertyType();
        Map<String, Calculator> theMap = this.getCalculatorMap(calcType);
        this.addCalculator(dupe, theMap);
        this.fireStateChanged(calcType);
    }

    @Deprecated
    public String checkCalculatorName(String calcName, byte calcType) {
        return this.checkCalculatorName(calcName, VisualPropertyType.getVisualPorpertyType(calcType));
    }

    public String checkCalculatorName(String calcName, VisualPropertyType calcType) {
        Map<String, Calculator> theMap = this.getCalculatorMap(calcType);
        return this.checkName(calcName, theMap);
    }

    public void renameCalculator(Calculator c, String name) throws DuplicateCalculatorNameException, IllegalArgumentException {
        VisualPropertyType calcType = c.getVisualPropertyType();
        Map<String, Calculator> theMap = this.getCalculatorMap(calcType);
        String newName = this.checkName(name, theMap);
        if (!newName.equals(name)) {
            throw new DuplicateCalculatorNameException(newName);
        }
        theMap.remove(((Object)c).toString());
        c.setName(name);
        theMap.put(name, c);
        this.fireStateChanged(calcType);
    }

    public void removeCalculator(Calculator c) throws IllegalArgumentException {
        VisualPropertyType calcType = c.getVisualPropertyType();
        Map<String, Calculator> theMap = this.getCalculatorMap(calcType);
        theMap.remove(((Object)c).toString());
        this.fireStateChanged(calcType);
    }

    public Set getMappingNames() {
        return this.mappers.keySet();
    }

    public void addMapping(String name, Class m) throws DuplicateCalculatorNameException, IllegalArgumentException {
        if (!ObjectMapping.class.isAssignableFrom(m)) {
            throw new IllegalArgumentException("Class " + m.getName() + " is not an ObjectMapper!");
        }
        if (this.mappers.keySet().contains(name)) {
            throw new DuplicateCalculatorNameException("Duplicate mapper name " + name);
        }
        this.mappers.put(name, m);
    }

    public Class removeMapping(String name) {
        return this.mappers.remove(name);
    }

    public Class getMapping(String name) {
        return this.mappers.get(name);
    }

    public String checkMappingName(String name) {
        String newName = name;
        int nameApp = 2;
        while (this.mappers.keySet().contains(newName)) {
            newName = name + nameApp;
            ++nameApp;
        }
        return newName;
    }

    public Set<String> getVisualStyleNames() {
        return this.visualStyles.keySet();
    }

    public Collection<VisualStyle> getVisualStyles() {
        return this.visualStyles.values();
    }

    public void addVisualStyle(VisualStyle vs) {
        if (vs == null) {
            return;
        }
        String name = vs.toString();
        if (this.visualStyles.keySet().contains(name)) {
            String s = "Duplicate visual style name " + name;
            throw new DuplicateCalculatorNameException(s);
        }
        this.visualStyles.put(name, vs);
        this.addNodeAppearanceCalculator(vs.getNodeAppearanceCalculator());
        this.addEdgeAppearanceCalculator(vs.getEdgeAppearanceCalculator());
    }

    public VisualStyle removeVisualStyle(String name) {
        return this.visualStyles.remove(name);
    }

    public VisualStyle getVisualStyle(String name) {
        if (name != null && name.equals("default") && !this.visualStyles.containsKey(name)) {
            this.createDefaultVisualStyle();
        }
        return this.visualStyles.get(name);
    }

    public String checkVisualStyleName(String name) {
        return this.checkName(name, this.visualStyles);
    }

    private void addNodeAppearanceCalculator(NodeAppearanceCalculator c) {
        for (Calculator cc : c.getCalculators()) {
            Map<String, Calculator> m = this.getCalculatorMap(cc.getVisualPropertyType());
            if (m.values().contains(cc)) continue;
            m.put(((Object)cc).toString(), cc);
        }
    }

    private void addEdgeAppearanceCalculator(EdgeAppearanceCalculator c) {
        for (Calculator cc : c.getCalculators()) {
            Map<String, Calculator> m = this.getCalculatorMap(cc.getVisualPropertyType());
            if (m.values().contains(cc)) continue;
            m.put(((Object)cc).toString(), cc);
        }
    }

    protected void addCalculator(Calculator c, Map m) throws DuplicateCalculatorNameException {
        if (c == null) {
            return;
        }
        String name = ((Object)c).toString();
        if (m.keySet().contains(name)) {
            String s = "Duplicate calculator name " + name;
            throw new DuplicateCalculatorNameException(s);
        }
        m.put(name, c);
    }

    protected String checkName(String name, Map m) {
        if (name == null) {
            return null;
        }
        String newName = name;
        int nameApp = 2;
        while (m.keySet().contains(newName)) {
            newName = name + nameApp;
            ++nameApp;
        }
        return newName;
    }

    public Collection<Calculator> getCalculators() {
        ArrayList<Calculator> calcList = new ArrayList<Calculator>();
        for (VisualPropertyType type : this.calculators.keySet()) {
            for (String s : this.calculators.get((Object)type).keySet()) {
                calcList.add(this.calculators.get((Object)type).get(s));
            }
        }
        return calcList;
    }

    @Deprecated
    public Collection<Calculator> getCalculators(byte type) {
        return this.getCalculators(VisualPropertyType.getVisualPorpertyType(type));
    }

    public Collection<Calculator> getCalculators(VisualPropertyType type) {
        Map<String, Calculator> m = this.getCalculatorMap(type);
        return m.values();
    }

    @Deprecated
    public Calculator getCalculator(byte type, String name) {
        return this.getCalculator(VisualPropertyType.getVisualPorpertyType(type), name);
    }

    public Calculator getCalculator(VisualPropertyType type, String name) {
        Map<String, Calculator> m = this.getCalculatorMap(type);
        return m.get(name);
    }

    @Deprecated
    public String checkCalculatorName(byte type, String name) {
        return this.checkCalculatorName(VisualPropertyType.getVisualPorpertyType(type), name);
    }

    public String checkCalculatorName(VisualPropertyType type, String name) {
        return this.checkName(name, this.getCalculatorMap(type));
    }

    @Deprecated
    public Calculator removeCalculator(byte type, String name) {
        return this.removeCalculator(VisualPropertyType.getVisualPorpertyType(type), name);
    }

    public Calculator removeCalculator(VisualPropertyType type, String name) {
        Map<String, Calculator> m = this.getCalculatorMap(type);
        return m.remove(name);
    }

    public Collection<VisualPropertyType> getCalculatorTypes() {
        return this.calculators.keySet();
    }

    public void createDefaultVisualStyle() {
        VisualStyle defaultVS = new VisualStyle("default");
        Calculator nlc = this.getCalculator(VisualPropertyType.NODE_LABEL, label);
        if (nlc == null) {
            PassThroughMapping m = new PassThroughMapping((Object)"", "ID");
            nlc = new BasicCalculator(label, (ObjectMapping)m, VisualPropertyType.NODE_LABEL);
        }
        defaultVS.getNodeAppearanceCalculator().setCalculator(nlc);
        this.addVisualStyle(defaultVS);
    }
}

