/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.CyNetwork;
import cytoscape.visual.Appearance;
import cytoscape.visual.AppearanceCalculator;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.EdgeAppearance;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.calculators.BasicCalculator;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.mappings.ObjectMapping;
import giny.model.Edge;
import giny.model.GraphObject;
import java.util.Properties;

public class EdgeAppearanceCalculator
extends AppearanceCalculator {
    private EdgeAppearance defaultAppearance = new EdgeAppearance();

    public EdgeAppearanceCalculator() {
    }

    public EdgeAppearanceCalculator(EdgeAppearanceCalculator toCopy) {
        super(toCopy);
    }

    public EdgeAppearanceCalculator(String name, Properties eacProps, String baseKey, CalculatorCatalog catalog) {
        super(name, eacProps, baseKey, catalog, new EdgeAppearance());
        this.defaultAppearance = (EdgeAppearance)this.tmpDefaultAppearance;
    }

    public Object clone() {
        EdgeAppearanceCalculator copy = new EdgeAppearanceCalculator();
        EdgeAppearance defAppr = new EdgeAppearance();
        for (VisualPropertyType type : VisualPropertyType.getEdgeVisualPropertyList()) {
            defAppr.set(type, this.defaultAppearance.get(type));
        }
        copy.setDefaultAppearance(defAppr);
        for (Calculator cal : this.calcs) {
            ObjectMapping mCopy = (ObjectMapping)cal.getMapping(0).clone();
            BasicCalculator bCalc = new BasicCalculator(((Object)cal).toString(), mCopy, cal.getVisualPropertyType());
            copy.setCalculator(bCalc);
        }
        return copy;
    }

    public EdgeAppearance calculateEdgeAppearance(Edge edge, CyNetwork network) {
        EdgeAppearance appr = (EdgeAppearance)this.defaultAppearance.clone();
        this.calculateEdgeAppearance(appr, edge, network);
        return appr;
    }

    public void calculateEdgeAppearance(EdgeAppearance appr, Edge edge, CyNetwork network) {
        appr.copy(this.defaultAppearance);
        for (Calculator c : this.calcs) {
            c.apply((Appearance)appr, edge, network);
        }
        appr.applyBypass((GraphObject)edge);
    }

    public EdgeAppearance getDefaultAppearance() {
        return this.defaultAppearance;
    }

    public void setDefaultAppearance(EdgeAppearance appr) {
        this.defaultAppearance = appr;
    }

    public String getDescription() {
        return this.getDescription("EdgeAppearanceCalculator", this.defaultAppearance);
    }

    public void applyProperties(String name, Properties eacProps, String baseKey, CalculatorCatalog catalog) {
        this.applyProperties(this.defaultAppearance, name, eacProps, baseKey, catalog);
    }

    public Properties getProperties(String baseKey) {
        return this.getProperties(this.defaultAppearance, baseKey);
    }

    protected void copyDefaultAppearance(AppearanceCalculator toCopy) {
        this.defaultAppearance = (EdgeAppearance)((EdgeAppearanceCalculator)toCopy).getDefaultAppearance().clone();
    }
}

