/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.readers.CyAttributesReader;
import cytoscape.util.FileUtil;
import cytoscape.visual.Arrow;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.CalculatorIO;
import cytoscape.visual.EdgeAppearance;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.LineType;
import java.awt.Color;
import java.io.FileReader;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EdgeAppearanceCalculatorTest
extends TestCase {
    CyNetwork cyNet;
    CyNode a;
    CyNode b;
    CyEdge ab;
    CalculatorCatalog catalog;
    Properties props;

    public EdgeAppearanceCalculatorTest(String name) {
        super(name);
    }

    public void setUp() {
        this.cyNet = Cytoscape.createNetworkFromFile("testData/small.sif");
        this.a = Cytoscape.getCyNode("a");
        this.b = Cytoscape.getCyNode("b");
        this.ab = Cytoscape.getCyEdge(this.a, this.b, "interaction", "pp", false);
        this.props = new Properties();
        try {
            CyAttributesReader.loadAttributes(Cytoscape.getEdgeAttributes(), new FileReader("testData/small.edgeAttr"));
            this.props.load(FileUtil.getInputStream("testData/small.vizmap.props"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.catalog = new CalculatorCatalog();
        CalculatorIO.loadCalculators(this.props, this.catalog, true);
    }

    public void testDefaultAppearance() {
        EdgeAppearanceCalculator eac = new EdgeAppearanceCalculator();
        EdgeAppearance ea = eac.calculateEdgeAppearance(this.ab, this.cyNet);
        EdgeAppearanceCalculatorTest.assertTrue((String)"color", (boolean)ea.getColor().equals(Color.BLACK));
        EdgeAppearanceCalculatorTest.assertTrue((String)"lineType", (ea.getLineType() == LineType.LINE_1 ? 1 : 0) != 0);
        EdgeAppearanceCalculatorTest.assertTrue((String)"src arrow", (ea.getSourceArrow() == Arrow.NONE ? 1 : 0) != 0);
        EdgeAppearanceCalculatorTest.assertTrue((String)"trg arrow", (ea.getTargetArrow() == Arrow.NONE ? 1 : 0) != 0);
        EdgeAppearanceCalculatorTest.assertTrue((String)"label", (boolean)ea.getLabel().equals(""));
        EdgeAppearanceCalculatorTest.assertTrue((String)"tooltip", (boolean)ea.getToolTip().equals(""));
        EdgeAppearanceCalculatorTest.assertTrue((String)"font size", (ea.getFont().getSize() == 10 ? 1 : 0) != 0);
        EdgeAppearanceCalculatorTest.assertTrue((String)"font style", (ea.getFont().getStyle() == 0 ? 1 : 0) != 0);
    }

    public void testApplyProperties() {
        EdgeAppearanceCalculator eac = new EdgeAppearanceCalculator();
        eac.applyProperties("homer", this.props, "edgeAppearanceCalculator.homer", this.catalog);
        EdgeAppearance ea = eac.calculateEdgeAppearance(this.ab, this.cyNet);
        System.out.println(eac.getDescription());
        System.out.println("color " + ea.getColor());
        System.out.println("linetype " + ea.getLineType().toString());
        System.out.println("src arrow " + ea.getSourceArrow());
        System.out.println("trg arrow " + ea.getTargetArrow());
        System.out.println("label " + ea.getLabel());
        System.out.println("tooltip " + ea.getToolTip());
        System.out.println("font size " + ea.getFont().getSize());
        System.out.println("font style " + ea.getFont().getStyle());
        EdgeAppearanceCalculatorTest.assertTrue((String)("color " + ea.getColor()), (boolean)ea.getColor().equals(new Color(132, 116, 144)));
        EdgeAppearanceCalculatorTest.assertTrue((String)("trg arrow " + ea.getTargetArrow()), (ea.getTargetArrow() == Arrow.NONE ? 1 : 0) != 0);
        EdgeAppearanceCalculatorTest.assertTrue((String)("label " + ea.getLabel()), (boolean)ea.getLabel().equals("0.4"));
        EdgeAppearanceCalculatorTest.assertTrue((String)("tooltip " + ea.getToolTip()), (boolean)ea.getToolTip().equals(""));
        EdgeAppearanceCalculatorTest.assertTrue((String)("font size " + ea.getFont().getSize()), (ea.getFont().getSize() == 5 ? 1 : 0) != 0);
        EdgeAppearanceCalculatorTest.assertTrue((String)("font style " + ea.getFont().getStyle()), (ea.getFont().getStyle() == 0 ? 1 : 0) != 0);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(EdgeAppearanceCalculatorTest.class));
    }
}

