/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings;

import cytoscape.CyNetwork;
import cytoscape.visual.ShapeNodeRealizer;
import cytoscape.visual.SubjectBase;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.mappings.BoundaryRangeValues;
import cytoscape.visual.mappings.FlatInterpolator;
import cytoscape.visual.mappings.Interpolator;
import cytoscape.visual.mappings.LinearNumberToColorInterpolator;
import cytoscape.visual.mappings.LinearNumberToNumberInterpolator;
import cytoscape.visual.mappings.ObjectMapping;
import cytoscape.visual.mappings.continuous.ContinuousLegend;
import cytoscape.visual.mappings.continuous.ContinuousMappingPoint;
import cytoscape.visual.mappings.continuous.ContinuousMappingReader;
import cytoscape.visual.mappings.continuous.ContinuousMappingWriter;
import cytoscape.visual.mappings.continuous.ContinuousRangeCalculator;
import cytoscape.visual.mappings.continuous.ContinuousUI;
import cytoscape.visual.parsers.ValueParser;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContinuousMapping
extends SubjectBase
implements ObjectMapping {
    Object defaultObj;
    Class rangeClass;
    String attrName;
    Interpolator interpolator;
    private byte mapType;
    private ArrayList<ContinuousMappingPoint> points = new ArrayList();

    public ContinuousMapping(Object defaultObj, byte mapType) throws IllegalArgumentException {
        if (defaultObj instanceof Byte) {
            defaultObj = ShapeNodeRealizer.getNodeShape((Byte)defaultObj);
        }
        this.rangeClass = defaultObj.getClass();
        this.defaultObj = defaultObj;
        this.mapType = mapType;
        if (mapType != 0 && mapType != 1) {
            throw new IllegalArgumentException("Unknown mapping type " + mapType);
        }
        this.interpolator = Color.class.isAssignableFrom(this.rangeClass) ? new LinearNumberToColorInterpolator() : (Number.class.isAssignableFrom(this.rangeClass) ? new LinearNumberToNumberInterpolator() : new FlatInterpolator());
    }

    @Override
    public Object clone() {
        ContinuousMapping clone = new ContinuousMapping(this.defaultObj, this.mapType);
        clone.setControllingAttributeName(this.attrName, null, true);
        for (ChangeListener listener : this.observers) {
            clone.addChangeListener(listener);
        }
        for (ContinuousMappingPoint cmp : this.points) {
            ContinuousMappingPoint cmpClone = (ContinuousMappingPoint)cmp.clone();
            clone.addPoint(cmpClone.getValue(), cmpClone.getRange());
        }
        return clone;
    }

    public ArrayList<ContinuousMappingPoint> getAllPoints() {
        return this.points;
    }

    public void addPoint(double value, BoundaryRangeValues brv) {
        ContinuousMappingPoint cmp = new ContinuousMappingPoint(value, brv);
        this.points.add(cmp);
    }

    public void removePoint(int index) {
        this.points.remove(index);
    }

    public int getPointCount() {
        return this.points.size();
    }

    public ContinuousMappingPoint getPoint(int index) {
        return this.points.get(index);
    }

    @Override
    public void applyProperties(Properties props, String baseKey, ValueParser parser) {
        ContinuousMappingReader reader = new ContinuousMappingReader(props, baseKey, parser);
        this.points = reader.getPoints();
        this.attrName = reader.getControllingAttributeName();
        this.interpolator = reader.getInterpolator();
    }

    @Override
    public Properties getProperties(String baseKey) {
        ContinuousMappingWriter writer = new ContinuousMappingWriter(this.points, baseKey, this.attrName, this.interpolator);
        Properties newProps = writer.getProperties();
        return newProps;
    }

    @Override
    public Class getRangeClass() {
        return this.rangeClass;
    }

    @Override
    public Class[] getAcceptedDataClasses() {
        Class[] ret = new Class[]{Number.class};
        return ret;
    }

    @Override
    public String getControllingAttributeName() {
        return this.attrName;
    }

    @Override
    public void setControllingAttributeName(String attrName, CyNetwork network, boolean preserveMapping) {
        this.attrName = attrName;
    }

    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    public void setInterpolator(Interpolator interpolator) {
        this.interpolator = interpolator;
    }

    @Override
    public JPanel getUI(JDialog dialog, CyNetwork network) {
        ContinuousUI ui = new ContinuousUI(dialog, this.defaultObj, network, this);
        return ui;
    }

    @Override
    @Deprecated
    public JPanel getLegend(String visualAttr, byte b) {
        return this.getLegend(VisualPropertyType.getVisualPorpertyType(b));
    }

    @Override
    public JPanel getLegend(VisualPropertyType vpt) {
        return new ContinuousLegend(this.attrName, this.points, this.defaultObj, vpt);
    }

    @Override
    public Object calculateRangeValue(Map attrBundle) {
        ContinuousRangeCalculator calc = new ContinuousRangeCalculator(this.points, this.interpolator, attrBundle);
        Object object = calc.calculateRangeValue(this.attrName);
        return object;
    }
}

