/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings;

import cytoscape.CyNetwork;
import cytoscape.visual.NodeShape;
import cytoscape.visual.ShapeNodeRealizer;
import cytoscape.visual.SubjectBase;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.mappings.ObjectMapping;
import cytoscape.visual.mappings.discrete.DiscreteLegend;
import cytoscape.visual.mappings.discrete.DiscreteMappingReader;
import cytoscape.visual.mappings.discrete.DiscreteMappingWriter;
import cytoscape.visual.mappings.discrete.DiscreteRangeCalculator;
import cytoscape.visual.mappings.discrete.DiscreteUI;
import cytoscape.visual.parsers.ValueParser;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscreteMapping
extends SubjectBase
implements ObjectMapping {
    Object defaultObj;
    Class rangeClass;
    String attrName;
    protected byte mapType;
    private TreeMap treeMap = new TreeMap();
    private Object lastKey;

    public DiscreteMapping(Object defObj, byte mapType) {
        this(defObj, null, mapType);
    }

    public DiscreteMapping(Object defObj, String attrName, byte mapType) {
        if (defObj instanceof Byte) {
            defObj = ShapeNodeRealizer.getNodeShape((Byte)defObj);
        }
        this.defaultObj = defObj;
        this.rangeClass = defObj.getClass();
        if (mapType != 0 && mapType != 1) {
            throw new IllegalArgumentException("Unknown mapping type " + mapType);
        }
        this.mapType = mapType;
        if (attrName != null) {
            this.setControllingAttributeName(attrName, null, false);
        }
    }

    @Override
    public Object clone() {
        DiscreteMapping clone = new DiscreteMapping(this.defaultObj, this.attrName, this.mapType);
        for (ChangeListener listener : this.observers) {
            clone.addChangeListener(listener);
        }
        clone.putAll((TreeMap)this.treeMap.clone());
        return clone;
    }

    public Object getMapValue(Object key) {
        return this.treeMap.get(key);
    }

    public void putMapValue(Object key, Object value) {
        this.lastKey = key;
        if (value instanceof Byte) {
            value = ShapeNodeRealizer.getNodeShape((Byte)value);
        }
        this.treeMap.put(key, value);
        this.fireStateChanged();
    }

    public Object getLastKeyModified() {
        return this.lastKey;
    }

    public void putAll(Map<Object, Object> map) {
        this.treeMap.putAll(map);
    }

    public Map getAll() {
        return this.treeMap;
    }

    @Override
    public Class getRangeClass() {
        return this.rangeClass;
    }

    @Override
    public Class[] getAcceptedDataClasses() {
        Class[] ret = new Class[]{String.class, Number.class, Integer.class, Double.class, Float.class, Long.class, Short.class, NodeShape.class, List.class};
        return ret;
    }

    @Override
    public String getControllingAttributeName() {
        return this.attrName;
    }

    @Override
    public void setControllingAttributeName(String attrName, CyNetwork n, boolean preserveMapping) {
        this.attrName = attrName;
        if (!preserveMapping) {
            this.treeMap = new TreeMap();
        }
    }

    @Override
    public void applyProperties(Properties props, String baseKey, ValueParser parser) {
        DiscreteMappingReader reader = new DiscreteMappingReader(props, baseKey, parser);
        String contValue = reader.getControllingAttributeName();
        if (contValue != null) {
            this.setControllingAttributeName(contValue, null, false);
        }
        this.treeMap = reader.getMap();
    }

    @Override
    public Properties getProperties(String baseKey) {
        DiscreteMappingWriter writer = new DiscreteMappingWriter(this.attrName, baseKey, this.treeMap);
        return writer.getProperties();
    }

    @Override
    public Object calculateRangeValue(Map attrBundle) {
        DiscreteRangeCalculator calculator = new DiscreteRangeCalculator(this.treeMap, this.attrName);
        return calculator.calculateRangeValue(attrBundle);
    }

    @Override
    public JPanel getUI(JDialog parent, CyNetwork network) {
        DiscreteUI ui = new DiscreteUI(parent, network, this.attrName, this.defaultObj, this.mapType, this);
        return ui;
    }

    @Override
    @Deprecated
    public JPanel getLegend(String visualAttr, byte b) {
        return this.getLegend(VisualPropertyType.getVisualPorpertyType(b));
    }

    @Override
    public JPanel getLegend(VisualPropertyType vpt) {
        return new DiscreteLegend(this.treeMap, this.attrName, vpt);
    }
}

