/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.properties;

import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.parsers.ColorParser;
import cytoscape.visual.properties.AbstractVisualProperty;
import cytoscape.visual.ui.icon.LineTypeIcon;
import giny.view.EdgeView;
import java.awt.Color;
import java.awt.Paint;
import java.util.Properties;
import javax.swing.Icon;

public class EdgeColorProp
extends AbstractVisualProperty {
    public VisualPropertyType getType() {
        return VisualPropertyType.EDGE_COLOR;
    }

    public Icon getIcon(Object value) {
        LineTypeIcon icon = new LineTypeIcon();
        icon.setColor((Color)value);
        icon.setBottomPadding(-7);
        return icon;
    }

    public void applyToEdgeView(EdgeView ev, Object o) {
        if (o == null || ev == null) {
            return;
        }
        if (!((Color)o).equals(ev.getUnselectedPaint())) {
            ev.setUnselectedPaint((Paint)((Color)o));
        }
    }

    public Object parseProperty(Properties props, String baseKey) {
        String s = props.getProperty(VisualPropertyType.EDGE_COLOR.getDefaultPropertyKey(baseKey));
        if (s != null) {
            return new ColorParser().parseColor(s);
        }
        return null;
    }

    public Object getDefaultAppearanceObject() {
        return Color.black;
    }
}

