/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.properties;

import cytoscape.Cytoscape;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.parsers.ColorParser;
import cytoscape.visual.properties.AbstractVisualProperty;
import cytoscape.visual.ui.icon.LineTypeIcon;
import giny.view.EdgeView;
import giny.view.Label;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.util.Properties;
import javax.swing.Icon;

public class EdgeLabelColorProp
extends AbstractVisualProperty {
    public VisualPropertyType getType() {
        return VisualPropertyType.EDGE_LABEL_COLOR;
    }

    public Icon getIcon(Object value) {
        LineTypeIcon icon = new LineTypeIcon();
        icon.setColor(new Color(10, 10, 10, 0));
        icon.setText("Font");
        Color fontColor = (Color)value;
        Font defFont = (Font)VisualPropertyType.EDGE_FONT_FACE.getDefault(Cytoscape.getVisualMappingManager().getVisualStyle());
        icon.setTextFont(new Font(defFont.getFontName(), defFont.getStyle(), 24));
        icon.setBottomPadding(-7);
        icon.setTextColor(fontColor);
        return icon;
    }

    public void applyToEdgeView(EdgeView ev, Object o) {
        if (o == null || ev == null) {
            return;
        }
        Label edgelabel = ev.getLabel();
        if (!((Color)o).equals(edgelabel.getTextPaint())) {
            edgelabel.setTextPaint((Paint)((Color)o));
        }
    }

    public Object parseProperty(Properties props, String baseKey) {
        String s = props.getProperty(VisualPropertyType.EDGE_LABEL_COLOR.getDefaultPropertyKey(baseKey));
        if (s != null) {
            return new ColorParser().parseColor(s);
        }
        return null;
    }

    public Object getDefaultAppearanceObject() {
        return Color.black;
    }
}

