/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.properties;

import cytoscape.visual.LineStyle;
import cytoscape.visual.LineType;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.parsers.LineTypeParser;
import cytoscape.visual.properties.AbstractVisualProperty;
import cytoscape.visual.ui.icon.LineTypeIcon;
import giny.view.EdgeView;
import java.awt.Stroke;
import java.util.Map;
import java.util.Properties;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgeLineTypeProp
extends AbstractVisualProperty {
    @Override
    public VisualPropertyType getType() {
        return VisualPropertyType.EDGE_LINETYPE;
    }

    @Override
    public Icon getIcon(Object value) {
        LineTypeIcon icon = new LineTypeIcon((LineType)value);
        icon.setBottomPadding(-7);
        return icon;
    }

    @Override
    public Map<Object, Icon> getIconSet() {
        return LineStyle.getIconSet();
    }

    @Override
    public void applyToEdgeView(EdgeView ev, Object o) {
        if (o == null || ev == null) {
            return;
        }
        Stroke newLine = ((LineType)o).getStroke();
        if (!newLine.equals(ev.getStroke())) {
            ev.setStroke(newLine);
        }
    }

    @Override
    public Object parseProperty(Properties props, String baseKey) {
        String s = props.getProperty(VisualPropertyType.EDGE_LINETYPE.getDefaultPropertyKey(baseKey));
        if (s != null) {
            return new LineTypeParser().parseLineType(s);
        }
        return null;
    }

    @Override
    public Object getDefaultAppearanceObject() {
        return LineType.LINE_1;
    }
}

