/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.properties;

import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.parsers.FloatParser;
import cytoscape.visual.properties.AbstractVisualProperty;
import cytoscape.visual.ui.icon.LineTypeIcon;
import giny.view.EdgeView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Paint;
import java.util.Properties;
import javax.swing.Icon;

public class EdgeSourceArrowOpacityProp
extends AbstractVisualProperty {
    public VisualPropertyType getType() {
        return VisualPropertyType.EDGE_SRCARROW_OPACITY;
    }

    public Icon getIcon(final Object value) {
        LineTypeIcon icon = new LineTypeIcon(){

            public void paintIcon(Component c, Graphics g, int x, int y) {
                super.setColor(new Color(10, 10, 10, 0));
                super.paintIcon(c, g, x, y);
                this.g2d.setFont(new Font("SansSerif", 1, 24));
                this.g2d.setColor(Color.DARK_GRAY);
                this.g2d.drawString(value.toString(), c.getX() + 48, c.getHeight() / 2 + 7);
                this.g2d.setFont(new Font("SansSerif", 1, 12));
            }
        };
        return icon;
    }

    public void applyToEdgeView(EdgeView ev, Object o) {
        Integer newTp;
        if (o == null || ev == null) {
            return;
        }
        Color oldPaint = (Color)ev.getSourceEdgeEndPaint();
        Integer tp = oldPaint.getAlpha();
        if (tp != (newTp = Integer.valueOf(((Number)o).intValue()))) {
            ev.setSourceEdgeEndPaint((Paint)new Color(oldPaint.getRed(), oldPaint.getGreen(), oldPaint.getBlue(), newTp));
        }
    }

    public Object parseProperty(Properties props, String baseKey) {
        String s = props.getProperty(VisualPropertyType.EDGE_SRCARROW_OPACITY.getDefaultPropertyKey(baseKey));
        if (s != null) {
            return new FloatParser().parseFloat(s).intValue();
        }
        return null;
    }

    public Object getDefaultAppearanceObject() {
        return new Integer(255);
    }
}

