/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.properties;

import cytoscape.visual.LabelPosition;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.parsers.LabelPositionParser;
import cytoscape.visual.properties.AbstractVisualProperty;
import cytoscape.visual.ui.LabelPlacerGraphic;
import cytoscape.visual.ui.icon.NodeIcon;
import giny.view.Label;
import giny.view.NodeView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Properties;
import javax.swing.Icon;

public class NodeLabelPositionProp
extends AbstractVisualProperty {
    public VisualPropertyType getType() {
        return VisualPropertyType.NODE_LABEL_POSITION;
    }

    public Icon getIcon(Object value) {
        int size = 55;
        final BufferedImage bi = new BufferedImage(size, size, 1);
        Graphics2D g2 = bi.createGraphics();
        LabelPlacerGraphic lp = new LabelPlacerGraphic((LabelPosition)value, size, false);
        lp.paint(g2);
        NodeIcon icon = new NodeIcon(){

            public void paintIcon(Component c, Graphics g, int x, int y) {
                super.setColor(new Color(10, 10, 10, 0));
                super.paintIcon(c, g, x, y);
                this.g2d.drawImage((Image)bi, 10, -5, null);
            }
        };
        return icon;
    }

    public void applyToNodeView(NodeView nv, Object o) {
        if (o == null || nv == null) {
            return;
        }
        Label nodelabel = nv.getLabel();
        LabelPosition labelPosition = (LabelPosition)o;
        int newTextAnchor = labelPosition.getLabelAnchor();
        if (nodelabel.getTextAnchor() != newTextAnchor) {
            nodelabel.setTextAnchor(newTextAnchor);
        }
        int newJustify = labelPosition.getJustify();
        if (nodelabel.getJustify() != newJustify) {
            nodelabel.setJustify(newJustify);
        }
        int newNodeAnchor = labelPosition.getTargetAnchor();
        if (nv.getNodeLabelAnchor() != newNodeAnchor) {
            nv.setNodeLabelAnchor(newNodeAnchor);
        }
        double newOffsetX = labelPosition.getOffsetX();
        if (nv.getLabelOffsetX() != newOffsetX) {
            nv.setLabelOffsetX(newOffsetX);
        }
        double newOffsetY = labelPosition.getOffsetY();
        if (nv.getLabelOffsetY() != newOffsetY) {
            nv.setLabelOffsetY(newOffsetY);
        }
    }

    public Object parseProperty(Properties props, String baseKey) {
        String s = props.getProperty(VisualPropertyType.NODE_LABEL_POSITION.getDefaultPropertyKey(baseKey));
        if (s != null) {
            return new LabelPositionParser().parseLabelPosition(s);
        }
        return null;
    }

    public Object getDefaultAppearanceObject() {
        return new LabelPosition();
    }
}

