/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.visual.LabelPosition;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;

public class LabelPlacerGraphic
extends JPanel
implements PropertyChangeListener {
    private LabelPosition lp;
    private int default_xy = 500;
    private int xy;
    private int center;
    private float offsetRatio;
    private int nxy;
    private int[] npoints;
    private int lx;
    private int ly;
    private int[] lxpoints;
    private int[] lypoints;
    private int dot;
    private int xPos;
    private int yPos;
    private int bestLabelX = 1;
    private int bestLabelY = 1;
    private int bestNodeX = 1;
    private int bestNodeY = 1;
    private boolean beenDragged = false;
    private boolean canOffsetDrag = false;
    private int xClickOffset = 0;
    private int yClickOffset = 0;
    private int xOffset;
    private int yOffset;
    private int justify;
    private Color transparentRed = new Color(1.0f, 0.0f, 0.0f, 0.1f);
    private Color transparentBlue = new Color(0.0f, 0.0f, 1.0f, 0.1f);
    private Color transparentMagenta = new Color(0.0f, 0.0f, 1.0f, 0.05f);
    private boolean renderDetail;
    private String label = "LABEL";
    private String node = "NODE";
    private String click = "CLICK 'N DRAG";
    private int labelLen = 0;
    private int nodeLen = 0;
    private int clickLen = 0;
    private int ascent = 0;
    private int detailStrokeWidth = 3;
    private int lowStrokeWidth = 1;
    private Stroke detailStroke = new BasicStroke(this.detailStrokeWidth);
    private Stroke lowStroke = new BasicStroke(this.lowStrokeWidth);
    private double gravityDistance = 10.0;

    public LabelPlacerGraphic(LabelPosition pos) {
        this(pos, 500, true);
    }

    public LabelPlacerGraphic(LabelPosition pos, int size, boolean fullDetail) {
        this.lp = pos == null ? new LabelPosition(127, 127, 64, 0.0, 0.0) : pos;
        this.renderDetail = fullDetail;
        this.initSize(size);
        this.setPreferredSize(new Dimension(this.xy, this.xy));
        this.setBackground(Color.white);
        this.addMouseListener(new MouseClickHandler());
        this.addMouseMotionListener(new MouseDragHandler());
        this.applyPosition();
        this.repaint();
    }

    private void initSize(int size) {
        this.xy = size;
        this.center = this.xy / 2;
        this.offsetRatio = (float)this.xy / (float)this.default_xy;
        this.nxy = (int)(0.3 * (double)this.xy);
        int[] tnpoints = new int[]{this.center - this.nxy / 2, this.center, this.center + this.nxy / 2};
        this.npoints = tnpoints;
        this.lx = (int)(0.4 * (double)this.xy);
        this.ly = (int)(0.1 * (double)this.xy);
        int[] tlxpoints = new int[]{0, this.lx / 2, this.lx};
        int[] tlypoints = new int[]{0, this.ly / 2, this.ly};
        this.lxpoints = tlxpoints;
        this.lypoints = tlypoints;
        this.xPos = this.dot = (int)(0.02 * (double)this.xy);
        this.yPos = this.dot;
    }

    public void paint(Graphics gin) {
        Graphics2D g = (Graphics2D)gin;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.labelLen <= 0) {
            FontMetrics fm = g.getFontMetrics();
            this.labelLen = fm.stringWidth(this.label);
            this.nodeLen = fm.stringWidth(this.node);
            this.clickLen = fm.stringWidth(this.click);
            this.ascent = fm.getMaxAscent();
        }
        g.setColor(Color.white);
        g.fillRect(0, 0, this.xy, this.xy);
        int x = this.center - this.nxy / 2;
        int y = this.center - this.nxy / 2;
        g.setColor(this.transparentBlue);
        g.fillOval(x, y, this.nxy, this.nxy);
        if (this.renderDetail) {
            g.setStroke(this.detailStroke);
        } else {
            g.setStroke(this.lowStroke);
        }
        g.setColor(Color.blue);
        g.drawLine(x, y, x + this.nxy, y);
        g.drawLine(x + this.nxy, y, x + this.nxy, y + this.nxy);
        g.drawLine(x + this.nxy, y + this.nxy, x, y + this.nxy);
        g.drawLine(x, y + this.nxy, x, y);
        if (this.renderDetail) {
            g.drawString(this.node, this.center - this.nxy / 12, this.center - this.nxy / 6);
            g.setColor(Color.black);
            int gd = (int)(this.gravityDistance * 2.0 + (double)(this.dot / 2));
            for (int i = 0; i < this.npoints.length; ++i) {
                for (int j = 0; j < this.npoints.length; ++j) {
                    g.setColor(this.transparentMagenta);
                    g.fillOval(this.npoints[i] - gd / 2, this.npoints[j] - gd / 2, gd, gd);
                    if (i == this.bestNodeX && j == this.bestNodeY && !this.beenDragged) {
                        g.setColor(Color.yellow);
                    } else {
                        g.setColor(Color.black);
                    }
                    g.fillOval(this.npoints[i] - this.dot / 2, this.npoints[j] - this.dot / 2, this.dot, this.dot);
                }
            }
        }
        g.setColor(this.transparentRed);
        g.fillRect(this.xOffset + this.xPos, this.yOffset + this.yPos, this.lx, this.ly);
        g.setColor(Color.red);
        g.drawLine(this.xOffset + this.xPos, this.yOffset + this.yPos, this.xOffset + this.xPos + this.lx, this.yOffset + this.yPos);
        g.drawLine(this.xOffset + this.xPos + this.lx, this.yOffset + this.yPos, this.xOffset + this.xPos + this.lx, this.yOffset + this.yPos + this.ly);
        g.drawLine(this.xOffset + this.xPos + this.lx, this.yOffset + this.yPos + this.ly, this.xOffset + this.xPos, this.yOffset + this.yPos + this.ly);
        g.drawLine(this.xOffset + this.xPos, this.yOffset + this.yPos + this.ly, this.xOffset + this.xPos, this.yOffset + this.yPos);
        if (this.renderDetail) {
            int vspace = (this.ly - this.ascent - this.ascent) / 3;
            if (this.justify == 65) {
                g.drawString(this.label, this.xOffset + this.xPos + this.detailStrokeWidth, this.yOffset + this.yPos + vspace + this.ascent);
                g.drawString(this.click, this.xOffset + this.xPos + this.detailStrokeWidth, this.yOffset + this.yPos + 2 * (vspace + this.ascent));
            } else if (this.justify == 66) {
                g.drawString(this.label, this.xOffset + this.xPos + (this.lx - this.labelLen), this.yOffset + this.yPos + vspace + this.ascent);
                g.drawString(this.click, this.xOffset + this.xPos + (this.lx - this.clickLen), this.yOffset + this.yPos + 2 * (vspace + this.ascent));
            } else {
                g.drawString(this.label, this.xOffset + this.xPos + (this.lx - this.labelLen) / 2 - this.detailStrokeWidth, this.yOffset + this.yPos + vspace + this.ascent);
                g.drawString(this.click, this.xOffset + this.xPos + (this.lx - this.clickLen) / 2 - this.detailStrokeWidth, this.yOffset + this.yPos + 2 * (vspace + this.ascent));
            }
        } else {
            g.setColor(Color.gray);
            if (this.justify == 65) {
                g.drawLine(this.xOffset + this.xPos + this.lowStrokeWidth, this.yOffset + this.yPos + this.ly / 2, this.xOffset + this.xPos + this.lx / 3, this.yOffset + this.yPos + this.ly / 2);
            } else if (this.justify == 66) {
                g.drawLine(this.xOffset + this.xPos + 2 * this.lx / 3, this.yOffset + this.yPos + this.ly / 2, this.xOffset + this.xPos + this.lx, this.yOffset + this.yPos + this.ly / 2);
            } else {
                g.drawLine(this.xOffset + this.xPos + this.lx / 3, this.yOffset + this.yPos + this.ly / 2, this.xOffset + this.xPos + 2 * this.lx / 3 - this.lowStrokeWidth, this.yOffset + this.yPos + this.ly / 2);
            }
        }
        if (this.renderDetail) {
            g.setColor(Color.black);
            for (int i = 0; i < this.lxpoints.length; ++i) {
                for (int j = 0; j < this.lypoints.length; ++j) {
                    if (i == this.bestLabelX && j == this.bestLabelY && !this.beenDragged) {
                        g.setColor(Color.yellow);
                    }
                    g.fillOval(this.xPos + this.xOffset + this.lxpoints[i] - this.dot / 2, this.yPos + this.yOffset + this.lypoints[j] - this.dot / 2, this.dot, this.dot);
                    if (i != this.bestLabelX || j != this.bestLabelY) continue;
                    g.setColor(Color.black);
                }
            }
        }
    }

    private void findClosestPoint() {
    }

    private void applyPosition() {
        int labelAnchor;
        this.xOffset = (int)(this.lp.getOffsetX() * (double)this.offsetRatio);
        this.yOffset = (int)(this.lp.getOffsetY() * (double)this.offsetRatio);
        this.justify = this.lp.getJustify();
        int nodeAnchor = this.lp.getTargetAnchor();
        if (nodeAnchor != 127) {
            this.bestNodeX = nodeAnchor % 3;
            this.bestNodeY = nodeAnchor / 3;
        }
        if ((labelAnchor = this.lp.getLabelAnchor()) != 127) {
            this.bestLabelX = labelAnchor % 3;
            this.bestLabelY = labelAnchor / 3;
        }
        if (nodeAnchor != 127 || labelAnchor != 127) {
            this.xPos = this.npoints[this.bestNodeX] - this.lxpoints[this.bestLabelX];
            this.yPos = this.npoints[this.bestNodeY] - this.lypoints[this.bestLabelY];
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        String type = e.getPropertyName();
        if (type.equals("LABEL_POSITION_CHANGED")) {
            this.lp = (LabelPosition)e.getNewValue();
            this.applyPosition();
            this.repaint();
        }
    }

    private class MouseDragHandler
    extends MouseMotionAdapter {
        private MouseDragHandler() {
        }

        public void mouseDragged(MouseEvent e) {
            if (LabelPlacerGraphic.this.canOffsetDrag) {
                LabelPlacerGraphic.this.xPos = e.getX() - LabelPlacerGraphic.this.xClickOffset;
                LabelPlacerGraphic.this.yPos = e.getY() - LabelPlacerGraphic.this.yClickOffset;
                LabelPlacerGraphic.this.beenDragged = true;
                LabelPlacerGraphic.this.repaint();
            }
        }
    }

    private class MouseClickHandler
    extends MouseAdapter {
        private MouseClickHandler() {
        }

        public void mousePressed(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            if (x >= LabelPlacerGraphic.this.xPos + LabelPlacerGraphic.this.xOffset && x <= LabelPlacerGraphic.this.xPos + LabelPlacerGraphic.this.xOffset + LabelPlacerGraphic.this.lx && y >= LabelPlacerGraphic.this.yPos + LabelPlacerGraphic.this.yOffset && y <= LabelPlacerGraphic.this.yPos + LabelPlacerGraphic.this.yOffset + LabelPlacerGraphic.this.ly) {
                LabelPlacerGraphic.this.canOffsetDrag = true;
                LabelPlacerGraphic.this.xClickOffset = x - LabelPlacerGraphic.this.xPos;
                LabelPlacerGraphic.this.yClickOffset = y - LabelPlacerGraphic.this.yPos;
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (LabelPlacerGraphic.this.beenDragged) {
                int x = e.getX();
                int y = e.getY();
                LabelPlacerGraphic.this.xPos = x - LabelPlacerGraphic.this.xClickOffset + LabelPlacerGraphic.this.xOffset;
                LabelPlacerGraphic.this.yPos = y - LabelPlacerGraphic.this.yClickOffset + LabelPlacerGraphic.this.yOffset;
                double best = Double.POSITIVE_INFINITY;
                double offX = 0.0;
                double offY = 0.0;
                for (int i = 0; i < LabelPlacerGraphic.this.npoints.length; ++i) {
                    for (int j = 0; j < LabelPlacerGraphic.this.npoints.length; ++j) {
                        Point nodePoint = new Point(LabelPlacerGraphic.this.npoints[i] - LabelPlacerGraphic.this.dot / 2, LabelPlacerGraphic.this.npoints[j] - LabelPlacerGraphic.this.dot / 2);
                        for (int a = 0; a < LabelPlacerGraphic.this.lxpoints.length; ++a) {
                            for (int b = 0; b < LabelPlacerGraphic.this.lypoints.length; ++b) {
                                Point labelPoint = new Point(LabelPlacerGraphic.this.xPos + LabelPlacerGraphic.this.lxpoints[a] - LabelPlacerGraphic.this.dot / 2, LabelPlacerGraphic.this.yPos + LabelPlacerGraphic.this.lypoints[b] - LabelPlacerGraphic.this.dot / 2);
                                double dist = labelPoint.distance(nodePoint);
                                if (!(dist < best)) continue;
                                best = dist;
                                LabelPlacerGraphic.this.bestLabelX = a;
                                LabelPlacerGraphic.this.bestLabelY = b;
                                LabelPlacerGraphic.this.bestNodeX = i;
                                LabelPlacerGraphic.this.bestNodeY = j;
                                offX = labelPoint.getX() - nodePoint.getX();
                                offY = labelPoint.getY() - nodePoint.getY();
                            }
                        }
                    }
                }
                LabelPlacerGraphic.this.xPos = LabelPlacerGraphic.this.npoints[LabelPlacerGraphic.this.bestNodeX] - LabelPlacerGraphic.this.lxpoints[LabelPlacerGraphic.this.bestLabelX];
                LabelPlacerGraphic.this.yPos = LabelPlacerGraphic.this.npoints[LabelPlacerGraphic.this.bestNodeY] - LabelPlacerGraphic.this.lypoints[LabelPlacerGraphic.this.bestLabelY];
                if (Math.sqrt(offX * offX + offY * offY) > LabelPlacerGraphic.this.gravityDistance + (double)(LabelPlacerGraphic.this.dot / 2)) {
                    LabelPlacerGraphic.this.xOffset = (int)offX;
                    LabelPlacerGraphic.this.yOffset = (int)offY;
                } else {
                    LabelPlacerGraphic.this.xOffset = 0;
                    LabelPlacerGraphic.this.yOffset = 0;
                }
                LabelPlacerGraphic.this.lp.setOffsetX(LabelPlacerGraphic.this.xOffset);
                LabelPlacerGraphic.this.lp.setOffsetY(LabelPlacerGraphic.this.yOffset);
                LabelPlacerGraphic.this.lp.setLabelAnchor(LabelPlacerGraphic.this.bestLabelX + 3 * LabelPlacerGraphic.this.bestLabelY);
                LabelPlacerGraphic.this.lp.setTargetAnchor(LabelPlacerGraphic.this.bestNodeX + 3 * LabelPlacerGraphic.this.bestNodeY);
                LabelPlacerGraphic.this.firePropertyChange("LABEL_POSITION_CHANGED", null, LabelPlacerGraphic.this.lp);
                LabelPlacerGraphic.this.repaint();
                LabelPlacerGraphic.this.beenDragged = false;
                LabelPlacerGraphic.this.canOffsetDrag = false;
            }
        }
    }
}

