/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.Cytoscape;
import cytoscape.visual.LabelPosition;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.parsers.ObjectToString;
import cytoscape.visual.ui.BypassHack;
import cytoscape.visual.ui.LabelPlacerControl;
import cytoscape.visual.ui.LabelPlacerGraphic;
import giny.model.GraphObject;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class PopupLabelPositionChooser
extends JDialog
implements PropertyChangeListener {
    protected LabelPosition lp;
    protected LabelPosition newlp;

    public static LabelPosition showDialog(Dialog f, LabelPosition pos) {
        PopupLabelPositionChooser placer = new PopupLabelPositionChooser(f, true, pos);
        return placer.getLabelPosition();
    }

    public static LabelPosition showDialog(Frame f, LabelPosition pos) {
        PopupLabelPositionChooser placer = new PopupLabelPositionChooser(f, true, pos);
        return placer.getLabelPosition();
    }

    private PopupLabelPositionChooser(Frame f, boolean modal, LabelPosition pos) {
        super(f, modal);
        this.init(pos);
    }

    private PopupLabelPositionChooser(Dialog f, boolean modal, LabelPosition pos) {
        super(f, modal);
        this.init(pos);
    }

    private void init(LabelPosition pos) {
        this.lp = pos == null ? new LabelPosition(127, 127, 64, 0.0, 0.0) : pos;
        this.newlp = new LabelPosition(this.lp);
        this.setTitle("Select Label Placement");
        JPanel placer = new JPanel();
        placer.setLayout(new BoxLayout(placer, 1));
        placer.setOpaque(true);
        LabelPlacerGraphic graphic = new LabelPlacerGraphic(new LabelPosition(this.lp));
        LabelPlacerControl control = new LabelPlacerControl(new LabelPosition(this.lp));
        control.addPropertyChangeListener(graphic);
        control.addPropertyChangeListener(this);
        graphic.addPropertyChangeListener(control);
        graphic.addPropertyChangeListener(this);
        placer.add(graphic);
        placer.add(control);
        JPanel buttonPanel = new JPanel();
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupLabelPositionChooser.this.lp = PopupLabelPositionChooser.this.newlp;
                PopupLabelPositionChooser.this.dispose();
            }
        });
        ok.addActionListener(control);
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupLabelPositionChooser.this.dispose();
            }
        });
        buttonPanel.add(ok);
        buttonPanel.add(cancel);
        placer.add(buttonPanel);
        this.add(placer);
        this.pack();
        this.setVisible(true);
    }

    private LabelPosition getLabelPosition() {
        return this.lp;
    }

    public void propertyChange(PropertyChangeEvent e) {
        String type = e.getPropertyName();
        if (type.equals("LABEL_POSITION_CHANGED")) {
            this.newlp = (LabelPosition)e.getNewValue();
            GraphObject go = BypassHack.getCurrentObject();
            if (go != null) {
                String val = ObjectToString.getStringValue(this.newlp);
                Cytoscape.getNodeAttributes().setAttribute(go.getIdentifier(), VisualPropertyType.NODE_LABEL_POSITION.getBypassAttrName(), val);
                Cytoscape.getVisualMappingManager().getNetworkView().redrawGraph(false, true);
            }
        }
    }
}

