/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.Cytoscape;
import cytoscape.visual.NodeShape;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.ui.icon.VisualPropertyIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingx.JXTitledPanel;
import org.jdesktop.swingx.border.DropShadowBorder;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.painter.gradient.BasicGradientPainter;

public class ValueSelectDialog
extends JDialog {
    private final VisualPropertyType type;
    private Map shapeMap;
    private List orderedKeyList;
    private Object originalValue;
    private boolean canceled = false;
    private JButton applyButton;
    private JButton cancelButton;
    private JList iconList;
    private JScrollPane iconListScrollPane;
    private JXTitledPanel mainPanel;
    private DefaultListModel model;

    public static Object showDialog(VisualPropertyType type, JDialog parent) {
        ValueSelectDialog dialog = new ValueSelectDialog(type, parent, true);
        dialog.setVisible(true);
        return dialog.getValue();
    }

    private ValueSelectDialog(VisualPropertyType type, JDialog parent, boolean modal) {
        super((Frame)Cytoscape.getDesktop(), modal);
        this.type = type;
        this.shapeMap = this.type.getVisualProperty().getIconSet();
        this.initComponents();
        this.setList();
        this.originalValue = Cytoscape.getVisualMappingManager().getVisualStyle().getNodeAppearanceCalculator().getDefaultAppearance().get(type);
    }

    private void initComponents() {
        this.mainPanel = new JXTitledPanel();
        this.iconListScrollPane = new JScrollPane();
        this.iconList = new JList();
        this.applyButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Select New Value");
        this.mainPanel.setTitlePainter((Painter)new BasicGradientPainter((Point2D)new Point2D.Double(0.2, 0.0), new Color(Color.gray.getRed(), Color.gray.getGreen(), Color.gray.getBlue(), 100), (Point2D)new Point2D.Double(0.8, 0.0), Color.WHITE));
        this.mainPanel.setTitle(this.type.getName());
        this.mainPanel.setTitleFont(new Font("SansSerif", 1, 14));
        this.iconList.setSelectionMode(0);
        this.iconListScrollPane.setViewportView(this.iconList);
        this.applyButton.setText("Apply");
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValueSelectDialog.this.applyButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ValueSelectDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setVisible(true);
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel.getContentContainer());
        this.mainPanel.getContentContainer().setLayout((LayoutManager)mainPanelLayout);
        mainPanelLayout.setHorizontalGroup((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)mainPanelLayout.createSequentialGroup().addContainerGap(128, Short.MAX_VALUE).add((Component)this.cancelButton).addPreferredGap(0).add((Component)this.applyButton).addContainerGap()).add((Component)this.iconListScrollPane, -1, 291, Short.MAX_VALUE));
        mainPanelLayout.setVerticalGroup((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)mainPanelLayout.createSequentialGroup().add((Component)this.iconListScrollPane, -1, 312, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(3).add((Component)this.applyButton).add((Component)this.cancelButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.mainPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.mainPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
        this.canceled = true;
    }

    private void applyButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public Object getValue() {
        if (this.canceled) {
            return this.originalValue;
        }
        int selectedIndex = this.iconList.getSelectedIndex();
        if (0 <= selectedIndex && selectedIndex < this.orderedKeyList.size()) {
            return this.orderedKeyList.get(selectedIndex);
        }
        return this.originalValue;
    }

    private void setList() {
        ArrayList<Icon> icons = new ArrayList<Icon>();
        this.orderedKeyList = new ArrayList();
        this.model = new DefaultListModel();
        this.iconList.setModel(this.model);
        for (Object key : this.shapeMap.keySet()) {
            VisualPropertyIcon icon = (VisualPropertyIcon)this.shapeMap.get(key);
            if (this.type == VisualPropertyType.EDGE_SRCARROW_SHAPE || this.type == VisualPropertyType.EDGE_TGTARROW_SHAPE) {
                icon.setIconWidth(icon.getIconWidth() * 3);
            }
            if (this.type.equals((Object)VisualPropertyType.NODE_SHAPE) && !((NodeShape)((Object)key)).isSupported()) continue;
            icons.add(icon);
            this.orderedKeyList.add(key);
            this.model.addElement(icon.getName());
        }
        this.iconList.setCellRenderer(new IconCellRenderer(icons));
        this.iconList.repaint();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class IconCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private final Font SELECTED_FONT = new Font("SansSerif", 2, 18);
        private final Font NORMAL_FONT = new Font("SansSerif", 1, 14);
        private final Color SELECTED_COLOR = new Color(30, 30, 80, 25);
        private final Color SELECTED_FONT_COLOR = new Color(0, 150, 255, 120);
        private final List<Icon> icons;

        public IconCellRenderer(List<Icon> icons) {
            this.icons = icons;
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            VisualPropertyIcon icon = (VisualPropertyIcon)this.icons.get(index);
            this.setText(value.toString());
            icon.setLeftPadding(15);
            this.setIcon(icon);
            this.setFont(isSelected ? this.SELECTED_FONT : this.NORMAL_FONT);
            this.setVerticalTextPosition(0);
            this.setVerticalAlignment(0);
            this.setIconTextGap(35);
            this.setBackground(isSelected ? this.SELECTED_COLOR : list.getBackground());
            this.setForeground(isSelected ? this.SELECTED_FONT_COLOR : list.getForeground());
            this.setPreferredSize(new Dimension(icon.getIconWidth(), icon.getIconHeight() + 20));
            this.setBorder((Border)new DropShadowBorder());
            return this;
        }
    }
}

