/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui.editors.continuous;

import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.data.attr.CountedIterator;
import cytoscape.data.attr.MultiHashMap;
import cytoscape.logger.CyLogger;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.calculators.Calculator;
import cytoscape.visual.mappings.BoundaryRangeValues;
import cytoscape.visual.mappings.ContinuousMapping;
import cytoscape.visual.mappings.continuous.ContinuousMappingPoint;
import cytoscape.visual.ui.editors.continuous.BelowAndAbovePanel;
import cytoscape.visual.ui.editors.continuous.C2CMappingEditor;
import cytoscape.visual.ui.editors.continuous.C2DMappingEditor;
import cytoscape.visual.ui.editors.continuous.EditorValueRangeTracer;
import cytoscape.visual.ui.editors.continuous.GradientEditorPanel;
import cytoscape.visual.ui.editors.continuous.MinMaxDialog;
import cytoscape.visual.ui.editors.continuous.YValueLegendPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingx.JXMultiThumbSlider;
import org.jdesktop.swingx.multislider.Thumb;

public abstract class ContinuousMappingEditorPanel
extends JDialog
implements PropertyChangeListener {
    public static final String EDITOR_WINDOW_CLOSED = "EDITOR_WINDOW_CLOSED";
    public static final String EDITOR_WINDOW_OPENED = "EDITOR_WINDOW_OPENED";
    protected static final String BELOW_VALUE_CHANGED = "BELOW_VALUE_CHANGED";
    protected static final String ABOVE_VALUE_CHANGED = "ABOVE_VALUE_CHANGED";
    protected VisualPropertyType type;
    protected Calculator calculator;
    protected ContinuousMapping mapping;
    protected ArrayList<ContinuousMappingPoint> allPoints;
    private SpinnerNumberModel spinnerModel;
    protected Object below;
    protected Object above;
    protected static ContinuousMappingEditorPanel editor;
    protected double lastSpinnerNumber = 0.0;
    protected JButton addButton;
    private JLabel attrNameLabel;
    protected JButton colorButton;
    protected JButton deleteButton;
    protected JPanel iconPanel;
    private JLabel pivotLabel;
    private JPanel rangeEditorPanel;
    private JPanel rangeSettingPanel;
    protected JXMultiThumbSlider slider;
    protected JSpinner valueSpinner;
    private JLabel visualPropertyLabel;
    protected JXMultiThumbSlider rotaryEncoder;
    protected JButton minMaxButton;
    protected BelowAndAbovePanel abovePanel;
    protected BelowAndAbovePanel belowPanel;

    public ContinuousMappingEditorPanel(final VisualPropertyType type) {
        super(Cytoscape.getDesktop());
        this.type = type;
        this.initComponents();
        this.setVisualPropLabel();
        this.initRangeValues();
        this.setSpinner();
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                CyLogger.getLogger().info("windowOpened");
                ContinuousMappingEditorPanel.this.firePropertyChange(ContinuousMappingEditorPanel.EDITOR_WINDOW_OPENED, null, (Object)type);
            }

            public void windowClosing(WindowEvent e) {
                ContinuousMappingEditorPanel.this.firePropertyChange(ContinuousMappingEditorPanel.EDITOR_WINDOW_CLOSED, this, (Object)type);
            }
        });
    }

    public static ImageIcon getIcon(int width, int height, VisualPropertyType type) {
        Class dataType = type.getDataType();
        if (dataType == Color.class) {
            return GradientEditorPanel.getIcon(width, height, type);
        }
        if (dataType == Number.class) {
            return C2CMappingEditor.getIcon(width, height, type);
        }
        return C2DMappingEditor.getIcon(width, height, type);
    }

    protected void setSpinner() {
        this.spinnerModel = new SpinnerNumberModel(0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.01);
        this.spinnerModel.addChangeListener(new SpinnerChangeListener());
        this.valueSpinner.setModel(this.spinnerModel);
    }

    protected void setVisualPropLabel() {
        this.visualPropertyLabel.setText("Visual Property: " + this.type.getName());
    }

    private void initComponents() {
        JPanel mainPanel = new JPanel();
        this.abovePanel = new BelowAndAbovePanel(this.type, Color.yellow, false);
        this.abovePanel.setName("abovePanel");
        this.belowPanel = new BelowAndAbovePanel(this.type, Color.white, true);
        this.belowPanel.setName("belowPanel");
        this.abovePanel.setPreferredSize(new Dimension(16, 1));
        this.belowPanel.setPreferredSize(new Dimension(16, 1));
        this.rangeSettingPanel = new JPanel();
        this.pivotLabel = new JLabel();
        this.addButton = new JButton();
        this.deleteButton = new JButton();
        this.minMaxButton = new JButton();
        this.colorButton = new JButton();
        this.rangeEditorPanel = new JPanel();
        this.slider = new JXMultiThumbSlider();
        this.attrNameLabel = new JLabel();
        this.iconPanel = new YValueLegendPanel(this.type);
        this.visualPropertyLabel = new JLabel();
        this.valueSpinner = new JSpinner();
        this.valueSpinner.setEnabled(false);
        this.rotaryEncoder = new JXMultiThumbSlider();
        this.iconPanel.setPreferredSize(new Dimension(25, 1));
        mainPanel.setBorder(BorderFactory.createTitledBorder(null, "Continuous Mapping for " + this.type.getName(), 0, 0, new Font("SansSerif", 1, 12), new Color(0, 0, 0)));
        this.rangeSettingPanel.setBorder(BorderFactory.createTitledBorder(null, "Range Setting", 0, 0, new Font("SansSerif", 1, 10), new Color(0, 0, 0)));
        this.pivotLabel.setFont(new Font("SansSerif", 1, 12));
        this.pivotLabel.setForeground(Color.darkGray);
        this.pivotLabel.setText("Pivot:");
        this.addButton.setText("Add");
        this.addButton.setMargin(new Insets(2, 2, 2, 2));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ContinuousMappingEditorPanel.this.addButtonActionPerformed(evt);
            }
        });
        this.deleteButton.setText("Delete");
        this.deleteButton.setMargin(new Insets(2, 2, 2, 2));
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ContinuousMappingEditorPanel.this.deleteButtonActionPerformed(evt);
            }
        });
        this.minMaxButton.setText("Min/Max");
        this.minMaxButton.setMargin(new Insets(2, 2, 2, 2));
        this.minMaxButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ContinuousMappingEditorPanel.this.minMaxButtonActionPerformed(evt);
            }
        });
        this.rangeEditorPanel.setBorder(BorderFactory.createTitledBorder(null, "Range Editor", 0, 0, new Font("SansSerif", 1, 10), new Color(0, 0, 0)));
        this.slider.setMaximumValue(100.0f);
        this.rotaryEncoder.setMaximumValue(100.0f);
        GroupLayout sliderLayout = new GroupLayout((Container)this.slider);
        this.slider.setLayout((LayoutManager)sliderLayout);
        sliderLayout.setHorizontalGroup((GroupLayout.Group)sliderLayout.createParallelGroup(1).add(0, 486, Short.MAX_VALUE));
        sliderLayout.setVerticalGroup((GroupLayout.Group)sliderLayout.createParallelGroup(1).add(0, 116, Short.MAX_VALUE));
        this.attrNameLabel.setFont(new Font("SansSerif", 1, 14));
        this.attrNameLabel.setForeground(Color.darkGray);
        this.attrNameLabel.setText("Attribute Name");
        GroupLayout jXMultiThumbSlider1Layout = new GroupLayout((Container)this.rotaryEncoder);
        this.rotaryEncoder.setLayout((LayoutManager)jXMultiThumbSlider1Layout);
        jXMultiThumbSlider1Layout.setHorizontalGroup((GroupLayout.Group)jXMultiThumbSlider1Layout.createParallelGroup(1).add(0, 84, Short.MAX_VALUE));
        jXMultiThumbSlider1Layout.setVerticalGroup((GroupLayout.Group)jXMultiThumbSlider1Layout.createParallelGroup(1).add(0, 65, Short.MAX_VALUE));
        this.visualPropertyLabel.setFont(new Font("SansSerif", 1, 14));
        this.visualPropertyLabel.setForeground(Color.darkGray);
        GroupLayout rangeSettingPanelLayout = new GroupLayout((Container)this.rangeSettingPanel);
        this.rangeSettingPanel.setLayout((LayoutManager)rangeSettingPanelLayout);
        rangeSettingPanelLayout.setHorizontalGroup((GroupLayout.Group)rangeSettingPanelLayout.createParallelGroup(1).add((GroupLayout.Group)rangeSettingPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.valueSpinner, -2, 67, -2).addPreferredGap(0, 118, Short.MAX_VALUE).add((Component)this.minMaxButton, -2, 62, -2).addPreferredGap(0).add((Component)this.addButton, -2, 55, -2).addPreferredGap(0).add((Component)this.deleteButton).add(10, 10, 10)));
        rangeSettingPanelLayout.setVerticalGroup((GroupLayout.Group)rangeSettingPanelLayout.createParallelGroup(1).add((GroupLayout.Group)rangeSettingPanelLayout.createParallelGroup(3).add((Component)this.valueSpinner, -2, -1, -2).add((Component)this.minMaxButton).add((Component)this.deleteButton).add((Component)this.addButton, -2, -1, -2)));
        GroupLayout layout = new GroupLayout((Container)mainPanel);
        mainPanel.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.rangeSettingPanel, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.iconPanel, -2, -1, -2).add((Component)this.belowPanel, -2, -1, -2).add((Component)this.slider, -1, 243, Short.MAX_VALUE).add((Component)this.abovePanel, -2, -1, -2)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.slider, -1, 145, Short.MAX_VALUE).add(2, (Component)this.iconPanel, -1, -1, Short.MAX_VALUE).add(2, (Component)this.belowPanel, -1, -1, Short.MAX_VALUE).add(2, (Component)this.abovePanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.rangeSettingPanel, -2, -1, -2)));
        this.getContentPane().add(mainPanel);
        this.pack();
    }

    protected void minMaxButtonActionPerformed(ActionEvent evt) {
        Double[] newVal = MinMaxDialog.getMinMax(EditorValueRangeTracer.getTracer().getMin(this.type), EditorValueRangeTracer.getTracer().getMax(this.type));
        if (newVal == null) {
            return;
        }
        EditorValueRangeTracer.getTracer().setMin(this.type, newVal[0]);
        EditorValueRangeTracer.getTracer().setMax(this.type, newVal[1]);
        this.updateMap();
        Cytoscape.getCurrentNetworkView().redrawGraph(false, true);
        this.repaint();
    }

    protected abstract void deleteButtonActionPerformed(ActionEvent var1);

    protected abstract void addButtonActionPerformed(ActionEvent var1);

    private void initRangeValues() {
        CyAttributes attr;
        if (this.type.isNodeProp()) {
            attr = Cytoscape.getNodeAttributes();
            this.calculator = Cytoscape.getVisualMappingManager().getVisualStyle().getNodeAppearanceCalculator().getCalculator(this.type);
        } else {
            attr = Cytoscape.getEdgeAttributes();
            this.calculator = Cytoscape.getVisualMappingManager().getVisualStyle().getEdgeAppearanceCalculator().getCalculator(this.type);
        }
        if (this.calculator == null) {
            return;
        }
        if (this.calculator.getMapping(0).getClass() == ContinuousMapping.class) {
            this.mapping = (ContinuousMapping)this.calculator.getMapping(0);
            String controllingAttrName = this.mapping.getControllingAttributeName();
            MultiHashMap mhm = attr.getMultiHashMap();
            ArrayList attrNames = new ArrayList();
            Collections.addAll(attrNames, attr.getAttributeNames());
            if (!attrNames.contains(controllingAttrName)) {
                return;
            }
            if (EditorValueRangeTracer.getTracer().getRange(this.type) == 0.0) {
                CountedIterator it = mhm.getObjectKeys(controllingAttrName);
                Double maxValue = Double.NEGATIVE_INFINITY;
                Double minValue = Double.POSITIVE_INFINITY;
                while (it.hasNext()) {
                    Object key = it.next();
                    Double val = Double.parseDouble(mhm.getAttributeValue((String)key, controllingAttrName, null).toString());
                    if (val > maxValue) {
                        maxValue = val;
                    }
                    if (!(val < minValue)) continue;
                    minValue = val;
                }
                EditorValueRangeTracer.getTracer().setMax(this.type, maxValue);
                EditorValueRangeTracer.getTracer().setMin(this.type, minValue);
            }
            this.allPoints = this.mapping.getAllPoints();
        }
    }

    protected void setSidePanelIconColor(Color below, Color above) {
        this.abovePanel.setColor(above);
        this.belowPanel.setColor(below);
        this.repaint();
    }

    protected int getSelectedPoint(int selectedIndex) {
        List thumbs = this.slider.getModel().getSortedThumbs();
        Thumb selected = this.slider.getModel().getThumbAt(selectedIndex);
        for (int i = 0; i < thumbs.size(); ++i) {
            if (thumbs.get(i) != selected) continue;
            return i;
        }
        return -1;
    }

    protected void updateMap() {
        List thumbs = this.slider.getModel().getSortedThumbs();
        double min = EditorValueRangeTracer.getTracer().getMin(this.type);
        double range = EditorValueRangeTracer.getTracer().getRange(this.type);
        if (thumbs.size() == 1) {
            this.mapping.getPoint((int)0).getRange().equalValue = ((Thumb)thumbs.get(0)).getObject();
            this.mapping.getPoint((int)0).getRange().lesserValue = this.below;
            this.mapping.getPoint((int)0).getRange().greaterValue = this.above;
            Double newVal = (double)(((Thumb)thumbs.get(0)).getPosition() / 100.0f) * range + min;
            this.mapping.getPoint(0).setValue(newVal);
            return;
        }
        int size = thumbs.size();
        for (int i = 0; i < size; ++i) {
            Thumb t = (Thumb)thumbs.get(i);
            BoundaryRangeValues rg = this.mapping.getPoint(i).getRange();
            if (i == 0) {
                rg.lesserValue = this.below;
                rg.greaterValue = t.getObject();
            } else if (i == thumbs.size() - 1) {
                rg.greaterValue = this.above;
                rg.lesserValue = t.getObject();
            } else {
                rg.lesserValue = t.getObject();
                rg.greaterValue = t.getObject();
            }
            Double newVal = (double)(t.getPosition() / 100.0f) * range + min;
            this.mapping.getPoint(i).setValue(newVal);
            rg.equalValue = t.getObject();
        }
    }

    class SpinnerChangeListener
    implements ChangeListener {
        SpinnerChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            Number newVal = ContinuousMappingEditorPanel.this.spinnerModel.getNumber();
            int selectedIndex = ContinuousMappingEditorPanel.this.slider.getSelectedIndex();
            if (0 <= selectedIndex && ContinuousMappingEditorPanel.this.slider.getModel().getThumbCount() > 1) {
                if (newVal.doubleValue() < EditorValueRangeTracer.getTracer().getMin(ContinuousMappingEditorPanel.this.type) || newVal.doubleValue() > EditorValueRangeTracer.getTracer().getMax(ContinuousMappingEditorPanel.this.type)) {
                    if (ContinuousMappingEditorPanel.this.lastSpinnerNumber > EditorValueRangeTracer.getTracer().getMin(ContinuousMappingEditorPanel.this.type) && ContinuousMappingEditorPanel.this.lastSpinnerNumber < EditorValueRangeTracer.getTracer().getMax(ContinuousMappingEditorPanel.this.type)) {
                        ContinuousMappingEditorPanel.this.spinnerModel.setValue(ContinuousMappingEditorPanel.this.lastSpinnerNumber);
                    } else {
                        ContinuousMappingEditorPanel.this.spinnerModel.setValue(0);
                    }
                    return;
                }
                Double newPosition = ((double)newVal.floatValue() - EditorValueRangeTracer.getTracer().getMin(ContinuousMappingEditorPanel.this.type)) / EditorValueRangeTracer.getTracer().getRange(ContinuousMappingEditorPanel.this.type);
                ContinuousMappingEditorPanel.this.slider.getModel().getThumbAt(selectedIndex).setPosition(newPosition.floatValue() * 100.0f);
                ContinuousMappingEditorPanel.this.slider.getSelectedThumb().setLocation((int)((double)(ContinuousMappingEditorPanel.this.slider.getSize().width - 12) * newPosition), 0);
                ContinuousMappingEditorPanel.this.updateMap();
                Cytoscape.getVisualMappingManager().getNetworkView().redrawGraph(false, true);
                ContinuousMappingEditorPanel.this.slider.getSelectedThumb().repaint();
                ContinuousMappingEditorPanel.this.slider.getParent().repaint();
                ContinuousMappingEditorPanel.this.slider.repaint();
                ContinuousMappingEditorPanel.this.lastSpinnerNumber = newVal.doubleValue();
            }
        }
    }

    protected class ThumbMouseListener
    extends MouseAdapter {
        protected ThumbMouseListener() {
        }

        public void mouseReleased(MouseEvent e) {
            int selectedIndex = ContinuousMappingEditorPanel.this.slider.getSelectedIndex();
            if (0 <= selectedIndex && ContinuousMappingEditorPanel.this.slider.getModel().getThumbCount() > 0) {
                ContinuousMappingEditorPanel.this.valueSpinner.setEnabled(true);
                Double newVal = (double)(ContinuousMappingEditorPanel.this.slider.getModel().getThumbAt(selectedIndex).getPosition() / 100.0f) * EditorValueRangeTracer.getTracer().getRange(ContinuousMappingEditorPanel.this.type) + EditorValueRangeTracer.getTracer().getMin(ContinuousMappingEditorPanel.this.type);
                ContinuousMappingEditorPanel.this.valueSpinner.setValue(newVal);
                ContinuousMappingEditorPanel.this.updateMap();
                ContinuousMappingEditorPanel.this.slider.repaint();
                ContinuousMappingEditorPanel.this.repaint();
                Cytoscape.getVisualMappingManager().getNetworkView().redrawGraph(false, true);
            } else {
                ContinuousMappingEditorPanel.this.valueSpinner.setEnabled(false);
                ContinuousMappingEditorPanel.this.valueSpinner.setValue(0);
            }
        }
    }
}

