/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui.editors.continuous;

import cytoscape.Cytoscape;
import cytoscape.logger.CyLogger;
import cytoscape.util.CyColorChooser;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.mappings.BoundaryRangeValues;
import cytoscape.visual.mappings.ContinuousMapping;
import cytoscape.visual.mappings.continuous.ContinuousMappingPoint;
import cytoscape.visual.ui.editors.continuous.BelowAndAbovePanel;
import cytoscape.visual.ui.editors.continuous.ContinuousMappingEditorPanel;
import cytoscape.visual.ui.editors.continuous.CyGradientTrackRenderer;
import cytoscape.visual.ui.editors.continuous.EditorValueRangeTracer;
import cytoscape.visual.ui.editors.continuous.TriangleThumbRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.multislider.ThumbRenderer;
import org.jdesktop.swingx.multislider.TrackRenderer;

public class GradientEditorPanel
extends ContinuousMappingEditorPanel
implements PropertyChangeListener {
    private static final Color DEF_LOWER_COLOR = Color.BLACK;
    private static final Color DEF_UPPER_COLOR = Color.WHITE;

    public GradientEditorPanel(VisualPropertyType type) {
        super(type);
        this.iconPanel.setVisible(false);
        this.initSlider();
        this.belowPanel.addPropertyChangeListener(this);
        this.abovePanel.addPropertyChangeListener(this);
        if (this.mapping != null && this.mapping.getPointCount() == 0) {
            this.addButtonActionPerformed(null);
        }
    }

    public static Object showDialog(int width, int height, String title, VisualPropertyType type) {
        editor = new GradientEditorPanel(type);
        editor.setSize(new Dimension(width, height));
        editor.setTitle(title);
        editor.setAlwaysOnTop(true);
        editor.setLocationRelativeTo(Cytoscape.getDesktop());
        editor.setVisible(true);
        editor.repaint();
        return editor;
    }

    public static ImageIcon getLegend(int width, int height, VisualPropertyType type) {
        editor = new GradientEditorPanel(type);
        CyGradientTrackRenderer rend = (CyGradientTrackRenderer)GradientEditorPanel.editor.slider.getTrackRenderer();
        rend.getRendererComponent(GradientEditorPanel.editor.slider);
        return rend.getLegend(width, height);
    }

    public static ImageIcon getIcon(int iconWidth, int iconHeight, VisualPropertyType type) {
        editor = new GradientEditorPanel(type);
        CyGradientTrackRenderer rend = (CyGradientTrackRenderer)GradientEditorPanel.editor.slider.getTrackRenderer();
        rend.getRendererComponent(GradientEditorPanel.editor.slider);
        return rend.getTrackGraphicIcon(iconWidth, iconHeight);
    }

    protected void addButtonActionPerformed(ActionEvent evt) {
        double maxValue = EditorValueRangeTracer.getTracer().getMax(this.type);
        if (this.mapping.getPointCount() == 0) {
            double rangeValue = EditorValueRangeTracer.getTracer().getRange(this.type);
            double minValue = EditorValueRangeTracer.getTracer().getMin(this.type);
            this.slider.getModel().addThumb(10.0f, (Object)DEF_LOWER_COLOR);
            this.slider.getModel().addThumb(90.0f, (Object)DEF_UPPER_COLOR);
            BoundaryRangeValues lowerRange = new BoundaryRangeValues(this.below, DEF_LOWER_COLOR, DEF_LOWER_COLOR);
            BoundaryRangeValues upperRange = new BoundaryRangeValues(DEF_UPPER_COLOR, DEF_UPPER_COLOR, this.above);
            this.mapping.addPoint(rangeValue * 0.1 + minValue, lowerRange);
            this.mapping.addPoint(rangeValue * 0.9 + minValue, upperRange);
            Cytoscape.getVisualMappingManager().getNetworkView().redrawGraph(false, true);
            this.slider.repaint();
            this.repaint();
            return;
        }
        this.slider.getModel().addThumb(100.0f, (Object)Color.white);
        ContinuousMappingPoint previousPoint = this.mapping.getPoint(this.mapping.getPointCount() - 1);
        BoundaryRangeValues previousRange = previousPoint.getRange();
        BoundaryRangeValues lowerRange = new BoundaryRangeValues(previousRange);
        lowerRange.lesserValue = this.slider.getModel().getSortedThumbs().get(this.slider.getModel().getThumbCount() - 1);
        CyLogger.getLogger().info("EQ color = " + lowerRange.lesserValue);
        lowerRange.equalValue = Color.white;
        lowerRange.greaterValue = previousRange.greaterValue;
        this.mapping.addPoint(maxValue, lowerRange);
        this.updateMap();
        Cytoscape.getVisualMappingManager().getNetworkView().redrawGraph(false, true);
        this.slider.repaint();
        this.repaint();
    }

    protected void deleteButtonActionPerformed(ActionEvent evt) {
        int selectedIndex = this.slider.getSelectedIndex();
        if (0 <= selectedIndex) {
            this.slider.getModel().removeThumb(selectedIndex);
            this.mapping.removePoint(selectedIndex);
            this.updateMap();
            this.mapping.fireStateChanged();
            Cytoscape.getVisualMappingManager().getNetworkView().redrawGraph(false, true);
            this.repaint();
        }
    }

    private void setColor(Color newColor) {
        this.slider.getModel().getThumbAt(this.slider.getSelectedIndex()).setObject((Object)newColor);
        ContinuousMapping cMapping = this.mapping;
        int selected = this.getSelectedPoint(this.slider.getSelectedIndex());
        cMapping.getPoint((int)selected).getRange().equalValue = newColor;
        BoundaryRangeValues brv = new BoundaryRangeValues(cMapping.getPoint((int)selected).getRange().lesserValue, newColor, cMapping.getPoint((int)selected).getRange().greaterValue);
        cMapping.getPoint(selected).setRange(brv);
        int numPoints = cMapping.getAllPoints().size();
        if (numPoints > 1) {
            if (selected == 0) {
                brv.greaterValue = newColor;
            } else if (selected == numPoints - 1) {
                brv.lesserValue = newColor;
            } else {
                brv.lesserValue = newColor;
                brv.greaterValue = newColor;
            }
            cMapping.fireStateChanged();
            Cytoscape.getVisualMappingManager().getNetworkView().redrawGraph(false, true);
            this.slider.repaint();
        }
    }

    public void initSlider() {
        Dimension dim = new Dimension(600, 100);
        this.setPreferredSize(dim);
        this.setSize(dim);
        this.setMinimumSize(new Dimension(300, 80));
        this.slider.updateUI();
        this.slider.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                JComponent selectedThumb;
                if (!SwingUtilities.isRightMouseButton(e) && (selectedThumb = GradientEditorPanel.this.slider.getSelectedThumb()) != null) {
                    Color newColor;
                    Point location = selectedThumb.getLocation();
                    double diff = Math.abs(location.getX() - (double)e.getX());
                    if (e.getClickCount() == 2 && (newColor = CyColorChooser.showDialog((Component)GradientEditorPanel.this.slider, "Choose new color...", Color.white)) != null) {
                        GradientEditorPanel.this.setColor(newColor);
                    }
                }
            }
        });
        double actualRange = EditorValueRangeTracer.getTracer().getRange(this.type);
        double minValue = EditorValueRangeTracer.getTracer().getMin(this.type);
        if (this.allPoints != null) {
            for (ContinuousMappingPoint point : this.allPoints) {
                BoundaryRangeValues bound = point.getRange();
                this.slider.getModel().addThumb(Double.valueOf((point.getValue() - minValue) / actualRange).floatValue() * 100.0f, (Object)((Color)bound.equalValue));
            }
            if (this.allPoints.size() != 0) {
                this.below = (Color)((ContinuousMappingPoint)this.allPoints.get((int)0)).getRange().lesserValue;
                this.above = (Color)((ContinuousMappingPoint)this.allPoints.get((int)(this.allPoints.size() - 1))).getRange().greaterValue;
            } else {
                this.below = Color.black;
                this.above = Color.white;
            }
            this.setSidePanelIconColor((Color)this.below, (Color)this.above);
        }
        TriangleThumbRenderer thumbRend = new TriangleThumbRenderer(this.slider);
        CyGradientTrackRenderer gRend = new CyGradientTrackRenderer(this.type, (Color)this.below, (Color)this.above, this.mapping.getControllingAttributeName());
        this.slider.setThumbRenderer((ThumbRenderer)thumbRend);
        this.slider.setTrackRenderer((TrackRenderer)gRend);
        this.slider.addMouseListener((MouseListener)new ContinuousMappingEditorPanel.ThumbMouseListener());
        this.slider.setToolTipText("Double-click handles to edit boundary colors.");
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("COLOR_CHANGED")) {
            String sourceName = ((BelowAndAbovePanel)e.getSource()).getName();
            if (sourceName.equals("abovePanel")) {
                this.above = e.getNewValue();
            } else {
                this.below = e.getNewValue();
            }
            CyGradientTrackRenderer gRend = new CyGradientTrackRenderer(this.type, (Color)this.below, (Color)this.above, this.mapping.getControllingAttributeName());
            this.slider.setTrackRenderer((TrackRenderer)gRend);
            this.repaint();
        }
    }
}

