/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui.icon;

import cytoscape.Cytoscape;
import cytoscape.visual.LineStyle;
import cytoscape.visual.LineType;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.ui.icon.VisualPropertyIcon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import javax.swing.SwingUtilities;

public class LineTypeIcon
extends VisualPropertyIcon {
    private BasicStroke stroke;
    protected Graphics2D g2d;
    private String superimposedText = null;
    private Font textFont = null;
    private Color textColor = null;

    public LineTypeIcon() {
        this((BasicStroke)((LineType)VisualPropertyType.EDGE_LINETYPE.getDefault(Cytoscape.getVisualMappingManager().getVisualStyle())).getStroke(), 96, 32, ((LineType)VisualPropertyType.EDGE_LINETYPE.getDefault(Cytoscape.getVisualMappingManager().getVisualStyle())).getType().toString(), (Color)VisualPropertyType.EDGE_COLOR.getDefault(Cytoscape.getVisualMappingManager().getVisualStyle()));
    }

    public LineTypeIcon(Object lineType) {
        this((BasicStroke)((LineType)lineType).getStroke(), 96, 32, ((LineType)lineType).getType().toString(), (Color)VisualPropertyType.EDGE_COLOR.getDefault(Cytoscape.getVisualMappingManager().getVisualStyle()));
    }

    public LineTypeIcon(LineStyle style) {
        this(style.getStroke(2.0f), 96, 32, style.name());
    }

    public LineTypeIcon(Stroke stroke, int width, int height, String name) {
        super(null, width, height, name);
        this.stroke = (BasicStroke)stroke;
    }

    public LineTypeIcon(Stroke stroke, int width, int height, String name, Color color) {
        super(null, width, height, name, color);
        float lineWidth = ((Number)VisualPropertyType.EDGE_LINE_WIDTH.getDefault(Cytoscape.getVisualMappingManager().getVisualStyle())).floatValue();
        BasicStroke st = (BasicStroke)stroke;
        this.stroke = st != null && st.getDashArray() != null ? new BasicStroke(lineWidth, 0, 0, st.getMiterLimit(), st.getDashArray(), st.getDashPhase()) : new BasicStroke(lineWidth, 0, 0);
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.g2d = (Graphics2D)g;
        this.g2d.setColor(this.color);
        this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2d.translate(this.leftPad, this.bottomPad);
        Object dashDef = null;
        this.g2d.setStroke(this.stroke);
        this.g2d.draw(new Line2D.Double(20.0, (this.height + 20) / 2, this.width, (this.height + 20) / 2));
        if (this.superimposedText != null) {
            int strWidth = SwingUtilities.computeStringWidth(this.g2d.getFontMetrics(), this.superimposedText);
            if (this.textColor == null) {
                this.g2d.setColor(Color.DARK_GRAY);
            } else {
                this.g2d.setColor(this.textColor);
            }
            if (this.textFont == null) {
                this.g2d.setFont(new Font("SansSerif", 1, 24));
            } else {
                this.g2d.setFont(this.textFont);
            }
            this.g2d.drawString(this.superimposedText, 20, (this.height + 40) / 2);
        }
        this.g2d.translate(-this.leftPad, -this.bottomPad);
        this.g2d.setFont(new Font("SansSerif", 1, 14));
    }

    public void setText(String text) {
        this.superimposedText = text;
    }

    public void setTextFont(Font font) {
        this.textFont = font;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }
}

