/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import weka.gui.DatabaseConnectionDialog;
import weka.gui.ListSelectorDialog;
import weka.gui.sql.DbUtils;
import weka.gui.sql.event.ConnectionEvent;
import weka.gui.sql.event.ConnectionListener;
import weka.gui.sql.event.HistoryChangedEvent;
import weka.gui.sql.event.HistoryChangedListener;

public class ConnectionPanel
extends JPanel
implements CaretListener {
    static final long serialVersionUID = 3499317023969723490L;
    public static final String HISTORY_NAME = "connection";
    protected JFrame m_Parent = null;
    protected DatabaseConnectionDialog m_DbDialog;
    protected String m_URL = "";
    protected String m_User = "";
    protected String m_Password = "";
    protected JLabel m_LabelURL = new JLabel("URL ");
    protected JTextField m_TextURL = new JTextField(40);
    protected JButton m_ButtonDatabase = new JButton("User...");
    protected JButton m_ButtonConnect = new JButton("Connect");
    protected JButton m_ButtonHistory = new JButton("History...");
    protected HashSet m_ConnectionListeners;
    protected HashSet m_HistoryChangedListeners;
    protected DbUtils m_DbUtils;
    protected DefaultListModel m_History = new DefaultListModel();

    public ConnectionPanel(JFrame jFrame) {
        this.m_Parent = jFrame;
        this.m_ConnectionListeners = new HashSet();
        this.m_HistoryChangedListeners = new HashSet();
        try {
            this.m_DbUtils = new DbUtils();
            this.m_URL = this.m_DbUtils.getDatabaseURL();
            this.m_User = this.m_DbUtils.getUsername();
            this.m_Password = this.m_DbUtils.getPassword();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.m_URL = "";
            this.m_User = "";
            this.m_Password = "";
        }
        this.createPanel();
    }

    protected void createPanel() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout());
        this.add((Component)jPanel, "West");
        this.m_LabelURL.setLabelFor(this.m_ButtonDatabase);
        this.m_LabelURL.setDisplayedMnemonic('U');
        jPanel.add(this.m_LabelURL);
        this.m_TextURL.setText(this.m_URL);
        this.m_TextURL.addCaretListener(this);
        jPanel.add(this.m_TextURL);
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel.add(jPanel2);
        this.m_ButtonDatabase.setMnemonic('s');
        this.m_ButtonDatabase.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionPanel.this.showDialog();
            }
        });
        jPanel2.add(this.m_ButtonDatabase);
        this.m_ButtonConnect.setMnemonic('n');
        this.m_ButtonConnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionPanel.this.connect();
            }
        });
        jPanel2.add(this.m_ButtonConnect);
        this.m_ButtonHistory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionPanel.this.showHistory();
            }
        });
        jPanel2.add(this.m_ButtonHistory);
        this.setButtons();
    }

    protected void setButtons() {
        boolean bl = this.m_TextURL.getText().equals("");
        this.m_ButtonConnect.setEnabled(!bl);
        this.m_ButtonDatabase.setEnabled(!bl);
        this.m_ButtonHistory.setEnabled(this.m_History.size() > 0);
    }

    public void clear() {
        this.setURL(this.m_DbUtils.getDatabaseURL());
        this.setUser(this.m_DbUtils.getUsername());
        this.setPassword(this.m_DbUtils.getPassword());
    }

    public void setFocus() {
        this.m_TextURL.requestFocus();
    }

    public void setURL(String string) {
        this.m_URL = string;
        this.m_TextURL.setText(string);
    }

    public String getURL() {
        this.m_URL = this.m_TextURL.getText();
        return this.m_URL;
    }

    public void setUser(String string) {
        this.m_User = string;
    }

    public String getUser() {
        return this.m_User;
    }

    public void setPassword(String string) {
        this.m_Password = string;
    }

    public String getPassword() {
        return this.m_Password;
    }

    protected void addHistory(String string) {
        if (string.equals("")) {
            return;
        }
        if (this.m_History.contains(string)) {
            this.m_History.removeElement(string);
        }
        this.m_History.add(0, string);
        this.notifyHistoryChangedListeners();
    }

    public void setHistory(DefaultListModel defaultListModel) {
        this.m_History.clear();
        for (int i = 0; i < defaultListModel.size(); ++i) {
            this.m_History.addElement(defaultListModel.get(i));
        }
        this.setButtons();
    }

    public DefaultListModel getHistory() {
        return this.m_History;
    }

    protected void showDialog() {
        this.m_DbDialog = new DatabaseConnectionDialog((Frame)this.m_Parent, this.getURL(), this.getUser(), false);
        this.m_DbDialog.setVisible(true);
        if (this.m_DbDialog.getReturnValue() == 0) {
            this.setURL(this.m_DbDialog.getURL());
            this.setUser(this.m_DbDialog.getUsername());
            this.setPassword(this.m_DbDialog.getPassword());
        }
        this.setButtons();
    }

    protected void connect() {
        if (this.m_DbUtils.isConnected()) {
            try {
                this.m_DbUtils.disconnectFromDatabase();
                this.notifyConnectionListeners(1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.notifyConnectionListeners(1, exception);
            }
        }
        try {
            this.m_DbUtils.setDatabaseURL(this.getURL());
            this.m_DbUtils.setUsername(this.getUser());
            this.m_DbUtils.setPassword(this.getPassword());
            this.m_DbUtils.connectToDatabase();
            this.notifyConnectionListeners(0);
            this.addHistory(this.getUser() + "@" + this.getURL());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.notifyConnectionListeners(0, exception);
        }
        this.setButtons();
    }

    public void showHistory() {
        JList jList = new JList(this.m_History);
        ListSelectorDialog listSelectorDialog = new ListSelectorDialog((Frame)this.m_Parent, jList);
        if (listSelectorDialog.showDialog() == 0 && jList.getSelectedValue() != null) {
            String string = jList.getSelectedValue().toString();
            if (string.indexOf("@") > -1) {
                this.setUser(string.substring(0, string.indexOf("@")));
                this.setURL(string.substring(string.indexOf("@") + 1));
                this.showDialog();
            } else {
                this.setUser("");
                this.setURL(string);
            }
        }
        this.setButtons();
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        this.m_ConnectionListeners.add(connectionListener);
    }

    public void removeConnectionListener(ConnectionListener connectionListener) {
        this.m_ConnectionListeners.remove(connectionListener);
    }

    protected void notifyConnectionListeners(int n) {
        this.notifyConnectionListeners(n, null);
    }

    protected void notifyConnectionListeners(int n, Exception exception) {
        for (ConnectionListener connectionListener : this.m_ConnectionListeners) {
            connectionListener.connectionChange(new ConnectionEvent(this, n, this.m_DbUtils, exception));
        }
    }

    public void addHistoryChangedListener(HistoryChangedListener historyChangedListener) {
        this.m_HistoryChangedListeners.add(historyChangedListener);
    }

    public void removeHistoryChangedListener(HistoryChangedListener historyChangedListener) {
        this.m_HistoryChangedListeners.remove(historyChangedListener);
    }

    protected void notifyHistoryChangedListeners() {
        for (HistoryChangedListener historyChangedListener : this.m_HistoryChangedListeners) {
            historyChangedListener.historyChanged(new HistoryChangedEvent(this, HISTORY_NAME, this.getHistory()));
        }
    }

    public void caretUpdate(CaretEvent caretEvent) {
        this.setButtons();
    }
}

