package org.baderlab.pdzsvm.data;

import org.baderlab.pdzsvm.data.manager.DataFileManager;
import org.baderlab.pdzsvm.utils.Constants;
import org.baderlab.pdzsvm.utils.PDZSVMUtils;

import java.util.List;


/**
 * Copyright (c) 2010 University of Toronto
 * Code written by: Shirley Hui
 * Authors: Shirley Hui, Gary Bader
 *
 * This file is part of PDZSVM.
 *
 * PDZSVM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PDZSVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  The software and
 * documentation provided hereunder is on an "as is" basis, and the
 * University of Toronto has no obligations to provide maintenance,
 * support, updates, enhancements or modifications.  In no event shall
 * the University of Toronto be liable to any party for direct, indirect,
 * special, incidental or consequential damages, including lost profits,
 * arising out of the use of this software and its documentation, even if
 * the University of Toronto has been advised of the possibility of such
 * damage. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PDZSVM.  If not, see <http://www.gnu.org/licenses/>.
 */
public class DataRepository
{

    // Phage Display
    public List humanPosPDList;
    public List humanPosPDTestList;

    public List wormPosPDTestList;
    public List humanPosSidhuPDList;
    public List humanPosPDGenomicList;  //  Non specific + Genomic only
    public List humanPosPDNonGenomicList; //  Non specific + Non Genomic only


    // Protein Microarray
    public List mousePosPMStifflerList; // Stiffler
    public List mouseNegPMStifflerList; // Stiffler

    public List mousePosPMChenList; // Chen
    public List mouseNegPMChenList; // Chen

    public List mousePosPMOrphanList;
    public List mouseNegPMOrphanList;
    public List wormPosPMList;
    public List wormNegPMList;
    public List flyPosPMList;
    public List flyNegPMList;

    public String codonBiasFile = null;

    // Training
    // Phage Display
    public String humanPosPDFile = null;

    // Stiffler
    public String mousePosPMStifflerFile = null;
    public String mouseNegPMStifflerFile = null;
    // Chen
    public String mousePosPMChenFile = null;
    public String mouseNegPMChenFile = null;

    // Testing
    // Protein Microarray
    public String mousePosPMOrphanFile = null;
    public String mouseNegPMOrphanFile = null;
    public String flyPosPMFile = null;
    public String flyNegPMFile = null;
    public String wormPosPMFile = null;
    public String wormNegPMFile = null;

    // Phage Display
    public String humanPosPDBothFile = null;
    public String humanPosPDGenomicFile = null;
    public String humanPosPDNonGenomicFile = null;
    public String humanPosSidhuPDFile = null;

    private static  DataRepository ref = null;

    public static DataRepository getInstance()
    {
        if (ref == null)


          // it's ok, we can call this constructor

          ref = new DataRepository();

      return ref;
    }
    private DataRepository()
    {
        System.out.println("\tInitializing data repository...");
        DataFileManager df = new DataFileManager();

        codonBiasFile = DataFileManager.NNK_CODON_BIAS_FILENAME;
        mousePosPMStifflerFile = df.getDataFile(Constants.MOUSE, Constants.STIFFLER_MOUSE, Constants.CLASS_YES);
        mouseNegPMStifflerFile = df.getDataFile(Constants.MOUSE, Constants.STIFFLER_MOUSE, Constants.CLASS_NO);

        humanPosPDFile = df.getDataFile(Constants.HUMAN, Constants.PHAGE_DISPLAY, Constants.CLASS_YES);
        mousePosPMChenFile = df.getDataFile(Constants.MOUSE, Constants.CHEN_MOUSE, Constants.CLASS_YES);
        mouseNegPMChenFile = df.getDataFile(Constants.MOUSE, Constants.CHEN_MOUSE, Constants.CLASS_NO);
        humanPosSidhuPDFile = df.getDataFile(Constants.SIDHU_HUMAN, Constants.PHAGE_DISPLAY, Constants.CLASS_YES);
        humanPosPDGenomicFile = df.getDataFile(Constants.HUMAN, Constants.GENOMIC, Constants.CLASS_YES);
        humanPosPDNonGenomicFile = df.getDataFile(Constants.HUMAN, Constants.NON_GENOMIC, Constants.CLASS_YES);

        mousePosPMOrphanFile = df.getDataFile(Constants.MOUSE, Constants.MOUSE_ORPHAN, Constants.CLASS_YES);
        mouseNegPMOrphanFile = df.getDataFile(Constants.MOUSE, Constants.MOUSE_ORPHAN, Constants.CLASS_NO);
        wormPosPMFile = df.getDataFile(Constants.WORM, Constants.PROTEIN_MICROARRAY, Constants.CLASS_YES);
        wormNegPMFile = df.getDataFile(Constants.WORM, Constants.PROTEIN_MICROARRAY, Constants.CLASS_NO);
        flyPosPMFile = df.getDataFile(Constants.FLY, Constants.PROTEIN_MICROARRAY, Constants.CLASS_YES);
        flyNegPMFile = df.getDataFile(Constants.FLY, Constants.PROTEIN_MICROARRAY, Constants.CLASS_NO);
        initProfileLists();



    }
    private void initProfileLists()
    {
        int numPositions = Constants.NUM_RES_POS;

        wormPosPMList = PDZSVMUtils.readProteinProfileList(wormPosPMFile,codonBiasFile,numPositions, false);
        wormNegPMList = PDZSVMUtils.readProteinProfileList(wormNegPMFile,codonBiasFile,numPositions, false);
        mousePosPMOrphanList = PDZSVMUtils.readProteinProfileList(mousePosPMOrphanFile,codonBiasFile,numPositions, false);
        mouseNegPMOrphanList = PDZSVMUtils.readProteinProfileList(mouseNegPMOrphanFile,codonBiasFile,numPositions, false);
        flyPosPMList = PDZSVMUtils.readProteinProfileList(flyPosPMFile,codonBiasFile,numPositions, false);
        flyNegPMList = PDZSVMUtils.readProteinProfileList(flyNegPMFile,codonBiasFile,numPositions, false);

        mousePosPMStifflerList = PDZSVMUtils.readProteinProfileList(mousePosPMStifflerFile,codonBiasFile,numPositions);
        mouseNegPMStifflerList = PDZSVMUtils.readProteinProfileList(mouseNegPMStifflerFile,codonBiasFile,numPositions);
        mousePosPMChenList = PDZSVMUtils.readProteinProfileList(mousePosPMChenFile,codonBiasFile,numPositions);
        mouseNegPMChenList = PDZSVMUtils.readProteinProfileList(mouseNegPMChenFile,codonBiasFile,numPositions);

        // Phage Display
        humanPosPDList = PDZSVMUtils.readProteinProfileList(humanPosPDFile,codonBiasFile,numPositions);
        humanPosSidhuPDList = PDZSVMUtils.readProteinProfileList(humanPosSidhuPDFile,codonBiasFile,numPositions);
        humanPosPDGenomicList = PDZSVMUtils.readProteinProfileList(humanPosPDGenomicFile,codonBiasFile,numPositions);
        humanPosPDNonGenomicList = PDZSVMUtils.readProteinProfileList(humanPosPDNonGenomicFile,codonBiasFile,numPositions);
       

    }
    public Object clone()
            throws CloneNotSupportedException
    {
        throw new CloneNotSupportedException();
    }


}
