package org.baderlab.pdzsvm.optimize;

import java.util.*;
import org.baderlab.pdzsvm.evaluation.Evaluation;

/**
 * Copyright (c) 2010 University of Toronto
 * Code written by: Shirley Hui
 * Authors: Shirley Hui, Gary Bader
 *
 * This file is part of PDZSVM.
 *
 * PDZSVM is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PDZSVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  The software and
 * documentation provided hereunder is on an "as is" basis, and the
 * University of Toronto has no obligations to provide maintenance,
 * support, updates, enhancements or modifications.  In no event shall
 * the University of Toronto be liable to any party for direct, indirect,
 * special, incidental or consequential damages, including lost profits,
 * arising out of the use of this software and its documentation, even if
 * the University of Toronto has been advised of the possibility of such
 * damage. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PDZSVM.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Utility methods pertinant to grid searching
 */
public class GridSearchUtils
{

    public static double toLnC(double value)
    {
        return Math.log(value);
    }
    public static  double toLnG(double value)
    {
        return -1*Math.log(value)-Math.log(2);
    }
    public static  double[] getG(double[] lnG)
    {
        double[] G = new double[lnG.length];
        for(int i=0; i < G.length;i++)
        {
            G[i] = Math.exp(-1*Math.log(2)-lnG[i]);
        }
        return G;
    }
    public static  double[] getC(double[] lnC)
    {
        double[] C = new double[lnC.length];
        for (int i=0;i < C.length;i++)
        {
            C[i]= Math.exp(lnC[i]);
        }
        return C;
    }

    public static  GridResult computeAvgGridResult(HashMap cvResultsMap)
    {
        Set keys = cvResultsMap.keySet();
        Iterator it = keys.iterator();
        double avgROCAUC =  0.0;
        double avgPRAUC =  0.0;

        double avgSens = 0.0;
        double avgSpec = 0.0;
        double avgFMeasure = 0.0;
        double avgMCC = 0.0;
        double avgTPrec = 0.0;
        double avgFPrec = 0.0;

        double avgTFMeasure = 0.0;
        double avgFFMeasure = 0.0;
        double avgAccuracy = 0.0;
        int num = keys.size();
        while(it.hasNext())
        {
            List foldPredictionList = (List) cvResultsMap.get(it.next());
            Evaluation eval = new Evaluation(foldPredictionList);
            double rocAUC =  eval.getROCAUC();
            double prAUC =  eval.getPRAUC();

            double sens = eval.recall(0);
            double spec = eval.recall(1);
            double fMeasure = eval.fMeasure();
            double tFMeasure = eval.fMeasure(0);
            double fFMeasure = eval.fMeasure(1);
            double mcc = eval.mcc(0);
            double tPrec = eval.precision(0);
            double fPrec = eval.precision(1);

            double numTrue = eval.numTrueNegatives(0) + eval.numTruePositives(0);
            double total = eval.numTrueNegatives(0)+eval.numTruePositives(0) +
                eval.numFalsePositives(0) + eval.numFalseNegatives(0);
            double accuracy = numTrue/total;

            avgROCAUC = avgROCAUC +rocAUC;
            avgPRAUC = avgPRAUC +prAUC;

            avgSens = avgSens +sens;
            avgSpec = avgSpec +spec;
            avgFMeasure = avgFMeasure +fMeasure;
            avgMCC = avgMCC +mcc;
            avgTPrec = avgTPrec +tPrec;
            avgFPrec = avgFPrec +fPrec;
            avgTFMeasure = avgTFMeasure +tFMeasure;
            avgFFMeasure = avgFFMeasure +fFMeasure;
            avgAccuracy = avgAccuracy + accuracy;

        }
        avgROCAUC = avgROCAUC/num;
        avgPRAUC = avgPRAUC/num;

        avgSens = avgSens/num;
        avgSpec = avgSpec/num;
        avgFMeasure = avgFMeasure/num;
        avgMCC = avgMCC/num;
        avgTPrec = avgTPrec/num;
        avgFPrec = avgFPrec/num;
        avgTFMeasure = avgTFMeasure/num;
        avgFFMeasure = avgFFMeasure/num;
        avgAccuracy = avgAccuracy/num;

        GridResult avgResult = new GridResult();
        avgResult.rocAUC = avgROCAUC;
        avgResult.prAUC = avgPRAUC;
        avgResult.spec = avgSpec;
        avgResult.sens = avgSens;
        avgResult.tPrec = avgTPrec;
        avgResult.fPrec = avgFPrec;
        avgResult.tFMeasure = avgTFMeasure;
        avgResult.fFMeasure = avgFFMeasure;
        avgResult.fMeasure =avgFMeasure;
        avgResult.mcc = avgMCC;
        avgResult.accuracy = avgAccuracy;
        return avgResult;
    }
}
